/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.internal.document.AbstractExternalizerTest;
import org.infinispan.schematic.internal.document.BasicArray;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.junit.Assert;
import org.junit.Test;

public class ArrayExternalizerTest
extends AbstractExternalizerTest {
    @Test
    public void shouldRoundTripSimpleArrayOfStrings() throws Exception {
        BasicArray array = new BasicArray();
        array.addValue((Object)"value1");
        array.addValue((Object)"value2");
        array.addValue((Object)"value3");
        this.assertRoundTrip((Array)array);
    }

    @Test
    public void shouldRoundTripSimpleArrayOfMixedValues() throws Exception {
        BasicArray array = new BasicArray();
        array.addValue((Object)"value1");
        array.addValue((Object)43);
        array.addValue((Object)new BasicDocument("field1", (Object)"value1"));
        this.assertRoundTrip((Array)array);
    }

    protected void assertRoundTrip(Array array) throws Exception {
        byte[] bytes = this.marshall(array);
        Array newArray = (Array)this.unmarshall(bytes);
        Assert.assertThat((Object)newArray, (Matcher)Is.is((Object)array));
    }
}

