/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.infinispan.schematic.AbstractSchematicDbTest;
import org.infinispan.schematic.FixFor;
import org.infinispan.schematic.SchemaLibrary;
import org.infinispan.schematic.SchemaValidationTest;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Json;
import org.infinispan.schematic.internal.document.BasicDocument;
import org.junit.Assert;
import org.junit.Test;

public class SchematicDbTest
extends AbstractSchematicDbTest {
    protected static InputStream resource(String resourcePath) {
        InputStream result = SchemaValidationTest.class.getClassLoader().getResourceAsStream(resourcePath);
        assert (result != null) : "Could not find resource \"" + resourcePath + "\"";
        return result;
    }

    protected void loadSchemas() throws IOException {
        SchemaLibrary schemas = this.db.getSchemaLibrary();
        schemas.put("http://json-schema.org/draft-03/schema#", Json.read((InputStream)SchematicDbTest.resource("json/schema/draft-03/schema.json")));
        schemas.put("json/schema/spec-example.json", Json.read((InputStream)SchematicDbTest.resource("json/schema/spec-example.json")));
    }

    @Test
    public void shouldStoreDocumentWithUnusedKeyAndWithNullMetadata() {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc, null);
        Assert.assertThat((String)"Should not have found a prior entry", (Object)prior, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        SchematicEntry entry = this.db.get(key);
        Assert.assertThat((String)"Should have found the entry", (Object)entry, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Document read = entry.getContentAsDocument();
        Assert.assertThat((Object)read, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read.getInteger("k2"), (Matcher)Is.is((Object)2));
        Assert.assertThat((String)"Should not have a Binary value for the entry's content", (Object)entry.getContentAsBinary(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)read.containsAll((Document)doc), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)read.equals(doc), (Matcher)Is.is((Object)true));
        Document readMetadata = entry.getMetadata();
        Assert.assertThat((Object)readMetadata, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)readMetadata.getString("id"), (Matcher)Is.is((Object)key));
    }

    @Test
    public void shouldStoreDocumentWithUnusedKeyAndWithNonNullMetadata() {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        EditableDocument metadata = Schematic.newDocument((String)"mimeType", (Object)"text/plain");
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc, (Document)metadata);
        Assert.assertThat((String)"Should not have found a prior entry", (Object)prior, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        SchematicEntry entry = this.db.get(key);
        Assert.assertThat((String)"Should have found the entry", (Object)entry, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Document read = entry.getContentAsDocument();
        Assert.assertThat((Object)read, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read.getInteger("k2"), (Matcher)Is.is((Object)2));
        Assert.assertThat((String)"Should not have a Binary value for the entry's content", (Object)entry.getContentAsBinary(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)read.containsAll((Document)doc), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)read.equals(doc), (Matcher)Is.is((Object)true));
        Document readMetadata = entry.getMetadata();
        Assert.assertThat((Object)readMetadata, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)readMetadata.getString("mimeType"), (Matcher)Is.is((Object)metadata.getString("mimeType")));
        Assert.assertThat((Object)readMetadata.containsAll((Document)metadata), (Matcher)Is.is((Object)true));
        Assert.assertThat((String)("Expected:\n" + metadata + "\nFound: \n" + readMetadata), (Object)readMetadata.equals(metadata), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldStoreDocumentAndValidateAfterRefetching() throws Exception {
        this.loadSchemas();
        Document doc = Json.read((InputStream)SchematicDbTest.resource("json/spec-example-doc.json"));
        String key = "json/spec-example-doc.json";
        String schemaUri = "json/schema/spec-example.json";
        BasicDocument metadata = new BasicDocument("$schema", (Object)schemaUri);
        this.db.put(key, doc, (Document)metadata);
        SchemaLibrary.Results results = this.db.getSchemaLibrary().validate(doc, schemaUri);
        Assert.assertThat((String)("There are validation problems: " + results), (Object)results.hasProblems(), (Matcher)Is.is((Object)false));
        SchematicEntry actualEntry = this.db.get(key);
        Document actualMetadata = actualEntry.getMetadata();
        Document actualDocument = actualEntry.getContentAsDocument();
        Assert.assertThat((Object)actualMetadata, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)actualDocument, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((String)("The $schema in the metadata doesn't match: " + metadata), (Object)actualMetadata.getString("$schema"), (Matcher)Is.is((Object)schemaUri));
        results = this.db.validate(key);
        Assert.assertThat((String)("There are validation problems: " + results), (Object)results.hasProblems(), (Matcher)Is.is((Object)false));
        Map resultsByKey = this.db.validate(key, new String[]{"non-existant"});
        Assert.assertThat((Object)resultsByKey, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((String)("There are validation problems: " + resultsByKey.get(key)), (Object)resultsByKey.containsKey(key), (Matcher)Is.is((Object)false));
        resultsByKey = this.db.validateAll();
        Assert.assertThat((Object)resultsByKey, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((String)("There are validation problems: " + resultsByKey.get(key)), (Object)resultsByKey.containsKey(key), (Matcher)Is.is((Object)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldStoreDocumentAndFetchAndModifyAndRefetch() throws Exception {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        EditableDocument metadata = Schematic.newDocument((String)"mimeType", (Object)"text/plain");
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc, (Document)metadata);
        Assert.assertThat((String)"Should not have found a prior entry", (Object)prior, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        SchematicEntry entry = this.db.get(key);
        Assert.assertThat((String)"Should have found the entry", (Object)entry, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Document read = entry.getContentAsDocument();
        Assert.assertThat((Object)read, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read.getInteger("k2"), (Matcher)Is.is((Object)2));
        Assert.assertThat((String)"Should not have a Binary value for the entry's content", (Object)entry.getContentAsBinary(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)read.containsAll((Document)doc), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)read.equals(doc), (Matcher)Is.is((Object)true));
        try {
            this.tm.begin();
            EditableDocument editable = entry.editDocumentContent();
            editable.setBoolean("k3", true);
            editable.setNumber("k4", 3.5);
        }
        finally {
            this.tm.commit();
        }
        SchematicEntry entry2 = this.db.get(key);
        Document read2 = entry2.getContentAsDocument();
        Assert.assertThat((Object)read2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read2.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read2.getInteger("k2"), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)read2.getBoolean("k3"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(read2.getDouble("k4") > 3.4 ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldStoreDocumentAndFetchAndModifyAndRefetchUsingTransaction() throws Exception {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        EditableDocument metadata = Schematic.newDocument((String)"mimeType", (Object)"text/plain");
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc, (Document)metadata);
        Assert.assertThat((String)"Should not have found a prior entry", (Object)prior, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        SchematicEntry entry = this.db.get(key);
        Assert.assertThat((String)"Should have found the entry", (Object)entry, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Document read = entry.getContentAsDocument();
        Assert.assertThat((Object)read, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read.getInteger("k2"), (Matcher)Is.is((Object)2));
        Assert.assertThat((String)"Should not have a Binary value for the entry's content", (Object)entry.getContentAsBinary(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)read.containsAll((Document)doc), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)read.equals(doc), (Matcher)Is.is((Object)true));
        try {
            this.tm.begin();
            EditableDocument editable = entry.editDocumentContent();
            editable.setBoolean("k3", true);
            editable.setNumber("k4", 3.5);
        }
        finally {
            this.tm.commit();
        }
        SchematicEntry entry2 = this.db.get(key);
        Document read2 = entry2.getContentAsDocument();
        Assert.assertThat((Object)read2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read2.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read2.getInteger("k2"), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)read2.getBoolean("k3"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(read2.getDouble("k4") > 3.4 ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @Test
    @FixFor(value={"MODE-1734"})
    public void shouldAllowMultipleConcurrentWritersToUpdateEntry() throws Exception {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        String key = "can be anything";
        SchematicEntry prior = this.db.put("can be anything", (Document)doc, null);
        Assert.assertThat((String)"Should not have found a prior entry", (Object)prior, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        SchematicEntry entry = this.db.get("can be anything");
        Assert.assertThat((String)"Should have found the entry", (Object)entry, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        final CountDownLatch latch = new CountDownLatch(1);
        Thread t1 = this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                    SchematicDbTest.this.tm().begin();
                    SchematicDbTest.this.log.info((Object)"Began txn1");
                    SchematicEntry entry = SchematicDbTest.this.db().get("can be anything");
                    EditableDocument editor = entry.editDocumentContent();
                    editor.setNumber("k2", 3);
                    SchematicDbTest.this.log.info((Object)editor);
                    SchematicDbTest.this.log.info((Object)"Committing txn1");
                    SchematicDbTest.this.tm().commit();
                }
                catch (Exception e) {
                    SchematicDbTest.this.log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, false);
        Thread t2 = this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                    SchematicDbTest.this.tm().begin();
                    SchematicDbTest.this.log.info((Object)"Began txn2");
                    SchematicEntry entry = SchematicDbTest.this.db().get("can be anything");
                    EditableDocument editor = entry.editDocumentContent();
                    editor.setNumber("k3", 3);
                    SchematicDbTest.this.log.info((Object)editor);
                    SchematicDbTest.this.log.info((Object)"Committing txn2");
                    SchematicDbTest.this.tm().commit();
                }
                catch (Exception e) {
                    SchematicDbTest.this.log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, false);
        latch.countDown();
        t1.join();
        t2.join();
        Document read = entry.getContentAsDocument();
        Assert.assertThat((Object)read, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read.getInteger("k3"), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)read.getInteger("k2"), (Matcher)Is.is((Object)3));
    }
}

