/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.internal.CacheContext;
import org.infinispan.schematic.internal.ImmutableSchematicValue;
import org.infinispan.schematic.internal.SchematicEntryLiteral;

public class SchematicEntryLookup {
    public static SchematicEntry getSchematicValue(CacheContext cacheContext, String key) {
        return SchematicEntryLookup.getSchematicValue(cacheContext, key, true);
    }

    private static final SchematicEntry getSchematicValue(CacheContext cacheContext, String key, boolean createIfAbsent) {
        AdvancedCache<String, SchematicEntry> cache = cacheContext.getCache();
        SchematicEntry value = (SchematicEntry)cache.get((Object)key);
        if (value == null) {
            if (createIfAbsent) {
                value = SchematicEntryLiteral.newInstance(cache, key);
            } else {
                return null;
            }
        }
        SchematicEntryLiteral castValue = (SchematicEntryLiteral)value;
        return castValue.getProxy(cacheContext, key);
    }

    public static SchematicEntry getReadOnlySchematicValue(CacheContext cacheContext, String key) {
        SchematicEntry existingValue = SchematicEntryLookup.getSchematicValue(cacheContext, key, false);
        if (existingValue == null) {
            existingValue = new SchematicEntryLiteral(key);
        }
        return new ImmutableSchematicValue(existingValue);
    }

    public static void removeSchematicValue(CacheContext cacheContext, String key) {
        cacheContext.getCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD}).remove((Object)key);
    }
}

