/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.document;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Set;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.Base64;
import org.infinispan.commons.util.Util;
import org.infinispan.schematic.document.Immutable;
import org.infinispan.schematic.internal.SchematicExternalizer;

@Immutable
@SerializeWith(value=Externalizer.class)
public final class Binary {
    private final byte type;
    private final byte[] data;

    public Binary(byte[] data) {
        this.type = 0;
        this.data = data;
    }

    public Binary(byte type, byte[] data) {
        this.type = type;
        this.data = data;
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int length() {
        return this.data.length;
    }

    public int hashCode() {
        return this.length();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Binary) {
            Binary that = (Binary)obj;
            if (this.getType() != that.getType()) {
                return false;
            }
            if (this.length() != that.length()) {
                return false;
            }
            return Arrays.equals(this.getBytes(), that.getBytes());
        }
        return false;
    }

    public String toString() {
        return "Binary (" + this.type + ':' + this.length() + ')';
    }

    public String getBytesInBase64() {
        return Base64.encodeBytes((byte[])this.data);
    }

    public static class Externalizer
    extends SchematicExternalizer<Binary> {
        private static final long serialVersionUID = 1L;

        public void writeObject(ObjectOutput output, Binary value) throws IOException {
            output.writeByte(value.getType());
            output.writeInt(value.length());
            output.write(value.getBytes());
        }

        public Binary readObject(ObjectInput input) throws IOException {
            byte type = input.readByte();
            int len = input.readInt();
            byte[] bytes = new byte[len];
            input.readFully(bytes);
            return new Binary(type, bytes);
        }

        @Override
        public Integer getId() {
            return 1621;
        }

        @Override
        public Set<Class<? extends Binary>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{Binary.class});
        }
    }
}

