/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic;

import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.infinispan.schematic.AbstractSchematicDbTest;
import org.infinispan.schematic.FixFor;
import org.infinispan.schematic.SchemaValidationTest;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchematicDbTest
extends AbstractSchematicDbTest {
    private volatile boolean print = false;

    @Before
    public void beforeEach() {
        this.print = false;
    }

    protected static InputStream resource(String resourcePath) {
        InputStream result = SchemaValidationTest.class.getClassLoader().getResourceAsStream(resourcePath);
        assert (result != null) : "Could not find resource \"" + resourcePath + "\"";
        return result;
    }

    @Test
    public void shouldStoreDocumentWithUnusedKeyAndWithNullMetadata() {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc);
        Assert.assertThat((String)"Should not have found a prior entry", (Object)prior, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        SchematicEntry entry = this.db.get(key);
        Assert.assertThat((String)"Should have found the entry", (Object)entry, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Document read = entry.getContent();
        Assert.assertThat((Object)read, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read.getInteger("k2"), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)read.containsAll((Document)doc), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)read.equals(doc), (Matcher)Is.is((Object)true));
        Document readMetadata = entry.getMetadata();
        Assert.assertThat((Object)readMetadata, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)readMetadata.getString("id"), (Matcher)Is.is((Object)key));
    }

    @Test
    public void shouldStoreDocumentWithUnusedKeyAndWithNonNullMetadata() {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc);
        Assert.assertThat((String)"Should not have found a prior entry", (Object)prior, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        SchematicEntry entry = this.db.get(key);
        Assert.assertThat((String)"Should have found the entry", (Object)entry, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Document read = entry.getContent();
        Assert.assertThat((Object)read, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read.getInteger("k2"), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)read.containsAll((Document)doc), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)read.equals(doc), (Matcher)Is.is((Object)true));
        Document readMetadata = entry.getMetadata();
        assert (readMetadata != null);
        assert (readMetadata.getString("id").equals(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldStoreDocumentAndFetchAndModifyAndRefetch() throws Exception {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc);
        Assert.assertThat((String)"Should not have found a prior entry", (Object)prior, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        SchematicEntry entry = this.db.get(key);
        Assert.assertThat((String)"Should have found the entry", (Object)entry, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Document read = entry.getContent();
        Assert.assertThat((Object)read, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read.getInteger("k2"), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)read.containsAll((Document)doc), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)read.equals(doc), (Matcher)Is.is((Object)true));
        try {
            this.tm.begin();
            this.db.lock(key);
            EditableDocument editable = this.db.editContent(key, true);
            editable.setBoolean("k3", true);
            editable.setNumber("k4", 3.5);
        }
        finally {
            this.tm.commit();
        }
        SchematicEntry entry2 = this.db.get(key);
        Document read2 = entry2.getContent();
        Assert.assertThat((Object)read2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read2.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read2.getInteger("k2"), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)read2.getBoolean("k3"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(read2.getDouble("k4") > 3.4 ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldStoreDocumentAndFetchAndModifyAndRefetchUsingTransaction() throws Exception {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        String key = "can be anything";
        SchematicEntry prior = this.db.put(key, (Document)doc);
        Assert.assertThat((String)"Should not have found a prior entry", (Object)prior, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        SchematicEntry entry = this.db.get(key);
        Assert.assertThat((String)"Should have found the entry", (Object)entry, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Document read = entry.getContent();
        Assert.assertThat((Object)read, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read.getInteger("k2"), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)read.containsAll((Document)doc), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)read.equals(doc), (Matcher)Is.is((Object)true));
        try {
            this.tm.begin();
            this.db.lock(key);
            EditableDocument editable = this.db.editContent(key, true);
            editable.setBoolean("k3", true);
            editable.setNumber("k4", 3.5);
        }
        finally {
            this.tm.commit();
        }
        SchematicEntry entry2 = this.db.get(key);
        Document read2 = entry2.getContent();
        Assert.assertThat((Object)read2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read2.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read2.getInteger("k2"), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)read2.getBoolean("k3"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)(read2.getDouble("k4") > 3.4 ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @Test
    @FixFor(value={"MODE-1734"})
    public void shouldAllowMultipleConcurrentWritersToUpdateEntryInSerialFashion() throws Exception {
        EditableDocument doc = Schematic.newDocument((String)"k1", (Object)"value1", (String)"k2", (Object)2);
        String key = "can be anything";
        SchematicEntry prior = this.db.put("can be anything", (Document)doc);
        Assert.assertThat((String)"Should not have found a prior entry", (Object)prior, (Matcher)Is.is((Matcher)IsNull.nullValue()));
        SchematicEntry entry = this.db.get("can be anything");
        Assert.assertThat((String)"Should have found the entry", (Object)entry, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        final CountDownLatch latch = new CountDownLatch(1);
        Thread t1 = this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                    SchematicDbTest.this.tm().begin();
                    SchematicDbTest.this.print("Began txn1");
                    SchematicDbTest.this.db.lock("can be anything");
                    EditableDocument editor = SchematicDbTest.this.db.editContent("can be anything", true);
                    editor.setNumber("k2", 3);
                    SchematicDbTest.this.print(editor);
                    SchematicDbTest.this.print("Committing txn1");
                    SchematicDbTest.this.tm().commit();
                }
                catch (Exception e) {
                    SchematicDbTest.this.log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, false);
        Thread t2 = this.fork(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                    SchematicDbTest.this.tm().begin();
                    SchematicDbTest.this.print("Began txn2");
                    SchematicDbTest.this.db.lock("can be anything");
                    EditableDocument editor = SchematicDbTest.this.db.editContent("can be anything", true);
                    editor.setNumber("k3", 3);
                    SchematicDbTest.this.print(editor);
                    SchematicDbTest.this.print("Committing txn2");
                    SchematicDbTest.this.tm().commit();
                }
                catch (Exception e) {
                    SchematicDbTest.this.log.error((Object)"Unexpected error performing transaction", (Throwable)e);
                }
            }
        }, false);
        latch.countDown();
        t1.join();
        t2.join();
        this.tm().begin();
        Document read = this.db.get("can be anything").getContent();
        Assert.assertThat((Object)read, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)read.getString("k1"), (Matcher)Is.is((Object)"value1"));
        Assert.assertThat((Object)read.getInteger("k3"), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)read.getInteger("k2"), (Matcher)Is.is((Object)3));
        this.tm().commit();
    }

    protected void print(Object obj) {
        if (this.print) {
            this.log.info(obj);
        }
    }
}

