/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic;

import javax.transaction.TransactionManager;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.TestUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractSchematicDbTest {
    protected SchematicDb db;
    protected EmbeddedCacheManager cm;
    protected TransactionManager tm;

    @Before
    public void beforeTest() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.invocationBatching().enable().transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC).locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        this.cm = new DefaultCacheManager(configurationBuilder.build());
        this.db = Schematic.get((CacheContainer)this.cm, (String)"documents");
        this.tm = this.db.getCache().getAdvancedCache().getTransactionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterTest() {
        try {
            TestUtil.killCacheContainers(new CacheContainer[]{this.cm});
        }
        finally {
            this.cm = null;
            this.db = null;
            try {
                TestUtil.killTransaction(this.tm);
            }
            finally {
                this.tm = null;
            }
        }
    }

    protected SchematicDb db() {
        return this.db;
    }

    protected TransactionManager tm() {
        return this.tm;
    }
}

