/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;

public class TestUtil {
    public static boolean delete(File fileOrDirectory) {
        if (fileOrDirectory == null) {
            return false;
        }
        if (!fileOrDirectory.exists()) {
            return false;
        }
        if (fileOrDirectory.isDirectory()) {
            for (File childFile : fileOrDirectory.listFiles()) {
                TestUtil.delete(childFile);
            }
        }
        return fileOrDirectory.delete();
    }

    public static InputStream resource(String resourcePath) {
        InputStream stream = TestUtil.class.getClassLoader().getResourceAsStream(resourcePath);
        if (stream == null) {
            File file = new File(resourcePath);
            if (!file.exists()) {
                file = new File("src/test/resources" + resourcePath);
            }
            if (!file.exists()) {
                file = new File("src/test/resources/" + resourcePath);
            }
            if (file.exists()) {
                try {
                    stream = new FileInputStream(file);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)("Failed to open stream to \"" + file.getAbsolutePath() + "\""));
                }
            }
        }
        assert (stream != null) : "Resource at \"" + resourcePath + "\" could not be found";
        return stream;
    }

    public static void killTransaction(TransactionManager txManager) {
        if (txManager != null) {
            try {
                txManager.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void killCaches(Iterable<Cache<?, ?>> caches) {
        for (Cache<?, ?> c : caches) {
            TestUtil.killCache(c);
        }
    }

    public static void killCache(Cache<?, ?> c) {
        block5: {
            try {
                TransactionManager tm;
                if (c == null || c.getStatus() != ComponentStatus.RUNNING) break block5;
                AdvancedCache advancedCache = c.getAdvancedCache();
                if (advancedCache != null && (tm = advancedCache.getTransactionManager()) != null) {
                    try {
                        tm.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                c.stop();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }

    public static void killCacheContainers(CacheContainer ... containers) {
        for (CacheContainer container : containers) {
            if (!(container instanceof EmbeddedCacheManager) || ((EmbeddedCacheManager)container).getStatus() != ComponentStatus.RUNNING) continue;
            EmbeddedCacheManager manager = (EmbeddedCacheManager)container;
            HashSet caches = new HashSet();
            for (String cacheName : manager.getCacheNames()) {
                Cache cache = manager.getCache(cacheName, false);
                if (cache == null) continue;
                AdvancedCache advancedCache = cache.getAdvancedCache();
                caches.add((Cache<?, ?>)advancedCache);
            }
            TestUtil.killCaches(caches);
        }
        for (CacheContainer cm : containers) {
            try {
                if (cm == null) continue;
                cm.stop();
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

