/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.schema;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.infinispan.schematic.SchemaLibrary;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Path;

public class DocumentTransformer {
    private static final String CURLY_PREFIX = "${";
    private static final String CURLY_SUFFIX = "}";
    private static final String VAR_DELIM = ",";
    private static final String DEFAULT_DELIM = ":";

    public static String getSubstitutedProperty(String value, PropertyAccessor propertyAccessor) {
        if (value == null || value.trim().length() == 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value);
        int startName = sb.indexOf(CURLY_PREFIX);
        if (startName == -1) {
            return value;
        }
        while (startName != -1) {
            String defaultValue = null;
            int endName = sb.indexOf(CURLY_SUFFIX, startName);
            if (endName == -1) {
                return sb.toString();
            }
            String varString = sb.substring(startName + 2, endName);
            if (varString.indexOf(DEFAULT_DELIM) > -1) {
                List<String> defaults = DocumentTransformer.split(varString, DEFAULT_DELIM);
                varString = defaults.get(0);
                if (defaults.size() == 2) {
                    defaultValue = defaults.get(1);
                }
            }
            String constValue = null;
            List<String> vars = DocumentTransformer.split(varString, VAR_DELIM);
            for (String var : vars) {
                constValue = System.getenv(var);
                if (constValue == null) {
                    constValue = propertyAccessor.getProperty(var);
                }
                if (constValue == null) continue;
                break;
            }
            if (constValue == null && defaultValue != null) {
                constValue = defaultValue;
            }
            if (constValue != null) {
                sb = sb.replace(startName, endName + 1, constValue);
                startName = sb.indexOf(CURLY_PREFIX);
                continue;
            }
            startName = sb.indexOf(CURLY_PREFIX, endName);
        }
        return sb.toString();
    }

    private static List<String> split(String str, String splitter) {
        StringTokenizer tokens = new StringTokenizer(str, splitter);
        ArrayList<String> l = new ArrayList<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            l.add(tokens.nextToken());
        }
        return l;
    }

    public static Document convertValuesWithMismatchedTypes(Document original, SchemaLibrary.Results results) {
        if (results == null || !results.hasProblems()) {
            return original;
        }
        LinkedList<Conversion> conversions = new LinkedList<Conversion>();
        for (SchemaLibrary.Problem problem : results) {
            if (!(problem instanceof SchemaLibrary.MismatchedTypeProblem)) continue;
            conversions.add(new Conversion((SchemaLibrary.MismatchedTypeProblem)problem));
        }
        if (conversions.isEmpty()) {
            return original;
        }
        return DocumentTransformer.convertValuesWithMismatchedTypes(original, 0, conversions);
    }

    protected static Document convertValuesWithMismatchedTypes(Document original, int level, LinkedList<Conversion> conversions) {
        HashMap<String, Object> changedFields = new HashMap<String, Object>();
        int nextLevel = level + 1;
        HashMap<String, LinkedList<Conversion>> nextLevelConversionsBySegment = new HashMap<String, LinkedList<Conversion>>();
        for (Conversion conversion : conversions) {
            Path path = conversion.getPath();
            assert (path.size() > level);
            String segment = path.get(level);
            if (path.size() == nextLevel) {
                changedFields.put(segment, conversion.getConvertedValue());
                continue;
            }
            LinkedList<Conversion> nestedConversions = (LinkedList<Conversion>)nextLevelConversionsBySegment.get(segment);
            if (nestedConversions == null) {
                nestedConversions = new LinkedList<Conversion>();
                nextLevelConversionsBySegment.put(segment, nestedConversions);
            }
            nestedConversions.add(conversion);
        }
        for (Map.Entry entry : nextLevelConversionsBySegment.entrySet()) {
            String segment = (String)entry.getKey();
            LinkedList nestedConversions = (LinkedList)entry.getValue();
            Document nested = original.getDocument(segment);
            Document newDoc = DocumentTransformer.convertValuesWithMismatchedTypes(nested, nextLevel, nestedConversions);
            changedFields.put(segment, newDoc);
        }
        return original.with(changedFields);
    }

    protected static final class Conversion
    implements Comparable<Conversion> {
        private final SchemaLibrary.MismatchedTypeProblem problem;

        protected Conversion(SchemaLibrary.MismatchedTypeProblem problem) {
            this.problem = problem;
        }

        @Override
        public int compareTo(Conversion that) {
            if (this == that) {
                return 0;
            }
            return this.problem.getPath().compareTo(that.problem.getPath());
        }

        public Path getPath() {
            return this.problem.getPath();
        }

        public Object getConvertedValue() {
            return this.problem.getConvertedValue();
        }
    }

    public static final class SystemPropertiesTransformer
    implements Document.ValueTransformer {
        @Override
        public Object transform(String name, Object value) {
            if (value instanceof String) {
                return DocumentTransformer.getSubstitutedProperty((String)value, SystemPropertyAccessor.INSTANCE);
            }
            return value;
        }
    }

    public static final class PropertiesTransformer
    implements Document.ValueTransformer {
        private final PropertiesAccessor accessor;

        public PropertiesTransformer(Properties properties) {
            this.accessor = new PropertiesAccessor(properties);
        }

        @Override
        public Object transform(String name, Object value) {
            if (value instanceof String) {
                String modified = DocumentTransformer.getSubstitutedProperty((String)value, this.accessor);
                return modified;
            }
            return value;
        }
    }

    protected static final class SystemPropertyAccessor
    implements PropertyAccessor {
        public static final SystemPropertyAccessor INSTANCE = new SystemPropertyAccessor();

        private SystemPropertyAccessor() {
        }

        @Override
        public String getProperty(final String name) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name);
                }
            });
        }
    }

    protected static final class PropertiesAccessor
    implements PropertyAccessor {
        private final Properties properties;

        protected PropertiesAccessor(Properties properties) {
            this.properties = properties;
        }

        @Override
        public String getProperty(String name) {
            return this.properties.getProperty(name);
        }
    }

    protected static interface PropertyAccessor {
        public String getProperty(String var1);
    }
}

