/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.delta;

import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.delta.AddValueOperation;
import org.modeshape.schematic.internal.document.MutableArray;
import org.modeshape.schematic.internal.document.MutableDocument;

public class AddValueIfAbsentOperation
extends AddValueOperation {
    protected transient boolean added;

    public AddValueIfAbsentOperation(Path path, Object value) {
        super(path, value);
    }

    public boolean isAdded() {
        return this.added;
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.added) {
            MutableArray array = this.mutableParent(delegate);
            array.remove(this.index);
        }
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        this.added = array.addValueIfAbsent(this.value);
    }

    @Override
    public String toString() {
        return super.toString() + " if absent";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AddValueIfAbsentOperation) {
            AddValueIfAbsentOperation other = (AddValueIfAbsentOperation)obj;
            return this.equalsIfNotNull(this.value, other.value) && this.index == other.index && this.equalsIfNotNull(this.getParentPath(), other.getParentPath());
        }
        return false;
    }
}

