/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.delta;

import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.HashCode;
import org.modeshape.schematic.internal.delta.ArrayOperation;
import org.modeshape.schematic.internal.document.MutableArray;
import org.modeshape.schematic.internal.document.MutableDocument;

public class RemoveAtIndexOperation
extends ArrayOperation {
    protected final int index;
    protected transient Object actualValue = null;

    public RemoveAtIndexOperation(Path path, int index) {
        super(path, HashCode.compute(path, index));
        this.index = index;
    }

    @Override
    public RemoveAtIndexOperation clone() {
        return new RemoveAtIndexOperation(this.getParentPath(), this.index);
    }

    public int getIndex() {
        return this.index;
    }

    public Object getRemovedValue() {
        return this.actualValue;
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.actualValue != null) {
            MutableArray array = this.mutableParent(delegate);
            array.add(this.index, this.actualValue);
        }
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableArray array = this.mutableParent(delegate);
        this.actualValue = array.remove(this.index);
    }

    public String toString() {
        return "Remove at '" + this.parentPath + "' the value at index " + this.index;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoveAtIndexOperation) {
            RemoveAtIndexOperation other = (RemoveAtIndexOperation)obj;
            return this.index == other.index && this.equalsIfNotNull(this.getParentPath(), other.getParentPath());
        }
        return false;
    }
}

