/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.delta;

import org.modeshape.schematic.annotation.Immutable;
import org.modeshape.schematic.document.Path;
import org.modeshape.schematic.internal.HashCode;
import org.modeshape.schematic.internal.delta.Operation;
import org.modeshape.schematic.internal.document.MutableDocument;

@Immutable
public class RemoveOperation
extends Operation {
    protected final String fieldName;
    protected final Object oldValue;
    private transient boolean removed;

    public RemoveOperation(Path parentPath, String fieldName, Object oldValue) {
        super(parentPath, HashCode.compute(parentPath, fieldName));
        this.fieldName = fieldName;
        this.oldValue = oldValue;
    }

    @Override
    public RemoveOperation clone() {
        return new RemoveOperation(this.getParentPath(), this.fieldName, this.cloneValue(this.oldValue));
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void rollback(MutableDocument delegate) {
        if (this.oldValue != null) {
            delegate = this.mutableParent(delegate);
            delegate.put(this.fieldName, this.oldValue);
        }
    }

    @Override
    public void replay(MutableDocument delegate) {
        MutableDocument parent = this.mutableParent(delegate);
        assert (parent != null);
        this.removed = parent.remove(this.fieldName) != null;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public String toString() {
        return "Remove from '" + this.parentPath + "' the '" + this.fieldName + "' field value '" + this.oldValue + "'";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoveOperation) {
            RemoveOperation other = (RemoveOperation)obj;
            return this.equalsIfNotNull(this.fieldName, other.fieldName) && this.equalsIfNotNull(this.getParentPath(), other.getParentPath());
        }
        return false;
    }
}

