/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.document;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.modeshape.schematic.document.Array;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.internal.document.ArrayEditor;
import org.modeshape.schematic.internal.document.DocumentEditor;

class Utility {
    Utility() {
    }

    public static Array unwrap(Array array) {
        if (array instanceof ArrayEditor) {
            return Utility.unwrap(((ArrayEditor)array).unwrap());
        }
        return array;
    }

    public static Document unwrap(Document document) {
        if (document instanceof DocumentEditor) {
            return Utility.unwrap(((DocumentEditor)document).unwrap());
        }
        return document;
    }

    public static Object unwrap(Object value) {
        if (value instanceof DocumentEditor) {
            return Utility.unwrap(((DocumentEditor)value).unwrap());
        }
        if (value instanceof ArrayEditor) {
            return Utility.unwrap(((ArrayEditor)value).unwrap());
        }
        return value;
    }

    public static Map<? extends String, ?> unwrapValues(Map<? extends String, ?> map) {
        if (map == null || map.isEmpty()) {
            return map;
        }
        Map<String, ?> newMap = map;
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object unwrapped;
            Object orig = entry.getValue();
            if (orig == (unwrapped = Utility.unwrap(orig))) continue;
            String key = entry.getKey();
            newMap.put(key, unwrapped);
        }
        return newMap;
    }

    public static Collection<?> unwrapValues(Collection<?> c) {
        if (c == null || c.isEmpty()) {
            return c;
        }
        if (c instanceof Set) {
            HashSet<Object> replaced = null;
            Set result = (Set)c;
            Iterator<?> iter = c.iterator();
            while (iter.hasNext()) {
                Object unwrapped;
                Object orig = iter.next();
                if (orig == (unwrapped = Utility.unwrap(orig))) continue;
                iter.remove();
                if (replaced == null) {
                    replaced = new HashSet<Object>();
                }
                replaced.add(unwrapped);
            }
            if (replaced != null) {
                result.addAll(replaced);
            }
            return result;
        }
        if (c instanceof List) {
            List result = (List)c;
            ListIterator<Object> iter = result.listIterator();
            while (iter.hasNext()) {
                Object unwrapped;
                Object orig = iter.next();
                if (orig == (unwrapped = Utility.unwrap(orig))) continue;
                iter.set(unwrapped);
            }
            return result;
        }
        return c.stream().map(Utility::unwrap).collect(Collectors.toList());
    }
}

