/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;

public class BsonDataOutput
implements DataOutput {
    private static final int DEFAULT_BUFFER_SIZE = 8384;
    private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private final int bufferSize;
    private final byte[] bytes = new byte[8];
    private int position = 0;
    private int size = 0;
    private ByteBuffer remainderBuffer;

    public BsonDataOutput() {
        this.bufferSize = 8384;
    }

    protected ByteBuffer getBufferFor(int position) {
        int bufferIndex = position / this.bufferSize;
        while (bufferIndex >= this.buffers.size()) {
            this.buffers.add(this.newByteBuffer(this.bufferSize));
        }
        return this.buffers.get(bufferIndex);
    }

    protected ByteBuffer newByteBuffer(int bufferSize) {
        return ByteBuffer.allocate(bufferSize).order(ByteOrder.LITTLE_ENDIAN);
    }

    protected void updateSize(int newSize) {
        if (this.size < newSize) {
            this.size = newSize;
        }
    }

    public int size() {
        return this.size;
    }

    @Override
    public void writeByte(int value) {
        this.writeByte(this.position, value);
        ++this.position;
    }

    public void writeByte(int position, int value) {
        this.updateSize(position + 1);
        ByteBuffer buffer = this.getBufferFor(position);
        int index = position % this.bufferSize;
        buffer.put(index, (byte)value);
    }

    @Override
    public void write(byte[] b) {
        this.write(this.position, b, 0, b.length);
        this.position += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.write(this.position, b, off, len);
        this.position += len;
    }

    public void write(int position, byte[] value, int offset, int length) {
        this.updateSize(position + length);
        ByteBuffer buffer = this.getBufferFor(position);
        int index = position % this.bufferSize;
        for (int i = offset; i != length; ++i) {
            byte b = value[i];
            if (index == this.bufferSize) {
                buffer = this.getBufferFor(position);
                index = position % this.bufferSize;
            }
            buffer.put(index, b);
            ++index;
            ++position;
        }
    }

    @Override
    public void write(int b) {
        this.writeByte((byte)b);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.writeBoolean(this.position, value);
        ++this.position;
    }

    public void writeBoolean(int position, boolean value) {
        this.updateSize(position + 1);
        ByteBuffer buffer = this.getBufferFor(position);
        int index = position % this.bufferSize;
        buffer.put(index, value ? (byte)1 : 0);
    }

    @Override
    public void writeChar(int value) {
        this.writeChar(this.position, value);
        this.position += 2;
    }

    public void writeChar(int position, int value) {
        this.updateSize(position + 2);
        ByteBuffer buffer = this.getBufferFor(position);
        int index = position % this.bufferSize;
        if (buffer.limit() - index >= 2) {
            buffer.putChar(index, (char)value);
        } else {
            this.bytes[0] = (byte)value;
            this.bytes[1] = (byte)(value >> 8);
            this.write(position, this.bytes, 0, 2);
        }
    }

    @Override
    public void writeInt(int value) {
        this.writeInt(this.position, value);
        this.position += 4;
    }

    public void writeInt(int position, int value) {
        this.updateSize(position + 4);
        ByteBuffer buffer = this.getBufferFor(position);
        int index = position % this.bufferSize;
        if (buffer.limit() - index >= 4) {
            buffer.putInt(index, value);
        } else {
            this.bytes[0] = (byte)value;
            this.bytes[1] = (byte)(value >> 8);
            this.bytes[2] = (byte)(value >> 16);
            this.bytes[3] = (byte)(value >> 24);
            this.write(position, this.bytes, 0, 4);
        }
    }

    @Override
    public void writeShort(int value) {
        this.writeShort(this.position, value);
        this.position += 2;
    }

    public void writeShort(int position, int value) {
        this.updateSize(position + 2);
        ByteBuffer buffer = this.getBufferFor(position);
        int index = position % this.bufferSize;
        if (buffer.limit() - index >= 2) {
            buffer.putShort(index, (short)value);
        } else {
            this.bytes[0] = (byte)value;
            this.bytes[1] = (byte)(value >> 8);
            this.write(position, this.bytes, 0, 2);
        }
    }

    @Override
    public void writeLong(long value) {
        this.writeLong(this.position, value);
        this.position += 8;
    }

    public void writeLong(int position, long value) {
        this.updateSize(position + 8);
        ByteBuffer buffer = this.getBufferFor(position);
        int index = position % this.bufferSize;
        if (buffer.limit() - index >= 8) {
            buffer.putLong(index, value);
        } else {
            this.bytes[0] = (byte)value;
            this.bytes[1] = (byte)(value >> 8);
            this.bytes[2] = (byte)(value >> 16);
            this.bytes[3] = (byte)(value >> 24);
            this.bytes[4] = (byte)(value >> 32);
            this.bytes[5] = (byte)(value >> 40);
            this.bytes[6] = (byte)(value >> 48);
            this.bytes[7] = (byte)(value >> 56);
            this.write(position, this.bytes, 0, 8);
        }
    }

    @Override
    public void writeFloat(float value) {
        this.writeFloat(this.position, value);
        this.position += 4;
    }

    public void writeFloat(int position, float value) {
        this.writeInt(position, Float.floatToRawIntBits(value));
    }

    @Override
    public void writeDouble(double value) {
        this.writeDouble(this.position, value);
        this.position += 8;
    }

    public void writeDouble(int position, double value) {
        this.writeLong(position, Double.doubleToRawLongBits(value));
    }

    @Override
    @Deprecated
    public void writeBytes(String str) {
        StringCharacterIterator iter = new StringCharacterIterator(str);
        char c = iter.first();
        while (c != '\uffff') {
            this.writeByte(c);
            c = iter.next();
        }
    }

    @Override
    public void writeChars(String str) {
        StringCharacterIterator iter = new StringCharacterIterator(str);
        char c = iter.first();
        while (c != '\uffff') {
            this.writeChar(c);
            c = iter.next();
        }
    }

    @Override
    public void writeUTF(String str) {
        int numBytesWritten = 0;
        int numBytesPosition = this.position;
        this.writeShort(numBytesPosition, numBytesWritten);
        numBytesWritten = this.writeUTF(this.position, str);
        this.position += numBytesWritten;
        this.writeShort(numBytesPosition, numBytesWritten);
    }

    public int writeUTFString(String str) {
        int numBytesWritten = this.writeUTF(this.position, str);
        this.position += numBytesWritten;
        return numBytesWritten;
    }

    public int writeUTF(int position, String str) {
        CharBuffer chars = CharBuffer.wrap(str);
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        ByteBuffer output = this.getBufferFor(position);
        int index = position % this.bufferSize;
        int newPosition = position;
        output.position(index);
        try {
            while (chars.hasRemaining()) {
                CoderResult result = encoder.encode(chars, output, true);
                if (output == this.remainderBuffer) {
                    output.flip();
                    while (output.remaining() > 0) {
                        this.writeByte(newPosition, output.get());
                        ++newPosition;
                    }
                } else {
                    newPosition += output.position() - index;
                }
                if (result.isError()) {
                    result.throwException();
                    continue;
                }
                if (!result.isOverflow()) continue;
                if (output.remaining() > 0) {
                    if (this.remainderBuffer != null) {
                        this.remainderBuffer.clear();
                    } else {
                        this.remainderBuffer = ByteBuffer.allocate(4);
                    }
                    output = this.remainderBuffer;
                    index = 0;
                    continue;
                }
                output = this.getBufferFor(newPosition);
                index = newPosition % this.bufferSize;
                output.position(index);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to encode string", e);
        }
        this.updateSize(newPosition);
        return newPosition - position;
    }

    public void writeTo(OutputStream stream) throws IOException {
        this.writeTo(Channels.newChannel(stream));
    }

    public void writeTo(WritableByteChannel channel) throws IOException {
        int numberOfBytesToWrite = this.size;
        for (ByteBuffer buffer : this.buffers) {
            if (buffer == null) continue;
            int numBytesInBuffer = Math.min(numberOfBytesToWrite, this.bufferSize);
            buffer.position(numBytesInBuffer);
            buffer.flip();
            channel.write(buffer);
            numberOfBytesToWrite -= numBytesInBuffer;
        }
        this.buffers.clear();
    }
}

