/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.schema;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.modeshape.schematic.DocumentLibrary;
import org.modeshape.schematic.annotation.ThreadSafe;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.internal.document.Paths;
import org.modeshape.schematic.internal.schema.JsonSchemaValidatorFactory;
import org.modeshape.schematic.internal.schema.Problems;
import org.modeshape.schematic.internal.schema.SchemaDocument;
import org.modeshape.schematic.internal.schema.Validator;

@ThreadSafe
public class SchemaDocumentCache
implements Validator.SchemaDocumentResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String defaultMetaSchemaUri;
    private final DocumentLibrary jsonSchemaDocuments;
    private transient Map<String, SchemaDocument> schemaDocumentsByUri = new ConcurrentHashMap<String, SchemaDocument>();

    public SchemaDocumentCache(DocumentLibrary jsonSchemaDocuments, String defaultMetaSchemaUri) {
        this.jsonSchemaDocuments = jsonSchemaDocuments;
        this.defaultMetaSchemaUri = defaultMetaSchemaUri != null ? defaultMetaSchemaUri : "http://json-schema.org/draft-03/schema#";
    }

    @Override
    public SchemaDocument get(String uri, Problems problems) {
        if (uri == null) {
            throw new IllegalArgumentException("The 'uri' parameter may not be null");
        }
        SchemaDocument result = this.schemaDocumentsByUri.get(uri);
        if (result != null) {
            return result;
        }
        Document doc = this.jsonSchemaDocuments.get(uri);
        if (doc == null) {
            problems.recordError(Paths.rootPath(), "Unable to find the JSON Schema document for '" + uri + "'");
            return null;
        }
        String id = doc.getString("id");
        String schemaRef = doc.getString("$schema");
        if (schemaRef == null) {
            schemaRef = this.defaultMetaSchemaUri;
        }
        if (!schemaRef.equals(id)) {
            SchemaDocument schemaOfSchema = this.get(schemaRef, problems);
            Document schemaOfSchemaDoc = schemaOfSchema.getDocument();
            schemaOfSchema.getValidator().validate(null, null, schemaOfSchemaDoc, Paths.rootPath(), problems, this);
        }
        URI schemaRefUri = null;
        try {
            schemaRefUri = new URI(uri);
        }
        catch (URISyntaxException e) {
            problems.recordWarning(Paths.path("$schema"), "The URI of the referenced schema '" + uri + "' is not a valid URI");
        }
        Validator validator = this.createFactory(schemaRefUri, problems).create(doc, Paths.rootPath());
        if (validator != null) {
            result = new SchemaDocument(schemaRef, doc, validator);
            this.schemaDocumentsByUri.put(uri, result);
        }
        return result;
    }

    public boolean remove(String uri) {
        return this.schemaDocumentsByUri.remove(uri) != null;
    }

    public void removeAll() {
        this.schemaDocumentsByUri.clear();
    }

    protected Validator.Factory createFactory(URI schemaRefUri, Problems problems) {
        return new JsonSchemaValidatorFactory(schemaRefUri, problems);
    }
}

