/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.document;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.schematic.internal.document.BasicArray;

public class BasicArrayTest {
    private BasicArray array;

    @Before
    public void beforeTest() {
        this.array = new BasicArray();
        for (int i = 0; i != 10; ++i) {
            this.array.addValue((Object)i);
        }
    }

    @Test
    public void shouldReturnProperSubarray() {
        List subArray = this.array.subList(3, 8);
        Assert.assertEquals((long)3L, (long)((Integer)subArray.get(0)).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)subArray.get(1)).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)subArray.get(2)).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)subArray.get(3)).intValue());
        Assert.assertEquals((long)7L, (long)((Integer)subArray.get(4)).intValue());
        Iterator iter = subArray.iterator();
        int value = 3;
        while (iter.hasNext()) {
            Assert.assertEquals((long)value++, (long)((Integer)iter.next()).intValue());
        }
    }

    @Test
    public void shouldCreateCopy() {
        BasicArray array2 = new BasicArray(this.array.size());
        array2.addAllValues((Collection)this.array);
        for (int i = 0; i != 10; ++i) {
            Assert.assertEquals((long)i, (long)((Integer)array2.get(i)).intValue());
        }
    }

    @Test
    public void shouldCreateCopyOfSublist() {
        BasicArray array2 = new BasicArray(5);
        array2.addAllValues((Collection)this.array.subList(3, 8));
        for (int i = 0; i != 5; ++i) {
            Assert.assertEquals((long)(i + 3), (long)((Integer)array2.get(i)).intValue());
        }
    }
}

