/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.document;

import de.undercouch.bson4jackson.types.JavaScript;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.BasicBSONList;
import org.bson.types.Binary;
import org.bson.types.CodeWScope;
import org.codehaus.jackson.JsonToken;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.schematic.document.Code;
import org.modeshape.schematic.document.CodeWithScope;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.Json;
import org.modeshape.schematic.document.MaxKey;
import org.modeshape.schematic.document.MinKey;
import org.modeshape.schematic.document.ObjectId;
import org.modeshape.schematic.document.Symbol;
import org.modeshape.schematic.document.Timestamp;
import org.modeshape.schematic.internal.annotation.FixFor;
import org.modeshape.schematic.internal.document.BasicArray;
import org.modeshape.schematic.internal.document.BasicDocument;
import org.modeshape.schematic.internal.document.BsonReader;
import org.modeshape.schematic.internal.document.BsonWriter;

public class BsonReadingAndWritingTest {
    protected BsonReader reader;
    protected BsonWriter writer;
    protected Document input;
    protected Document output;
    protected boolean print;

    @Before
    public void beforeTest() {
        this.reader = new BsonReader();
        this.writer = new BsonWriter();
        this.print = false;
    }

    @After
    public void afterTest() {
        this.reader = null;
        this.writer = null;
    }

    @Test
    public void shouldReadExampleBsonStream() throws IOException {
        byte[] bytes = new byte[]{22, 0, 0, 0, 2, 104, 101, 108, 108, 111, 0, 6, 0, 0, 0, 119, 111, 114, 108, 100, 0, 0};
        this.output = this.reader.read((InputStream)new ByteArrayInputStream(bytes));
        String json = Json.write((Document)this.output);
        String expected = "{ \"hello\" : \"world\" }";
        if (this.print) {
            System.out.println(json);
            System.out.flush();
        }
        Assert.assertEquals((Object)expected, (Object)json);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithStringValue() {
        this.input = new BasicDocument("name", (Object)"Joe");
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithBooleanValue() {
        this.input = new BasicDocument("foo", (Object)3L);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithIntValue() {
        this.input = new BasicDocument("foo", (Object)3);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithLongValue() {
        this.input = new BasicDocument("foo", (Object)3L);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithFloatValue() {
        this.input = new BasicDocument("foo", (Object)Float.valueOf(3.0f));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithDoubleValue() {
        this.input = new BasicDocument("foo", (Object)3.0);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithDateValue() {
        this.input = new BasicDocument("foo", (Object)new Date());
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithTimestampValue() {
        this.input = new BasicDocument("foo", (Object)new Timestamp(new Date()));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithObjectId() {
        int time = Math.abs((int)new Date().getTime());
        if (this.print) {
            System.out.println("time value: " + time);
        }
        this.input = new BasicDocument("foo", (Object)new ObjectId(time, 1, 2, 3));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithCode() {
        this.input = new BasicDocument("foo", (Object)new Code("bar"));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithCodeWithScope() {
        BasicDocument scope = new BasicDocument("baz", (Object)"bam", "bak", (Object)"bat");
        this.input = new BasicDocument("foo", (Object)new CodeWithScope("bar", (Document)scope));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithMaxKey() {
        this.input = new BasicDocument("foo", (Object)MaxKey.getInstance());
        this.assertRoundtrip(this.input, false);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithMinKey() {
        this.input = new BasicDocument("foo", (Object)MinKey.getInstance());
        this.assertRoundtrip(this.input, false);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithSymbol() {
        this.input = new BasicDocument("foo", (Object)new Symbol("bar"));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithNull() {
        this.input = new BasicDocument("foo", null);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithBinary1() {
        byte[] data = new byte[]{22, 0, 0, 0, 2, 104, 101, 108};
        this.input = new BasicDocument("foo", (Object)new org.modeshape.schematic.document.Binary(data));
        this.assertRoundtrip(this.input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRoundTripSimpleBsonObjectWithBinary2() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("binary");
        Assert.assertNotNull((Object)is);
        try {
            int read;
            byte[] buff = new byte[1024];
            while ((read = is.read(buff)) != -1) {
                bos.write(buff, 0, read);
            }
        }
        finally {
            bos.close();
            is.close();
        }
        this.input = new BasicDocument("foo", (Object)new org.modeshape.schematic.document.Binary(bos.toByteArray()));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithUuid() {
        this.input = new BasicDocument("foo", (Object)UUID.randomUUID());
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithPattern() {
        this.input = new BasicDocument("foo", (Object)Pattern.compile("[CH]at\\s+"));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithPatternAndFlags() {
        this.input = new BasicDocument("foo", (Object)Pattern.compile("[CH]at\\s+", 10));
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripSimpleBsonObjectWithArray() {
        BasicArray array = new BasicArray();
        array.addValue((Object)"value1");
        array.addValue((Object)new Symbol("value2"));
        array.addValue((Object)30);
        array.addValue((Object)40L);
        array.addValue((Object)4.33);
        array.addValue((Object)false);
        array.addValue(null);
        array.addValue((Object)"value2");
        this.input = new BasicDocument("foo", (Object)array);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripBsonObjectWithTwoFields() {
        this.input = new BasicDocument("name", (Object)"Joe", "age", (Object)35);
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripBsonObjectWithThreeFields() {
        this.input = new BasicDocument("name", (Object)"Joe", "age", (Object)35, "nick", (Object)"joey");
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripBsonObjectWithNestedDocument() {
        BasicDocument address = new BasicDocument("street", (Object)"100 Main", "city", (Object)"Springfield", "zip", (Object)12345);
        this.input = new BasicDocument("name", (Object)"Joe", "age", (Object)35, "address", (Object)address, "nick", (Object)"joey");
        this.assertRoundtrip(this.input);
    }

    @Test
    public void shouldRoundTripLargeModeShapeDocument() throws Exception {
        Document doc = Json.read((InputStream)this.resource("json/sample-large-modeshape-doc.json"));
        this.assertRoundtrip(doc);
    }

    @Test
    @FixFor(value={"MODE-2074"})
    public void shouldRoundTripBsonWithLargeStringField() throws Exception {
        String largeString = this.readFile("json/sample-large-modeshape-doc3.json");
        BasicDocument document = new BasicDocument("largeString", (Object)largeString);
        this.assertRoundtrip((Document)document);
    }

    @Test
    @FixFor(value={"MODE-2074"})
    public void shouldRoundTripBsonWithLargeStringFieldFromMultipleThreads() throws Exception {
        final String largeString = this.readFile("json/sample-large-modeshape-doc3.json");
        int threadCount = 10;
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
        ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            results.add(executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    BasicDocument document = new BasicDocument("largeString", (Object)largeString);
                    BsonReadingAndWritingTest.this.assertRoundtrip((Document)document);
                    return null;
                }
            }));
        }
        for (Future future : results) {
            future.get(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    @FixFor(value={"MODE-2430"})
    public void shouldRoundTripLargeStringsSuccessively() throws Exception {
        int limit = 8384;
        int iterations = 20;
        char letter = 'a';
        for (int i = 0; i < iterations; ++i) {
            int size = limit + i;
            char[] chars = new char[size];
            Arrays.fill(chars, letter);
            letter = (char)((byte)letter + 1);
            String str = new String(chars);
            BasicDocument document = new BasicDocument("largeString", (Object)str);
            this.assertRoundtrip((Document)document, false);
        }
    }

    protected String readFile(String filePath) throws IOException {
        InputStreamReader reader = new InputStreamReader(this.resource(filePath));
        StringBuilder stringBuilder = new StringBuilder();
        boolean error = false;
        try {
            int numRead = 0;
            char[] buffer = new char[1024];
            while ((numRead = reader.read(buffer)) > -1) {
                stringBuilder.append(buffer, 0, numRead);
            }
        }
        catch (IOException e) {
            error = true;
            throw e;
        }
        catch (RuntimeException e) {
            error = true;
            throw e;
        }
        finally {
            block12: {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    if (error) break block12;
                    throw e;
                }
            }
        }
        return stringBuilder.toString();
    }

    protected void assertRoundtrip(Document input) {
        this.assertRoundtrip(input, true);
    }

    protected void assertRoundtrip(Document input, boolean compareToOtherImpls) {
        Assert.assertNotNull((Object)input);
        Document output = this.writeThenRead(input, compareToOtherImpls);
        if (this.print) {
            System.out.println("********************************************************************************");
            System.out.println("INPUT :  " + input);
            System.out.println();
            System.out.println("OUTPUT:  " + output);
            System.out.println("********************************************************************************");
            System.out.flush();
        }
        Assert.assertEquals((String)"Round trip failed", (Object)input, (Object)output);
    }

    protected Document writeThenRead(Document object, boolean compareToOtherImpls) {
        try {
            long start = System.nanoTime();
            byte[] bytes = this.writer.write((Object)object);
            long writeTime = System.nanoTime() - start;
            start = System.nanoTime();
            Document result = this.reader.read((InputStream)new ByteArrayInputStream(bytes));
            long readTime = System.nanoTime() - start;
            if (compareToOtherImpls) {
                BSONObject mongoData = this.createMongoData(object);
                start = System.nanoTime();
                byte[] mongoBytes = new BasicBSONEncoder().encode(mongoData);
                long mongoWriteTime = System.nanoTime() - start;
                this.assertSame(bytes, mongoBytes, "BSON   ", "Mongo  ");
                start = System.nanoTime();
                new BasicBSONDecoder().decode(bytes, (BSONCallback)new BasicBSONCallback());
                long mongoReadTime = System.nanoTime() - start;
                Document fromMongo = this.reader.read((InputStream)new ByteArrayInputStream(mongoBytes));
                if (!fromMongo.equals(result)) {
                    System.out.println("from Schematic: " + result);
                    System.out.println("from Mongo:     " + fromMongo);
                    Assert.fail((String)("Document read from bytes written by Mongo did not match expected document: " + result));
                }
                if (this.print) {
                    System.out.println("Reading with Schematic:  " + this.percent(readTime, mongoReadTime) + " than Mongo");
                    System.out.println("Writing with Schematic:  " + this.percent(writeTime, mongoWriteTime) + " than Mongo");
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected String time(long nanos) {
        return "" + TimeUnit.NANOSECONDS.convert(nanos, TimeUnit.NANOSECONDS) + "ns";
    }

    protected String percent(long nanos1, long nanos2) {
        float percent = 100.0f * (float)(((double)nanos2 - (double)nanos1) / (double)nanos1);
        if ((double)percent < 0.0) {
            return "" + -percent + "% slower";
        }
        return "" + percent + "% faster";
    }

    protected BSONObject createMongoData(Document document) {
        BasicBSONObject obj = new BasicBSONObject();
        for (Document.Field field : document.fields()) {
            Object value = field.getValue();
            obj.put(field.getName(), this.createMongoData(value));
        }
        return obj;
    }

    protected Object createMongoData(Object value) {
        if (value instanceof MinKey) {
            value = "MinKey";
        } else if (value instanceof MaxKey) {
            value = "MaxKey";
        } else if (value instanceof Symbol) {
            Symbol symbol = (Symbol)value;
            value = new org.bson.types.Symbol(symbol.getSymbol());
        } else if (value instanceof ObjectId) {
            ObjectId id = (ObjectId)value;
            value = new org.bson.types.ObjectId(id.getBytes());
        } else if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            value = new BSONTimestamp(ts.getTime(), ts.getInc());
        } else if (value instanceof CodeWithScope) {
            CodeWithScope code = (CodeWithScope)value;
            value = new CodeWScope(code.getCode(), this.createMongoData(code.getScope()));
        } else if (value instanceof Code) {
            Code code = (Code)value;
            value = new org.bson.types.Code(code.getCode());
        } else if (value instanceof org.modeshape.schematic.document.Binary) {
            org.modeshape.schematic.document.Binary binary = (org.modeshape.schematic.document.Binary)value;
            value = new Binary(binary.getBytes());
        } else if (value instanceof List) {
            List values = (List)value;
            BasicBSONList newValues = new BasicBSONList();
            for (Object v : values) {
                newValues.add(this.createMongoData(v));
            }
            value = newValues;
        } else if (value instanceof Document) {
            value = this.createMongoData((Document)value);
        }
        return value;
    }

    protected Map<String, Object> createJacksonData(Document document) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        for (Document.Field field : document.fields()) {
            Object value = field.getValue();
            data.put(field.getName(), this.createJacksonData(value));
        }
        return data;
    }

    protected Object createJacksonData(Object value) {
        if (value instanceof MinKey) {
            value = JsonToken.VALUE_STRING;
        } else if (value instanceof MaxKey) {
            value = JsonToken.VALUE_STRING;
        } else if (value instanceof Symbol) {
            value = new de.undercouch.bson4jackson.types.Symbol(((Symbol)value).getSymbol());
        } else if (value instanceof ObjectId) {
            ObjectId id = (ObjectId)value;
            value = new de.undercouch.bson4jackson.types.ObjectId(id.getTime(), id.getMachine(), id.getInc());
        } else if (value instanceof Timestamp) {
            Timestamp ts = (Timestamp)value;
            value = new de.undercouch.bson4jackson.types.Timestamp(ts.getTime(), ts.getInc());
        } else if (value instanceof CodeWithScope) {
            CodeWithScope code = (CodeWithScope)value;
            value = new JavaScript(code.getCode(), this.createJacksonData(code.getScope()));
        } else if (value instanceof Code) {
            Code code = (Code)value;
            value = new JavaScript(code.getCode(), null);
        } else if (value instanceof List) {
            List values = (List)value;
            ArrayList<Object> newValues = new ArrayList<Object>(values.size());
            for (Object v : values) {
                newValues.add(this.createJacksonData(v));
            }
            value = newValues;
        } else if (value instanceof Document) {
            value = this.createJacksonData((Document)value);
        }
        return value;
    }

    protected void assertSame(byte[] b1, byte[] b2, String name1, String name2) {
        String sb2;
        if (b1.equals(b2)) {
            return;
        }
        int s1 = b1.length;
        int s2 = b2.length;
        String sb1 = this.toString(b1);
        if (!sb1.equals(sb2 = this.toString(b2))) {
            System.out.println(name1 + " size: " + this.padLeft(s1, 3) + " content: " + sb1);
            System.out.println(name2 + " size: " + this.padLeft(s2, 3) + " content: " + sb2);
            Assert.fail();
        }
    }

    protected String padLeft(Object value, int width) {
        String result;
        String string = result = value != null ? value.toString() : "null";
        while (result.length() < width) {
            result = " " + result;
        }
        return result;
    }

    protected String toString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(this.padLeft(b, 4)).append(' ');
        }
        return sb.toString();
    }

    protected boolean delete(File fileOrDirectory) {
        if (fileOrDirectory == null) {
            return false;
        }
        if (!fileOrDirectory.exists()) {
            return false;
        }
        if (fileOrDirectory.isDirectory()) {
            for (File childFile : fileOrDirectory.listFiles()) {
                this.delete(childFile);
            }
        }
        return fileOrDirectory.delete();
    }

    protected InputStream resource(String resourcePath) {
        InputStream stream = BsonReadingAndWritingTest.class.getClassLoader().getResourceAsStream(resourcePath);
        if (stream == null) {
            File file = new File(resourcePath);
            if (!file.exists()) {
                file = new File("src/test/resources" + resourcePath);
            }
            if (!file.exists()) {
                file = new File("src/test/resources/" + resourcePath);
            }
            if (file.exists()) {
                try {
                    stream = new FileInputStream(file);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)("Failed to open stream to \"" + file.getAbsolutePath() + "\""));
                }
            }
        }
        assert (stream != null) : "Resource at \"" + resourcePath + "\" could not be found";
        return stream;
    }
}

