/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic.internal.schema;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.schematic.internal.schema.DocumentTransformer;

public class SystemPropertyFactoryTest {
    private static final String TESTPROP = "test.prop";
    private static final String TESTPROPVALUE = "test.prop.value";
    private static final String TESTPROP2 = "test.prop2";
    private static final String TESTPROPVALUE2 = "test.prop.value2";

    @Before
    public void setUp() throws Exception {
        System.setProperty(TESTPROP, TESTPROPVALUE);
        System.setProperty(TESTPROP2, TESTPROPVALUE2);
    }

    protected void assertSystemPropertySubstituted(String input, String expected) {
        Assert.assertThat((Object)DocumentTransformer.getSubstitutedProperty((String)input, (DocumentTransformer.PropertyAccessor)DocumentTransformer.SystemPropertyAccessor.INSTANCE), (Matcher)Is.is((Object)expected));
    }

    @Test
    public void shouldSubstituteSingleVariable() {
        this.assertSystemPropertySubstituted("${test.prop}", TESTPROPVALUE);
        this.assertSystemPropertySubstituted("find.the.property.${test.prop}", "find.the.property.test.prop.value");
        this.assertSystemPropertySubstituted("${test.prop}.find.the.property", "test.prop.value.find.the.property");
        this.assertSystemPropertySubstituted("find.the.property.${test.prop}.find.the.property", "find.the.property.test.prop.value.find.the.property");
        String pathEnvironmentValue = System.getenv("PATH");
        if (pathEnvironmentValue != null) {
            this.assertSystemPropertySubstituted("${PATH}", pathEnvironmentValue);
        }
    }

    @Test
    public void shouldSubstituteFirstFoundMultipleVariables() {
        this.assertSystemPropertySubstituted("${any.prop,test.prop}", TESTPROPVALUE);
        this.assertSystemPropertySubstituted("find.the.property.${any.prop,test.prop}", "find.the.property.test.prop.value");
        this.assertSystemPropertySubstituted("${any.prop,test.prop}.find.the.property", "test.prop.value.find.the.property");
        this.assertSystemPropertySubstituted("find.the.property.${any.prop,test.prop}.find.the.property", "find.the.property.test.prop.value.find.the.property");
        this.assertSystemPropertySubstituted("${any.prop,test.prop,test.prop2}.find.the.property", "test.prop.value.find.the.property");
    }

    @Test
    public void shouldSubstituteMultipleVariablesWithDefault() {
        this.assertSystemPropertySubstituted("${any.prop1,any.prop2:test.prop.value}", TESTPROPVALUE);
        this.assertSystemPropertySubstituted("find.the.property.${any.prop1:test.prop.value}", "find.the.property.test.prop.value");
        this.assertSystemPropertySubstituted("${any.prop1,any.prop2:test.prop.value}.find.the.property", "test.prop.value.find.the.property");
        this.assertSystemPropertySubstituted("find.the.property.${any.prop:test.prop.value}.find.the.property", "find.the.property.test.prop.value.find.the.property");
    }

    @Test
    public void shouldSubstituteMultipleVariableGroups() {
        this.assertSystemPropertySubstituted("${test.prop}.double.${test.prop}", "test.prop.value.double.test.prop.value");
        this.assertSystemPropertySubstituted("${any.prop,test.prop}.double.${any.prop,test.prop}", "test.prop.value.double.test.prop.value");
        this.assertSystemPropertySubstituted("${any.prop:test.prop.value}.double.${any.prop:test.prop.value}", "test.prop.value.double.test.prop.value");
    }
}

