/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.FilenameEncoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.FileUtil;
import org.modeshape.search.lucene.LuceneConfiguration;
import org.modeshape.search.lucene.LuceneConfigurations;

public class LuceneConfigurationsTest {
    private LuceneConfiguration config;
    private String workspace;
    private String index;
    private Directory directory;
    private Multimap<String, String> indexNamesByWorkspaceName;
    private File tempArea;

    @Before
    public void beforeEach() {
        this.workspace = "workspace";
        this.index = "index";
        this.indexNamesByWorkspaceName = HashMultimap.create();
        this.tempArea = new File("target/configTest");
        if (this.tempArea.exists()) {
            FileUtil.delete((File)this.tempArea);
        }
        this.tempArea.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() {
        if (this.config != null) {
            try {
                for (Map.Entry entry : this.indexNamesByWorkspaceName.entries()) {
                    Assert.assertThat((Object)this.config.destroyDirectory((String)entry.getKey(), (String)entry.getValue()), Is.is(true));
                }
            }
            finally {
                this.config = null;
                this.directory = null;
                this.indexNamesByWorkspaceName.clear();
            }
        }
        if (this.tempArea != null) {
            try {
                FileUtil.delete((File)this.tempArea);
            }
            finally {
                this.tempArea = null;
            }
        }
    }

    protected void destroyDirectory(LuceneConfiguration config, String workspaceName, String indexName) {
        Assert.assertThat((Object)config.destroyDirectory(this.workspace, this.index), Is.is(true));
        this.indexNamesByWorkspaceName.remove((Object)workspaceName, (Object)indexName);
    }

    protected Directory getDirectory(LuceneConfiguration config, String workspaceName, String indexName) {
        Directory result = config.getDirectory(workspaceName, indexName);
        Assert.assertThat((Object)result, Is.is(IsNull.notNullValue()));
        this.indexNamesByWorkspaceName.put((Object)workspaceName, (Object)indexName);
        return result;
    }

    @Test
    public void shouldCreateConfigurationFromInMemoryStorage() {
        this.config = LuceneConfigurations.inMemory();
        Assert.assertThat((Object)this.config, Is.is(IsNull.notNullValue()));
        this.directory = this.getDirectory(this.config, this.workspace, this.index);
        Assert.assertThat((Object)this.directory, Is.is(IsInstanceOf.instanceOf(RAMDirectory.class)));
    }

    @Test
    public void shouldReturnSameDirectoryForSameWorkspaceAndIndexNamesFromInMemoryConfiguration() {
        this.config = LuceneConfigurations.inMemory();
        Assert.assertThat((Object)this.config, Is.is(IsNull.notNullValue()));
        this.directory = this.getDirectory(this.config, this.workspace, this.index);
        Assert.assertThat((Object)this.directory, Is.is(IsInstanceOf.instanceOf(RAMDirectory.class)));
        for (int i = 0; i != 10; ++i) {
            Assert.assertThat((Object)this.getDirectory(this.config, this.workspace, this.index), Is.is(IsSame.sameInstance(this.directory)));
        }
        Assert.assertThat((Object)this.indexNamesByWorkspaceName.size(), Is.is(1));
    }

    @Test
    public void shouldCreateConfigurationFromFileSystemStorage() {
        this.config = LuceneConfigurations.using((File)this.tempArea);
        Assert.assertThat((Object)this.config, Is.is(IsNull.notNullValue()));
        this.directory = this.getDirectory(this.config, this.workspace, this.index);
        Assert.assertThat((Object)this.directory, Is.is(IsInstanceOf.instanceOf(FSDirectory.class)));
        FSDirectory fsDirectory = (FSDirectory)this.directory;
        Assert.assertThat((Object)fsDirectory.getFile().getName(), Is.is(this.index));
        Assert.assertThat((Object)fsDirectory.getFile().getParentFile().getName(), Is.is(this.workspace));
    }

    @Test
    public void shouldReturnSameDirectoryForSameWorkspaceAndIndexNamesFromFileSystemStorage() {
        this.config = LuceneConfigurations.using((File)this.tempArea);
        Assert.assertThat((Object)this.config, Is.is(IsNull.notNullValue()));
        this.directory = this.getDirectory(this.config, this.workspace, this.index);
        Assert.assertThat((Object)this.directory, Is.is(IsInstanceOf.instanceOf(FSDirectory.class)));
        FSDirectory fsDirectory = (FSDirectory)this.directory;
        Assert.assertThat((Object)fsDirectory.getFile().getName(), Is.is(this.index));
        Assert.assertThat((Object)fsDirectory.getFile().getParentFile().getName(), Is.is(this.workspace));
        for (int i = 0; i != 10; ++i) {
            Assert.assertThat((Object)this.getDirectory(this.config, this.workspace, this.index), Is.is(IsSame.sameInstance(this.directory)));
        }
        Assert.assertThat((Object)this.indexNamesByWorkspaceName.size(), Is.is(1));
    }

    @Test
    public void shouldEncodeDirectoryNames() {
        FilenameEncoder encoder = new FilenameEncoder();
        this.index = "some/special::/\nindex(name)";
        this.workspace = "some/special::/\nworkspace(name)/illegalInWindows:\\/?%*|\"'<>.txt";
        Assert.assertThat((Object)this.index, Is.is(IsNot.not(encoder.encode(this.index))));
        Assert.assertThat((Object)this.workspace, Is.is(IsNot.not(encoder.encode(this.workspace))));
        this.config = LuceneConfigurations.using((File)this.tempArea, null, (TextEncoder)encoder, (TextEncoder)encoder);
        Assert.assertThat((Object)this.config, Is.is(IsNull.notNullValue()));
        this.directory = this.getDirectory(this.config, this.workspace, this.index);
        Assert.assertThat((Object)this.directory, Is.is(IsInstanceOf.instanceOf(FSDirectory.class)));
        FSDirectory fsDirectory = (FSDirectory)this.directory;
        Assert.assertThat((Object)fsDirectory.getFile().getName(), Is.is(encoder.encode(this.index)));
        Assert.assertThat((Object)fsDirectory.getFile().getParentFile().getName(), Is.is(encoder.encode(this.workspace)));
    }
}

