/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.Query;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.Selector;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Source;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.parse.SqlQueryParser;
import org.modeshape.graph.query.process.QueryResultColumns;
import org.modeshape.graph.query.process.QueryResults;
import org.modeshape.graph.query.validate.ImmutableSchemata;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.search.SearchEngine;
import org.modeshape.graph.search.SearchEngineIndexer;
import org.modeshape.graph.search.SearchEngineProcessor;
import org.modeshape.search.lucene.IndexRules;
import org.modeshape.search.lucene.LuceneConfiguration;
import org.modeshape.search.lucene.LuceneConfigurations;
import org.modeshape.search.lucene.LuceneSearchEngine;
import org.xml.sax.SAXException;

public class LuceneSearchEngineTest {
    private SearchEngine engine;
    private ExecutionContext context;
    private TypeSystem typeSystem;
    private String sourceName;
    private String workspaceName1;
    private String workspaceName2;
    private InMemoryRepositorySource source;
    private RepositoryConnectionFactory connectionFactory;
    private Graph content;
    private Schemata schemata;
    private SqlQueryParser sql;
    private Map<String, Object> variables;
    private boolean print = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void beforeEach() throws Exception {
        this.context = new ExecutionContext();
        this.typeSystem = this.context.getValueFactories().getTypeSystem();
        this.sourceName = "sourceA";
        this.workspaceName1 = "workspace1";
        this.workspaceName2 = "workspace2";
        this.source = new InMemoryRepositorySource();
        this.source.setName(this.sourceName);
        this.content = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
        this.content.createWorkspace().named(this.workspaceName1);
        this.content.createWorkspace().named(this.workspaceName2);
        this.connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                return LuceneSearchEngineTest.this.source.getConnection();
            }
        };
        IndexRules.Builder rulesBuilder = IndexRules.createBuilder((IndexRules)LuceneSearchEngine.DEFAULT_RULES);
        rulesBuilder.defaultTo(Field.Store.YES, Field.Index.NOT_ANALYZED, false, true);
        rulesBuilder.stringField(this.name("model"), Field.Store.YES, Field.Index.ANALYZED, false, true);
        rulesBuilder.integerField(this.name("year"), Field.Store.YES, Field.Index.NOT_ANALYZED);
        rulesBuilder.floatField(this.name("userRating"), Field.Store.YES, Field.Index.NOT_ANALYZED, Float.valueOf(0.0f), Float.valueOf(10.0f));
        rulesBuilder.integerField(this.name("mpgCity"), Field.Store.YES, Field.Index.NOT_ANALYZED, Integer.valueOf(0), Integer.valueOf(50));
        rulesBuilder.integerField(this.name("mpgHighway"), Field.Store.YES, Field.Index.NOT_ANALYZED, Integer.valueOf(0), Integer.valueOf(50));
        IndexRules rules = rulesBuilder.build();
        LuceneConfiguration luceneConfig = LuceneConfigurations.inMemory();
        Analyzer analyzer = null;
        this.engine = new LuceneSearchEngine(this.sourceName, this.connectionFactory, true, luceneConfig, rules, analyzer);
        this.loadContent();
        SearchEngineProcessor processor = this.engine.createProcessor(this.context, null, false);
        try {
            for (String workspaceName : this.content.getWorkspaces()) {
                processor.process(new VerifyWorkspaceRequest(workspaceName));
            }
        }
        finally {
            processor.close();
        }
        this.schemata = ImmutableSchemata.createBuilder((TypeSystem)this.typeSystem).addTable("__ALLNODES__", new String[]{"maker", "model", "year", "msrp", "mpgHighway", "mpgCity"}).makeSearchable("__ALLNODES__", "maker").build();
        this.sql = new SqlQueryParser();
        this.variables = new HashMap<String, Object>();
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected void loadContent() throws IOException, SAXException {
        this.content.useWorkspace(this.workspaceName1);
        this.content.importXmlFrom(this.getClass().getClassLoader().getResourceAsStream("cars.xml")).into("/");
        this.content.useWorkspace(this.workspaceName2);
        this.content.importXmlFrom(this.getClass().getClassLoader().getResourceAsStream("aircraft.xml")).into("/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.modeshape.graph.query.QueryResults search(String workspaceName, String searchExpression, int maxResults, int offset) {
        SearchEngineProcessor processor = this.engine.createProcessor(this.context, null, true);
        try {
            FullTextSearchRequest request = new FullTextSearchRequest(searchExpression, workspaceName, maxResults, offset);
            processor.process(request);
            if (request.hasError()) {
                Assert.fail((String)request.getError().getMessage());
                org.modeshape.graph.query.QueryResults queryResults = null;
                return queryResults;
            }
            Assert.assertThat((Object)request.getResultColumns().getColumnCount(), Is.is(0));
            Assert.assertThat((Object)request.getResultColumns().getLocationCount(), Is.is(1));
            Assert.assertThat((Object)request.getResultColumns().hasFullTextSearchScores(), Is.is(true));
            List tuples = request.getTuples();
            ArrayList<Location> results = new ArrayList<Location>(tuples.size());
            for (Object[] tuple : tuples) {
                results.add((Location)tuple[0]);
                Float score = (Float)tuple[1];
                Assert.assertThat((Object)score, Is.is(IsNull.notNullValue()));
            }
            QueryResults queryResults = new QueryResults(request.getResultColumns(), request.getStatistics(), request.getTuples());
            return queryResults;
        }
        finally {
            processor.close();
        }
    }

    protected List<Constraint> getAndedConstraint(Constraint constraint, List<Constraint> andedConstraints) {
        if (constraint != null) {
            if (constraint instanceof And) {
                And and = (And)constraint;
                this.getAndedConstraint(and.left(), andedConstraints);
                this.getAndedConstraint(and.right(), andedConstraints);
            } else {
                andedConstraints.add(constraint);
            }
        }
        return andedConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.modeshape.graph.query.QueryResults query(String workspaceName, String sql) {
        QueryCommand command = this.sql.parseQuery(sql, this.typeSystem);
        Assert.assertThat((Object)command, Is.is(IsInstanceOf.instanceOf(Query.class)));
        Query query = (Query)command;
        Source source = query.source();
        Assert.assertThat((Object)source, Is.is(IsInstanceOf.instanceOf(Selector.class)));
        SelectorName tableName = ((Selector)source).name();
        Constraint constraint = query.constraint();
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i != query.columns().size(); ++i) {
            types.add(PropertyType.STRING.getName());
        }
        QueryResultColumns resultColumns = new QueryResultColumns(query.columns(), types, QueryResultColumns.includeFullTextScores((Constraint)constraint));
        List<Constraint> andedConstraints = this.getAndedConstraint(constraint, new ArrayList<Constraint>());
        Limit limit = query.limits();
        SearchEngineProcessor processor = this.engine.createProcessor(this.context, null, true);
        try {
            AccessQueryRequest request = new AccessQueryRequest(workspaceName, tableName, (QueryResults.Columns)resultColumns, andedConstraints, limit, this.schemata, this.variables);
            processor.process(request);
            if (request.hasError()) {
                Assert.fail((String)request.getError().getMessage());
            }
            QueryResults queryResults = new QueryResults(request.resultColumns(), request.getStatistics(), request.getTuples());
            return queryResults;
        }
        finally {
            processor.close();
        }
    }

    @Test
    public void shouldIndexAllContentInRepositorySource() throws Exception {
        SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.engine, this.connectionFactory);
        indexer.indexAllWorkspaces().close();
    }

    @Test
    public void shouldIndexAllContentInWorkspace() throws Exception {
        SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.engine, this.connectionFactory);
        indexer.index(this.workspaceName1);
        indexer.index(this.workspaceName2);
        indexer.close();
    }

    @Test
    public void shouldIndexAllContentInWorkspaceBelowPath() throws Exception {
        SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.engine, this.connectionFactory);
        indexer.index(this.workspaceName1, this.path("/Cars/Hybrid"), 3);
        indexer.index(this.workspaceName2, this.path("/Aircraft/Commercial"), 5);
        indexer.close();
    }

    @Test
    public void shouldReIndexAllContentInWorkspaceBelowPath() throws Exception {
        SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.engine, this.connectionFactory);
        for (int i = 0; i != 0; ++i) {
            indexer.index(this.workspaceName1, this.path("/Cars/Hybrid"), 3);
            indexer.index(this.workspaceName2, this.path("/Aircraft/Commercial"), 5);
        }
        indexer.close();
    }

    @Test
    public void shouldHaveLoadedTestContentIntoRepositorySource() {
        this.content.useWorkspace(this.workspaceName1);
        Assert.assertThat((Object)this.content.getNodeAt("/Cars/Hybrid/Toyota Prius").getProperty("msrp").getFirstValue(), Is.is("$21,500"));
    }

    @Test
    public void shouldIndexRepositoryContentStartingAtRootAndUsingDepthOfOne() {
        SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.engine, this.connectionFactory);
        indexer.index(this.workspaceName1, this.path("/"), 1);
        indexer.close();
    }

    @Test
    public void shouldIndexRepositoryContentStartingAtRootAndUsingDepthOfTwo() {
        SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.engine, this.connectionFactory);
        indexer.index(this.workspaceName1, this.path("/"), 2);
        indexer.close();
    }

    @Test
    public void shouldIndexRepositoryContentStartingAtRootAndUsingDepthOfThree() {
        SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.engine, this.connectionFactory);
        indexer.index(this.workspaceName1, this.path("/"), 3);
        indexer.close();
    }

    @Test
    public void shouldIndexRepositoryContentStartingAtRootAndUsingDepthOfFour() {
        SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.engine, this.connectionFactory);
        indexer.index(this.workspaceName1, this.path("/"), 4);
        indexer.close();
    }

    @Test
    public void shouldIndexRepositoryContentStartingAtRootAndUsingDepthOfTen() {
        SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.engine, this.connectionFactory);
        indexer.index(this.workspaceName1, this.path("/"), 10);
        indexer.close();
    }

    @Test
    public void shouldIndexRepositoryContentStartingAtNonRootNode() {
        SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.engine, this.connectionFactory);
        indexer.index(this.workspaceName1, this.path("/Cars"), 10);
        indexer.close();
    }

    @Test
    public void shouldReIndexRepositoryContentStartingAtNonRootNode() {
        SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.engine, this.connectionFactory);
        indexer.index(this.workspaceName1, this.path("/Cars"), 10);
        indexer.index(this.workspaceName1, this.path("/Cars"), 10);
        indexer.index(this.workspaceName1, this.path("/Cars"), 10);
        indexer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexWorkspace(String workspaceName) {
        SearchEngineIndexer indexer = new SearchEngineIndexer(this.context, this.engine, this.connectionFactory);
        try {
            indexer.index(workspaceName, this.path("/"));
        }
        finally {
            indexer.close();
        }
    }

    @Test
    public void shouldFindNodesByFullTextSearch() {
        this.indexWorkspace(this.workspaceName1);
        org.modeshape.graph.query.QueryResults results = this.search(this.workspaceName1, "Toyota Prius", 10, 0);
        Assert.assertThat((Object)results, Is.is(IsNull.notNullValue()));
        this.assertRowCount(results, 2);
        Location first = (Location)((Object[])results.getTuples().get(0))[0];
        Location second = (Location)((Object[])results.getTuples().get(1))[0];
        Assert.assertThat((Object)first.getPath(), Is.is(this.path("/Cars/Hybrid/Toyota Prius")));
        Assert.assertThat((Object)second.getPath(), Is.is(this.path("/Cars/Hybrid/Toyota Highlander")));
    }

    @Test
    public void shouldFindNodesByFullTextSearchWithOffset() {
        this.indexWorkspace(this.workspaceName1);
        org.modeshape.graph.query.QueryResults results = this.search(this.workspaceName1, "toyota prius", 1, 0);
        Assert.assertThat((Object)results, Is.is(IsNull.notNullValue()));
        this.assertRowCount(results, 1);
        Location first = (Location)((Object[])results.getTuples().get(0))[0];
        Assert.assertThat((Object)first.getPath(), Is.is(this.path("/Cars/Hybrid/Toyota Prius")));
        results = this.search(this.workspaceName1, "+Toyota", 1, 1);
        Assert.assertThat((Object)results, Is.is(IsNull.notNullValue()));
        this.assertRowCount(results, 1);
        first = (Location)((Object[])results.getTuples().get(0))[0];
        Assert.assertThat((Object)first.getPath(), Is.is(this.path("/Cars/Hybrid/Toyota Highlander")));
    }

    @Test
    public void shouldFindAllNodesBySimpleQuery() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT [jcr:primaryType] FROM __ALLNODES__";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 18);
    }

    @Test
    public void shouldFindNodesBySimpleQuery() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 18);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithEqualityComparisonCriteria() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE maker = 'Toyota'";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 2);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithGreaterThanComparisonCriteria() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker, mpgHighway, mpgCity FROM __ALLNODES__ WHERE mpgHighway > 20";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 6);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithLowercaseEqualityComparisonCriteria() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE LOWER(maker) = 'toyota'";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 2);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithUppercaseEqualityComparisonCriteria() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE UPPER(maker) = 'TOYOTA'";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 2);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithLikeComparisonCriteria() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE maker LIKE 'Toyo%'";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 2);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithLikeComparisonCriteriaWithLeadingWildcard() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE maker LIKE '%yota'";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 2);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithLowercaseLikeComparisonCriteria() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE LOWER(maker) LIKE 'toyo%'";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 2);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithFullTextSearchCriteria() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE CONTAINS(maker,'martin')";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 1);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithDepthCriteria() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE DEPTH() > 2";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 12);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithLocalNameCriteria() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE LOCALNAME() LIKE 'Toyota%' OR LOCALNAME() LIKE 'Land %'";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 4);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithNameCriteria() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE NAME() LIKE 'Toyota%[1]' OR NAME() LIKE 'Land %'";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 4);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithNameCriteriaThatMatchesNoNodes() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE NAME() LIKE 'Toyota%[2]'";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 0);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithPathCriteria() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE PATH() LIKE '/Cars[%]/Hy%/Toyota%' OR PATH() LIKE '/Cars[1]/Utility[1]/%'";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 6);
    }

    @Test
    public void shouldFindNodesBySimpleQueryWithDescendantCriteria() {
        this.indexWorkspace(this.workspaceName1);
        String query = "SELECT model, maker FROM __ALLNODES__ WHERE ISDESCENDANTNODE('/Cars/Hybrid')";
        org.modeshape.graph.query.QueryResults results = this.query(this.workspaceName1, query);
        this.assertRowCount(results, 3);
    }

    protected void assertRowCount(org.modeshape.graph.query.QueryResults results, int rowCount) {
        Assert.assertThat((Object)results.getProblems().isEmpty(), Is.is(true));
        Assert.assertThat((Object)results.getTuples().size(), Is.is(rowCount));
        if (this.print) {
            System.out.println(results);
        }
    }
}

