/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene.query;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class MatchNoneQuery
extends Query {
    private static final long serialVersionUID = 1L;

    public Weight createWeight(Searcher searcher) {
        return new NoneWeight();
    }

    public Object clone() {
        return new MatchNoneQuery();
    }

    public String toString(String field) {
        return "NO DOCS";
    }

    protected static class NoneScorer
    extends Scorer {
        private int docId = -1;

        protected NoneScorer() {
            super(Similarity.getDefault());
        }

        public int docID() {
            return this.docId;
        }

        public int nextDoc() {
            this.docId = Integer.MAX_VALUE;
            return this.docId;
        }

        public int advance(int target) {
            return Integer.MAX_VALUE;
        }

        public float score() {
            return 1.0f;
        }
    }

    protected class NoneWeight
    extends Weight {
        private static final long serialVersionUID = 1L;

        protected NoneWeight() {
        }

        public Query getQuery() {
            return MatchNoneQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) {
            return new NoneScorer();
        }

        public Explanation explain(IndexReader reader, int doc) {
            return new Explanation(this.getValue(), "NO VALUES");
        }
    }
}

