/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import net.jcip.annotations.NotThreadSafe;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.process.FullTextSearchResultColumns;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.LockBranchRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.UnlockBranchRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.search.AbstractSearchEngine;
import org.modeshape.search.lucene.AbstractLuceneSearchEngine;
import org.modeshape.search.lucene.LuceneSearchSession;
import org.modeshape.search.lucene.LuceneSearchWorkspace;

@NotThreadSafe
public class LuceneSearchProcessor
extends AbstractLuceneSearchEngine.AbstractLuceneProcessor<LuceneSearchWorkspace, LuceneSearchSession> {
    protected static final QueryResults.Columns FULL_TEXT_RESULT_COLUMNS = new FullTextSearchResultColumns();
    private static final Logger logger = Logger.getLogger(LuceneSearchProcessor.class);

    protected LuceneSearchProcessor(String sourceName, ExecutionContext context, AbstractSearchEngine.Workspaces<LuceneSearchWorkspace> workspaces, Observer observer, DateTime now, boolean readOnly) {
        super(sourceName, context, workspaces, observer, now, readOnly);
    }

    @Override
    protected LuceneSearchSession createSessionFor(LuceneSearchWorkspace workspace) {
        return new LuceneSearchSession(workspace, this);
    }

    @Override
    protected String fullTextFieldName(String propertyName) {
        return propertyName == null ? "::fts" : ":ft:" + propertyName;
    }

    public void process(FullTextSearchRequest request) {
        LuceneSearchSession session = (LuceneSearchSession)this.getSessionFor((Request)request, request.workspace(), false);
        if (session == null) {
            return;
        }
        try {
            ArrayList<Object[]> results = new ArrayList<Object[]>();
            QueryResults.Statistics statistics = session.search(request.expression(), results, request.maxResults(), request.offset());
            request.setResults(FULL_TEXT_RESULT_COLUMNS, results, statistics);
        }
        catch (ParseException e) {
            request.setError((Throwable)e);
        }
        catch (IOException e) {
            request.setError((Throwable)e);
        }
    }

    public void process(VerifyWorkspaceRequest request) {
        LuceneSearchSession session = (LuceneSearchSession)this.getSessionFor((Request)request, request.workspaceName(), true);
        if (session == null) {
            return;
        }
        request.setActualWorkspaceName(session.getWorkspaceName());
        try {
            request.setActualRootLocation(session.getLocationForRoot());
        }
        catch (IOException e) {
            request.setError((Throwable)e);
        }
    }

    public void process(GetWorkspacesRequest request) {
        HashSet<String> names = new HashSet<String>();
        for (LuceneSearchWorkspace workspace : this.workspaces.getWorkspaces()) {
            names.add(workspace.getWorkspaceName());
        }
        request.setAvailableWorkspaceNames(names);
    }

    public void process(CreateNodeRequest request) {
        LuceneSearchSession session = (LuceneSearchSession)this.getSessionFor((Request)request, request.inWorkspace(), true);
        if (session == null) {
            return;
        }
        Location location = request.getActualLocationOfNode();
        assert (location != null);
        try {
            session.setOrReplaceProperties(location, request.properties());
            session.recordChange();
        }
        catch (IOException e) {
            request.setError((Throwable)e);
        }
    }

    public void process(UpdatePropertiesRequest request) {
        LuceneSearchSession session = (LuceneSearchSession)this.getSessionFor((Request)request, request.inWorkspace(), true);
        if (session == null) {
            return;
        }
        Location location = request.getActualLocationOfNode();
        assert (location != null);
        try {
            session.setOrReplaceProperties(location, request.properties().values());
            session.recordChange();
        }
        catch (IOException e) {
            request.setError((Throwable)e);
        }
    }

    public void process(DeleteBranchRequest request) {
        LuceneSearchSession session = (LuceneSearchSession)this.getSessionFor((Request)request, request.inWorkspace());
        if (session == null) {
            return;
        }
        Path path = request.at().getPath();
        assert (!this.readOnly);
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("index for \"{0}\" workspace: DEL '{1}' branch", new Object[]{request.inWorkspace(), this.stringFactory.create(path)});
            }
            Query query = session.findAllNodesAtOrBelow(path);
            session.getContentWriter().deleteDocuments(query);
            session.recordChanges(100);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            request.setError((Throwable)e);
        }
    }

    public void process(DestroyWorkspaceRequest request) {
        LuceneSearchWorkspace workspace = (LuceneSearchWorkspace)this.getWorkspace((Request)request, request.workspaceName(), false);
        if (workspace == null) {
            return;
        }
        try {
            LuceneSearchSession session = (LuceneSearchSession)this.getSessionFor((Request)request, workspace.getWorkspaceName());
            request.setActualRootLocation(session.getLocationForRoot());
            workspace.destroy(this.getExecutionContext());
            session.recordChanges(101);
        }
        catch (IOException e) {
            request.setError((Throwable)e);
        }
    }

    public void process(LockBranchRequest request) {
        request.setActualLocation(request.at());
    }

    public void process(UnlockBranchRequest request) {
        request.setActualLocation(request.at());
    }

    public void process(CloneBranchRequest request) {
        super.processUnknownRequest((Request)request);
    }

    public void process(CloneWorkspaceRequest request) {
        super.processUnknownRequest((Request)request);
    }

    public void process(CopyBranchRequest request) {
        super.processUnknownRequest((Request)request);
    }

    public void process(CreateWorkspaceRequest request) {
        super.processUnknownRequest((Request)request);
    }

    public void process(MoveBranchRequest request) {
        super.processUnknownRequest((Request)request);
    }

    public void process(ReadAllChildrenRequest request) {
        super.processUnknownRequest((Request)request);
    }

    public void process(ReadAllPropertiesRequest request) {
        super.processUnknownRequest((Request)request);
    }
}

