/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene;

import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.search.SearchEngineWorkspace;
import org.modeshape.search.lucene.IndexRules;
import org.modeshape.search.lucene.LuceneConfiguration;
import org.modeshape.search.lucene.LuceneSearchEngine;

@Immutable
public class LuceneSearchWorkspace
implements SearchEngineWorkspace {
    protected static final int CHANGES_BEFORE_OPTIMIZATION = 1;
    protected static final String INDEX_NAME = "content";
    protected static final String FULL_TEXT_PREFIX = ":ft:";
    private final String workspaceName;
    private final String workspaceDirectoryName;
    protected final IndexRules rules;
    private final LuceneConfiguration configuration;
    protected final Directory contentDirectory;
    protected final Analyzer analyzer;
    private final Lock changesLock = new ReentrantLock();
    private int changes = 0;

    protected LuceneSearchWorkspace(String workspaceName, LuceneConfiguration configuration, IndexRules rules, Analyzer analyzer) {
        assert (workspaceName != null);
        assert (configuration != null);
        this.workspaceName = workspaceName;
        this.workspaceDirectoryName = workspaceName.trim().length() != 0 ? workspaceName : UUID.randomUUID().toString();
        this.analyzer = analyzer != null ? analyzer : new StandardAnalyzer(configuration.getVersion());
        this.rules = rules != null ? rules : LuceneSearchEngine.DEFAULT_RULES;
        this.configuration = configuration;
        this.contentDirectory = this.configuration.getDirectory(this.workspaceDirectoryName, INDEX_NAME);
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void destroy(ExecutionContext context) {
        this.configuration.destroyDirectory(this.workspaceDirectoryName, INDEX_NAME);
    }

    public IndexRules getRules() {
        return this.rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isOptimizationRequired(int changesInSession) {
        if (changesInSession == 0) {
            return false;
        }
        assert (changesInSession > 0);
        try {
            this.changesLock.lock();
            this.changes += changesInSession;
            if (this.changes >= 1) {
                this.changes = 0;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.changesLock.unlock();
        }
    }

    public Version getVersion() {
        return this.configuration.getVersion();
    }

    static class ContentIndex {
        public static final String PATH = "::pth";
        public static final String NODE_NAME = "::nam";
        public static final String LOCAL_NAME = "::loc";
        public static final String SNS_INDEX = "::sns";
        public static final String LOCATION_ID_PROPERTIES = "::idp";
        public static final String DEPTH = "::dep";
        public static final String FULL_TEXT = "::fts";
        public static final String REFERENCES = "::ref";
        public static final String STRONG_REFERENCES = "::refInt";

        ContentIndex() {
        }
    }
}

