/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene.query;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.search.lucene.query.CompareQuery;

public class CompareLengthQuery
extends CompareQuery<Integer> {
    private static final long serialVersionUID = 1L;
    protected static final CompareQuery.Evaluator<Integer> EQUAL_TO = new CompareQuery.Evaluator<Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Integer nodeValue, Integer length) {
            return nodeValue == length;
        }

        public String toString() {
            return " = ";
        }
    };
    protected static final CompareQuery.Evaluator<Integer> NOT_EQUAL_TO = new CompareQuery.Evaluator<Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Integer nodeValue, Integer length) {
            return nodeValue == length;
        }

        public String toString() {
            return " != ";
        }
    };
    protected static final CompareQuery.Evaluator<Integer> IS_LESS_THAN = new CompareQuery.Evaluator<Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Integer nodeValue, Integer length) {
            return nodeValue < length;
        }

        public String toString() {
            return " < ";
        }
    };
    protected static final CompareQuery.Evaluator<Integer> IS_LESS_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Integer nodeValue, Integer length) {
            return nodeValue < length;
        }

        public String toString() {
            return " <= ";
        }
    };
    protected static final CompareQuery.Evaluator<Integer> IS_GREATER_THAN = new CompareQuery.Evaluator<Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Integer nodeValue, Integer length) {
            return nodeValue < length;
        }

        public String toString() {
            return " > ";
        }
    };
    protected static final CompareQuery.Evaluator<Integer> IS_GREATER_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Integer>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Integer nodeValue, Integer length) {
            return nodeValue < length;
        }

        public String toString() {
            return " >= ";
        }
    };

    public static CompareLengthQuery createQueryForNodesWithFieldEqualTo(Integer constraintValue, String fieldName, ValueFactories factories) {
        return new CompareLengthQuery(fieldName, constraintValue, (ValueFactory<String>)factories.getStringFactory(), IS_GREATER_THAN);
    }

    public static CompareLengthQuery createQueryForNodesWithFieldNotEqualTo(Integer constraintValue, String fieldName, ValueFactories factories) {
        return new CompareLengthQuery(fieldName, constraintValue, (ValueFactory<String>)factories.getStringFactory(), IS_GREATER_THAN);
    }

    public static CompareLengthQuery createQueryForNodesWithFieldGreaterThan(Integer constraintValue, String fieldName, ValueFactories factories) {
        return new CompareLengthQuery(fieldName, constraintValue, (ValueFactory<String>)factories.getStringFactory(), IS_GREATER_THAN);
    }

    public static CompareLengthQuery createQueryForNodesWithFieldGreaterThanOrEqualTo(Integer constraintValue, String fieldName, ValueFactories factories) {
        return new CompareLengthQuery(fieldName, constraintValue, (ValueFactory<String>)factories.getStringFactory(), IS_GREATER_THAN_OR_EQUAL_TO);
    }

    public static CompareLengthQuery createQueryForNodesWithFieldLessThan(Integer constraintValue, String fieldName, ValueFactories factories) {
        return new CompareLengthQuery(fieldName, constraintValue, (ValueFactory<String>)factories.getStringFactory(), IS_LESS_THAN);
    }

    public static CompareLengthQuery createQueryForNodesWithFieldLessThanOrEqualTo(Integer constraintValue, String fieldName, ValueFactories factories) {
        return new CompareLengthQuery(fieldName, constraintValue, (ValueFactory<String>)factories.getStringFactory(), IS_LESS_THAN_OR_EQUAL_TO);
    }

    protected CompareLengthQuery(String fieldName, Integer constraintValue, ValueFactory<String> stringFactory, CompareQuery.Evaluator<Integer> evaluator) {
        super(fieldName, constraintValue, null, stringFactory, evaluator);
    }

    @Override
    protected Integer readFromDocument(IndexReader reader, int docId) throws IOException {
        Document doc = reader.document(docId, this.fieldSelector);
        String valueString = doc.get(this.fieldName);
        String value = (String)this.stringFactory.create(valueString);
        return value != null ? value.length() : 0;
    }

    public Object clone() {
        return new CompareLengthQuery(this.fieldName, (Integer)this.constraintValue, (ValueFactory<String>)this.stringFactory, this.evaluator);
    }
}

