/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.modeshape.search.lucene.query.NotQuery;

public class NotQueryTest {
    @Test
    public void scorerShouldSkipAdjacentDocsIfScoredByOperandScorer() throws IOException {
        IndexReader reader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)reader.isDeleted(Matchers.anyInt())).thenReturn((Object)false);
        Mockito.when((Object)reader.maxDoc()).thenReturn((Object)10);
        MockScorer operandScorer = new MockScorer(0, 1, 2, 3, 4);
        NotQuery.NotScorer notScorer = new NotQuery.NotScorer((Scorer)operandScorer, reader, null);
        this.assertScores((Scorer)notScorer, 5, 6, 7, 8, 9);
    }

    @Test
    public void scorerShouldSkipDocsAtEndIfScoredByOperandScorer() throws IOException {
        IndexReader reader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)reader.isDeleted(Matchers.anyInt())).thenReturn((Object)false);
        Mockito.when((Object)reader.maxDoc()).thenReturn((Object)10);
        MockScorer operandScorer = new MockScorer(8, 9);
        NotQuery.NotScorer notScorer = new NotQuery.NotScorer((Scorer)operandScorer, reader, null);
        this.assertScores((Scorer)notScorer, 0, 1, 2, 3, 4, 5, 6, 7);
    }

    @Test
    public void scorerShouldScoreFirstDocsIfNotScoredByOperandScorer() throws IOException {
        IndexReader reader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)reader.isDeleted(Matchers.anyInt())).thenReturn((Object)false);
        Mockito.when((Object)reader.maxDoc()).thenReturn((Object)10);
        MockScorer operandScorer = new MockScorer(2, 3, 4);
        NotQuery.NotScorer notScorer = new NotQuery.NotScorer((Scorer)operandScorer, reader, null);
        this.assertScores((Scorer)notScorer, 0, 1, 5, 6, 7, 8, 9);
    }

    @Test
    public void scorerShouldScoreNonAdjacentDocsNotScoredByOperandScorer() throws IOException {
        IndexReader reader = (IndexReader)Mockito.mock(IndexReader.class);
        Mockito.when((Object)reader.isDeleted(Matchers.anyInt())).thenReturn((Object)false);
        Mockito.when((Object)reader.maxDoc()).thenReturn((Object)10);
        MockScorer operandScorer = new MockScorer(2, 4, 8);
        NotQuery.NotScorer notScorer = new NotQuery.NotScorer((Scorer)operandScorer, reader, null);
        this.assertScores((Scorer)notScorer, 0, 1, 3, 5, 6, 7, 9);
    }

    protected void assertScores(Scorer scorer, int ... docIds) throws IOException {
        for (int docId : docIds) {
            Assert.assertThat((Object)scorer.nextDoc(), (Matcher)Is.is((Object)docId));
            Assert.assertThat((Object)Float.valueOf(scorer.score()), (Matcher)Is.is((Object)Float.valueOf(1.0f)));
        }
        Assert.assertThat((Object)scorer.nextDoc(), (Matcher)Is.is((Object)Integer.MAX_VALUE));
    }

    protected static class MockScorer
    extends Scorer {
        private final Iterator<Integer> docIds;

        protected MockScorer(int ... docIds) {
            super((Weight)null);
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (int docId : docIds) {
                ids.add(new Integer(docId));
            }
            this.docIds = ids.iterator();
        }

        public int advance(int target) {
            int doc;
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        public int docID() {
            return this.nextDoc();
        }

        public int nextDoc() {
            if (this.docIds.hasNext()) {
                return this.docIds.next();
            }
            return Integer.MAX_VALUE;
        }

        public float score() {
            throw new UnsupportedOperationException("Should not be called");
        }
    }
}

