/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.audio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.audio.AudioMetadata;
import org.modeshape.sequencer.audio.AudioMetadataArtwork;

public class AudioMetadataSequencer
extends Sequencer {
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.registerNodeTypes("audio.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(AudioMetadata.MIME_TYPE_STRINGS);
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = (Binary)inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        String mimeType = binaryValue.getMimeType();
        boolean isValid = false;
        AudioMetadata metadata = null;
        try (InputStream stream = binaryValue.getStream();){
            metadata = new AudioMetadata(stream, mimeType);
            isValid = metadata.check();
        }
        catch (Exception e) {
            this.getLogger().error((Throwable)e, "Could not sequence audio file with MIMEType {0}", new Object[]{mimeType});
        }
        if (isValid) {
            Node sequencedNode = outputNode;
            if (outputNode.isNew()) {
                outputNode.setPrimaryType("audio:metadata");
            } else {
                sequencedNode = outputNode.addNode("audio:metadata", "audio:metadata");
            }
            sequencedNode.setProperty("audio:formatName", metadata.getFormatName());
            this.setPropertyIfMetadataPresent(sequencedNode, "jcr:mimeType", mimeType);
            this.setPropertyIfMetadataPresent(sequencedNode, "audio:bitrate", metadata.getBitrate());
            this.setPropertyIfMetadataPresent(sequencedNode, "audio:sampleRate", metadata.getSampleRate());
            this.setPropertyIfMetadataPresent(sequencedNode, "audio:channels", metadata.getChannels());
            this.setPropertyIfMetadataPresent(sequencedNode, "audio:duration", metadata.getDuration());
            this.addTagNode(sequencedNode, metadata);
            return true;
        }
        this.getLogger().error("Could not sequence audio file with MIMEType {0}", new Object[]{mimeType});
        return false;
    }

    private void addTagNode(Node sequencedNode, AudioMetadata metadata) throws RepositoryException {
        Node tagNode = sequencedNode.addNode("audio:tag", "audio:tag");
        this.setPropertyIfMetadataPresent(tagNode, "audio:title", metadata.getTitle());
        this.setPropertyIfMetadataPresent(tagNode, "audio:artist", metadata.getArtist());
        this.setPropertyIfMetadataPresent(tagNode, "audio:album", metadata.getAlbum());
        this.setPropertyIfMetadataPresent(tagNode, "audio:year", metadata.getYear());
        this.setPropertyIfMetadataPresent(tagNode, "audio:comment", metadata.getComment());
        this.setPropertyIfMetadataPresent(tagNode, "audio:track", metadata.getTrack());
        this.setPropertyIfMetadataPresent(tagNode, "audio:genre", metadata.getGenre());
        for (AudioMetadataArtwork artwork : metadata.getArtwork()) {
            Node artworkNode = tagNode.addNode("audio:artwork", "audio:artwork");
            this.setPropertyIfMetadataPresent(artworkNode, "jcr:mimeType", artwork.getMimeType());
            this.setPropertyIfMetadataPresent(artworkNode, "audio:artworkType", artwork.getType());
            this.setPropertyIfMetadataPresent(artworkNode, "jcr:data", artwork.getData());
        }
    }

    private void setPropertyIfMetadataPresent(Node node, String propertyName, Object value) throws RepositoryException {
        if (value == null) {
            return;
        }
        if (value instanceof String && !StringUtil.isBlank((String)((String)value))) {
            node.setProperty(propertyName, (String)value);
        } else if (value instanceof Double) {
            node.setProperty(propertyName, ((Double)value).doubleValue());
        } else if (value instanceof Number) {
            node.setProperty(propertyName, ((Number)value).longValue());
        } else if (value instanceof byte[]) {
            ByteArrayInputStream is = new ByteArrayInputStream((byte[])value);
            Binary binaryProperty = (Binary)node.getSession().getValueFactory().createBinary((InputStream)is);
            node.setProperty(propertyName, (javax.jcr.Binary)binaryProperty);
        } else {
            this.getLogger().warn("The value of the property {0} has unknown type and couldn't be saved.", new Object[]{propertyName});
        }
    }
}

