/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.classfile.metadata;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.annotation.Annotation;
import org.modeshape.sequencer.classfile.metadata.AnnotationMetadata;
import org.modeshape.sequencer.classfile.metadata.Visibility;

public class FieldMetadata
implements Comparable<FieldMetadata> {
    private final FieldInfo field;
    private final List<AnnotationMetadata> annotations;

    FieldMetadata(FieldInfo field) {
        this.field = field;
        this.annotations = this.annotationsFor(field);
    }

    private List<AnnotationMetadata> annotationsFor(FieldInfo field) {
        LinkedList<AnnotationMetadata> annotations = new LinkedList<AnnotationMetadata>();
        for (Object ob : field.getAttributes()) {
            AttributeInfo att = (AttributeInfo)ob;
            if (!(att instanceof AnnotationsAttribute)) continue;
            for (Annotation ann : ((AnnotationsAttribute)att).getAnnotations()) {
                annotations.add(new AnnotationMetadata(ann));
            }
        }
        return Collections.unmodifiableList(annotations);
    }

    public String getName() {
        return this.field.getName();
    }

    public boolean isStatic() {
        return 8 == (8 & this.field.getAccessFlags());
    }

    public boolean isFinal() {
        return 16 == (0x10 & this.field.getAccessFlags());
    }

    public boolean isTransient() {
        return 128 == (0x80 & this.field.getAccessFlags());
    }

    public boolean isVolatile() {
        return 64 == (0x40 & this.field.getAccessFlags());
    }

    public Visibility getVisibility() {
        return Visibility.fromAccessFlags(this.field.getAccessFlags());
    }

    public String getTypeName() {
        return Descriptor.toClassName((String)this.field.getDescriptor());
    }

    public List<AnnotationMetadata> getAnnotations() {
        return this.annotations;
    }

    @Override
    public int compareTo(FieldMetadata o) {
        if (this.isStatic() && !o.isStatic()) {
            return 1;
        }
        if (!this.isStatic() && o.isStatic()) {
            return -1;
        }
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (!this.annotations.isEmpty()) {
            for (AnnotationMetadata annotation : this.annotations) {
                buff.append(annotation).append("\n\t");
            }
        }
        buff.append((Object)this.getVisibility());
        if (this.getVisibility() != Visibility.PACKAGE) {
            buff.append(' ');
        }
        if (this.isFinal()) {
            buff.append("final ");
        }
        if (this.isStatic()) {
            buff.append("static ");
        }
        if (this.isTransient()) {
            buff.append("transient ");
        }
        buff.append(Descriptor.toClassName((String)this.getTypeName())).append(' ');
        buff.append(this.getName()).append(';');
        return buff.toString();
    }
}

