/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.cnd;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.sequencer.MockSequencerContext;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.cnd.CndSequencer;

public class CndSequencerTest {
    private CndSequencer sequencer;
    private InputStream content;
    private MockSequencerOutput output;
    private URL cndEmpty;
    private URL cndImages;
    private URL cndMp3;
    private URL cndBuiltIns;
    private URL standardDdl;
    private StreamSequencerContext context;

    @Before
    public void beforeEach() {
        this.sequencer = new CndSequencer();
        this.context = new MockSequencerContext("/a/mySequencer.cnd");
        this.context.getNamespaceRegistry().register("jcr", "http://www.jcp.org/jcr/1.0");
        this.context.getNamespaceRegistry().register("nt", "http://www.jcp.org/jcr/nt/1.0");
        this.context.getNamespaceRegistry().register("mix", "http://www.jcp.org/jcr/mix/1.0");
        this.output = new MockSequencerOutput(this.context);
        this.cndEmpty = this.getClass().getClassLoader().getResource("empty.cnd");
        this.cndImages = this.getClass().getClassLoader().getResource("images.cnd");
        this.cndMp3 = this.getClass().getClassLoader().getResource("mp3.cnd");
        this.cndBuiltIns = this.getClass().getClassLoader().getResource("builtin_nodetypes.cnd");
        this.standardDdl = this.getClass().getClassLoader().getResource("StandardDdl.cnd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.content != null) {
            try {
                this.content.close();
            }
            finally {
                this.content = null;
            }
        }
    }

    @Test
    public void shouldGenerateNodeTypesForCndFileWithJSR170BuiltIns() throws IOException {
        URL url = this.cndBuiltIns;
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
    }

    @Test
    public void shouldGenerateNodeTypesForEmptyCndFile() throws IOException {
        URL url = this.cndEmpty;
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
    }

    @Test
    public void shouldGenerateNodeTypesForCndFileWithImageNodeTypes() throws IOException {
        URL url = this.cndImages;
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
    }

    @Test
    public void shouldGenerateNodeTypesForCndFileWithMp3NodeTypes() throws IOException {
        URL url = this.cndMp3;
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
    }

    @Test
    public void shouldGenerateNodeTypesForCndFileWithDdlTypes() throws IOException {
        URL url = this.standardDdl;
        Assert.assertThat((Object)url, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.content = url.openStream();
        Assert.assertThat((Object)this.content, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.content, (SequencerOutput)this.output, this.context);
    }
}

