/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.sequencer.ddl.DdlConstants;

public class DdlParserProblem
extends ParsingException
implements DdlConstants.Problems {
    private static final long serialVersionUID = 2010539270968770893L;
    private int level = 0;
    private String unusedSource;

    public DdlParserProblem(Position position) {
        super(position);
    }

    public DdlParserProblem(int level, Position position, String message, Throwable cause) {
        super(position, message, cause);
        this.level = level;
    }

    public DdlParserProblem(int level, Position position, String message) {
        super(position, message);
        this.level = level;
    }

    public String getUnusedSource() {
        return this.unusedSource;
    }

    public void setUnusedSource(String unusedSource) {
        if (unusedSource == null) {
            unusedSource = "";
        }
        this.unusedSource = unusedSource;
    }

    public void appendSource(boolean addSpaceBefore, String value) {
        if (addSpaceBefore) {
            this.unusedSource = this.unusedSource + " ";
        }
        this.unusedSource = this.unusedSource + value;
    }

    public void appendSource(boolean addSpaceBefore, String value, String ... additionalStrs) {
        if (addSpaceBefore) {
            this.unusedSource = this.unusedSource + " ";
        }
        this.unusedSource = this.unusedSource + value;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String toString() {
        if (this.level == 1) {
            return "WARNING: " + super.toString();
        }
        if (this.level == 2) {
            return "ERROR: " + super.toString();
        }
        return super.toString();
    }
}

