/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.sequencer.ddl.DdlConstants;
import org.modeshape.sequencer.ddl.DdlParser;
import org.modeshape.sequencer.ddl.DdlParserProblem;
import org.modeshape.sequencer.ddl.DdlParserScorer;
import org.modeshape.sequencer.ddl.DdlSequencerI18n;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.StandardDdlLexicon;
import org.modeshape.sequencer.ddl.datatype.DataType;
import org.modeshape.sequencer.ddl.datatype.DataTypeParser;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.modeshape.sequencer.ddl.node.AstNodeFactory;

@NotThreadSafe
public class StandardDdlParser
implements DdlParser,
DdlConstants,
DdlConstants.StatementStartPhrases {
    private final String parserId = "SQL92";
    private boolean testMode = false;
    private final List<DdlParserProblem> problems;
    private final AstNodeFactory nodeFactory;
    private AstNode rootNode;
    private List<String> allDataTypeStartWords = null;
    private DataTypeParser datatypeParser = null;
    private String terminator = ";";
    private boolean useTerminator = false;
    private Position currentMarkedPosition;

    public StandardDdlParser() {
        this.setDoUseTerminator(true);
        this.setDatatypeParser(new DataTypeParser());
        this.nodeFactory = new AstNodeFactory();
        this.problems = new ArrayList<DdlParserProblem>();
    }

    public DataTypeParser getDatatypeParser() {
        return this.datatypeParser;
    }

    public void setDatatypeParser(DataTypeParser datatypeParser) {
        this.datatypeParser = datatypeParser;
    }

    public AstNodeFactory nodeFactory() {
        return this.nodeFactory;
    }

    public AstNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(AstNode rootNode) {
        this.rootNode = rootNode;
    }

    @Override
    public Object score(String ddl, String fileName, DdlParserScorer scorer) throws ParsingException {
        CheckArg.isNotNull((Object)ddl, (String)"ddl");
        CheckArg.isNotNull((Object)scorer, (String)"scorer");
        if (fileName != null) {
            scorer.scoreText(fileName, 2, this.getIdentifyingKeywords());
        }
        this.problems.clear();
        boolean includeComments = true;
        DdlTokenStream tokens = new DdlTokenStream(ddl, DdlTokenStream.ddlTokenizer(includeComments), false);
        this.initializeTokenStream(tokens);
        tokens.start();
        this.testPrint("\n== >> StandardDdlParser.parse() PARSING STARTED: ");
        while (tokens.matches(32)) {
            String comment = tokens.consume();
            scorer.scoreText(comment, 2, this.getIdentifyingKeywords());
        }
        this.computeScore(tokens, scorer);
        return tokens;
    }

    protected void computeScore(DdlTokenStream tokens, DdlParserScorer scorer) {
        while (tokens.hasNext()) {
            if (tokens.isNextKeyWord()) {
                scorer.scoreStatements(1);
            }
            tokens.consume();
        }
    }

    public String[] getIdentifyingKeywords() {
        return new String[]{this.getId()};
    }

    @Override
    public void parse(String ddl, AstNode rootNode, Object scoreReturnObject) throws ParsingException {
        CheckArg.isNotNull((Object)ddl, (String)"ddl");
        CheckArg.isNotNull((Object)rootNode, (String)"rootNode");
        this.problems.clear();
        this.setRootNode(rootNode);
        DdlTokenStream tokens = null;
        if (scoreReturnObject instanceof DdlTokenStream) {
            tokens = (DdlTokenStream)((Object)scoreReturnObject);
            tokens.rewind();
        } else {
            boolean includeComments = false;
            tokens = new DdlTokenStream(ddl, DdlTokenStream.ddlTokenizer(includeComments), false);
            this.initializeTokenStream(tokens);
            tokens.start();
        }
        this.testPrint("\n== >> StandardDdlParser.parse() PARSING STARTED: ");
        while (this.moveToNextStatementStart(tokens)) {
            AstNode stmtNode = this.parseNextStatement(tokens, rootNode);
            if (stmtNode != null) continue;
            this.markStartOfStatement(tokens);
            String stmtName = tokens.consume();
            stmtNode = this.parseIgnorableStatement(tokens, stmtName, rootNode);
            this.markEndOfStatement(tokens, stmtNode);
        }
        this.rewrite(tokens, rootNode);
        for (DdlParserProblem problem : this.problems) {
            this.attachNewProblem(problem, rootNode);
        }
        if (this.testMode) {
            int count = 0;
            for (AstNode child : rootNode.getChildren()) {
                this.testPrint("== >> Found Statement(" + ++count + "):\n" + child);
            }
        }
    }

    protected void initializeTokenStream(DdlTokenStream tokens) {
        tokens.registerKeyWords(SQL_92_RESERVED_WORDS);
        tokens.registerStatementStartPhrase(SQL_92_ALL_PHRASES);
    }

    protected AstNode parseNextStatement(DdlTokenStream tokens, AstNode node) {
        assert (tokens != null);
        assert (node != null);
        AstNode stmtNode = null;
        if (tokens.matches("CREATE")) {
            stmtNode = this.parseCreateStatement(tokens, node);
        } else if (tokens.matches("ALTER")) {
            stmtNode = this.parseAlterStatement(tokens, node);
        } else if (tokens.matches("DROP")) {
            stmtNode = this.parseDropStatement(tokens, node);
        } else if (tokens.matches("INSERT")) {
            stmtNode = this.parseInsertStatement(tokens, node);
        } else if (tokens.matches("SET")) {
            stmtNode = this.parseSetStatement(tokens, node);
        } else if (tokens.matches("GRANT")) {
            stmtNode = this.parseGrantStatement(tokens, node);
        } else if (tokens.matches("REVOKE")) {
            stmtNode = this.parseRevokeStatement(tokens, node);
        }
        if (stmtNode == null) {
            stmtNode = this.parseCustomStatement(tokens, node);
        }
        return stmtNode;
    }

    private boolean moveToNextStatementStart(DdlTokenStream tokens) throws ParsingException {
        assert (tokens != null);
        StringBuffer sb = new StringBuffer();
        DdlParserProblem problem = null;
        if (tokens.hasNext()) {
            while (tokens.hasNext()) {
                if (tokens.canConsume(32)) continue;
                if (!tokens.matches(128)) {
                    AstNode unknownNode;
                    if (problem == null) {
                        this.markStartOfStatement(tokens);
                        String msg = DdlSequencerI18n.unusedTokensDiscovered.text(new Object[]{tokens.nextPosition().getLine(), tokens.nextPosition().getColumn()});
                        problem = new DdlParserProblem(1, tokens.nextPosition(), msg);
                    }
                    String nextTokenValue = null;
                    if (tokens.matches(this.getTerminator()) && sb.length() > 0) {
                        nextTokenValue = this.getTerminator();
                        unknownNode = this.unknownTerminatedNode(this.getRootNode());
                        this.markEndOfStatement(tokens, unknownNode);
                        problem = null;
                    } else {
                        nextTokenValue = tokens.consume();
                        unknownNode = this.handleUnknownToken(tokens, nextTokenValue);
                        if (unknownNode != null) {
                            this.markEndOfStatement(tokens, unknownNode);
                            problem = null;
                        }
                    }
                    sb.append(" ").append(nextTokenValue);
                    continue;
                }
                if (problem != null && sb.length() > 0) {
                    problem.setUnusedSource(sb.toString());
                    this.addProblem(problem);
                }
                return true;
            }
            if (problem != null && sb.length() > 0) {
                problem.setUnusedSource(sb.toString());
                this.addProblem(problem);
            }
        }
        return false;
    }

    public final void addProblem(DdlParserProblem problem, AstNode node) {
        this.addProblem(problem);
        this.attachNewProblem(problem, node);
    }

    public final void addProblem(DdlParserProblem problem) {
        this.problems.add(problem);
    }

    public final List<DdlParserProblem> getProblems() {
        return this.problems;
    }

    public final void attachNewProblem(DdlParserProblem problem, AstNode parentNode) {
        assert (problem != null);
        assert (parentNode != null);
        AstNode problemNode = this.nodeFactory().node("DDL PROBLEM", parentNode, StandardDdlLexicon.TYPE_PROBLEM);
        problemNode.setProperty(StandardDdlLexicon.PROBLEM_LEVEL, (Object)problem.getLevel());
        problemNode.setProperty(StandardDdlLexicon.MESSAGE, (Object)(problem.toString() + "[" + problem.getUnusedSource() + "]"));
        this.testPrint(problem.toString());
    }

    protected void rewrite(DdlTokenStream tokens, AstNode rootNode) {
        assert (tokens != null);
        assert (rootNode != null);
        this.removeMissingTerminatorNodes(rootNode);
    }

    protected void removeMissingTerminatorNodes(AstNode parentNode) {
        assert (parentNode != null);
        ArrayList<AstNode> copyOfNodes = new ArrayList<AstNode>(parentNode.getChildren());
        for (AstNode child : copyOfNodes) {
            if (this.nodeFactory().hasMixinType(child, StandardDdlLexicon.TYPE_MISSING_TERMINATOR)) {
                parentNode.removeChild(child);
                continue;
            }
            this.removeMissingTerminatorNodes(child);
        }
    }

    public void mergeNodes(DdlTokenStream tokens, AstNode firstNode, AstNode secondNode) {
        assert (tokens != null);
        assert (firstNode != null);
        assert (secondNode != null);
        int firstStartIndex = (Integer)firstNode.getProperty(StandardDdlLexicon.DDL_START_CHAR_INDEX).getFirstValue();
        int secondStartIndex = (Integer)secondNode.getProperty(StandardDdlLexicon.DDL_START_CHAR_INDEX).getFirstValue();
        int deltaLength = ((String)secondNode.getProperty(StandardDdlLexicon.DDL_EXPRESSION).getFirstValue()).length();
        Position startPosition = new Position(firstStartIndex, 1, 0);
        Position endPosition = new Position(secondStartIndex + deltaLength, 1, 0);
        String source = tokens.getContentBetween(startPosition, endPosition);
        firstNode.setProperty(StandardDdlLexicon.DDL_EXPRESSION, (Object)source);
    }

    public AstNode handleUnknownToken(DdlTokenStream tokens, String tokenValue) throws ParsingException {
        assert (tokens != null);
        assert (tokenValue != null);
        return null;
    }

    protected AstNode parseCreateStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        AstNode stmtNode = null;
        if (tokens.matches(STMT_CREATE_SCHEMA)) {
            stmtNode = this.parseCreateSchemaStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_TABLE) || tokens.matches(STMT_CREATE_GLOBAL_TEMPORARY_TABLE) || tokens.matches(STMT_CREATE_LOCAL_TEMPORARY_TABLE)) {
            stmtNode = this.parseCreateTableStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_VIEW) || tokens.matches(STMT_CREATE_OR_REPLACE_VIEW)) {
            stmtNode = this.parseCreateViewStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_ASSERTION)) {
            stmtNode = this.parseCreateAssertionStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_CHARACTER_SET)) {
            stmtNode = this.parseCreateCharacterSetStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_COLLATION)) {
            stmtNode = this.parseCreateCollationStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_TRANSLATION)) {
            stmtNode = this.parseCreateTranslationStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_DOMAIN)) {
            stmtNode = this.parseCreateDomainStatement(tokens, parentNode);
        } else {
            this.markStartOfStatement(tokens);
            stmtNode = this.parseIgnorableStatement(tokens, "CREATE UNKNOWN", parentNode);
            Position position = this.getCurrentMarkedPosition();
            String msg = DdlSequencerI18n.unknownCreateStatement.text(new Object[]{position.getLine(), position.getColumn()});
            DdlParserProblem problem = new DdlParserProblem(1, position, msg);
            stmtNode.setProperty(StandardDdlLexicon.TYPE_PROBLEM, (Object)problem.toString());
            this.markEndOfStatement(tokens, stmtNode);
        }
        return stmtNode;
    }

    protected AstNode parseAlterStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches("ALTER", new String[]{"TABLE"})) {
            return this.parseAlterTableStatement(tokens, parentNode);
        }
        if (tokens.matches("ALTER", new String[]{"DOMAIN"})) {
            this.markStartOfStatement(tokens);
            tokens.consume("ALTER", new String[]{"DOMAIN"});
            String domainName = this.parseName(tokens);
            AstNode alterNode = this.nodeFactory().node(domainName, parentNode, StandardDdlLexicon.TYPE_ALTER_DOMAIN_STATEMENT);
            this.parseUntilTerminator(tokens);
            this.markEndOfStatement(tokens, alterNode);
            return alterNode;
        }
        return null;
    }

    protected AstNode parseAlterTableStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("ALTER", new String[]{"TABLE"});
        String tableName = this.parseName(tokens);
        AstNode alterTableNode = this.nodeFactory().node(tableName, parentNode, StandardDdlLexicon.TYPE_ALTER_TABLE_STATEMENT);
        if (tokens.canConsume("ADD")) {
            if (this.isTableConstraint(tokens)) {
                this.parseTableConstraint(tokens, alterTableNode, true);
            } else {
                this.parseSingleTerminatedColumnDefinition(tokens, alterTableNode, true);
            }
        } else if (tokens.canConsume("DROP")) {
            if (tokens.canConsume("CONSTRAINT")) {
                String constraintName = this.parseName(tokens);
                AstNode constraintNode = this.nodeFactory().node(constraintName, alterTableNode, StandardDdlLexicon.TYPE_DROP_TABLE_CONSTRAINT_DEFINITION);
                if (tokens.canConsume("CASCADE")) {
                    constraintNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"CASCADE");
                } else if (tokens.canConsume("RESTRICT")) {
                    constraintNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"RESTRICT");
                }
            } else {
                tokens.canConsume("COLUMN");
                String columnName = this.parseName(tokens);
                AstNode columnNode = this.nodeFactory().node(columnName, alterTableNode, StandardDdlLexicon.TYPE_DROP_COLUMN_DEFINITION);
                if (tokens.canConsume("CASCADE")) {
                    columnNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"CASCADE");
                } else if (tokens.canConsume("RESTRICT")) {
                    columnNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"RESTRICT");
                }
            }
        } else if (tokens.canConsume("ALTER")) {
            tokens.canConsume("COLUMN");
            String alterColumnName = this.parseName(tokens);
            AstNode columnNode = this.nodeFactory().node(alterColumnName, alterTableNode, StandardDdlLexicon.TYPE_ALTER_COLUMN_DEFINITION);
            if (tokens.canConsume("SET")) {
                this.parseDefaultClause(tokens, columnNode);
            } else if (tokens.canConsume("DROP", new String[]{"DEFAULT"})) {
                columnNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"DROP DEFAULT");
            }
        } else {
            this.parseUntilTerminator(tokens);
        }
        this.markEndOfStatement(tokens, alterTableNode);
        return alterTableNode;
    }

    protected AstNode parseDropStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_DROP_TABLE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TABLE, parentNode, StandardDdlLexicon.TYPE_DROP_TABLE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_VIEW)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_VIEW, parentNode, StandardDdlLexicon.TYPE_DROP_VIEW_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_SCHEMA)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_SCHEMA, parentNode, StandardDdlLexicon.TYPE_DROP_SCHEMA_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_DOMAIN)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_DOMAIN, parentNode, StandardDdlLexicon.TYPE_DROP_DOMAIN_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_TRANSLATION)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TRANSLATION, parentNode, StandardDdlLexicon.TYPE_DROP_TRANSLATION_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_CHARACTER_SET)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_CHARACTER_SET, parentNode, StandardDdlLexicon.TYPE_DROP_CHARACTER_SET_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_ASSERTION)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_ASSERTION, parentNode, StandardDdlLexicon.TYPE_DROP_ASSERTION_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_COLLATION)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_COLLATION, parentNode, StandardDdlLexicon.TYPE_DROP_COLLATION_STATEMENT);
        }
        return null;
    }

    private AstNode parseSimpleDropStatement(DdlTokenStream tokens, String[] startPhrase, AstNode parentNode, Name stmtType) throws ParsingException {
        assert (tokens != null);
        assert (startPhrase != null && startPhrase.length > 0);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        String behavior = null;
        tokens.consume(startPhrase);
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(this.parseName(tokens));
        while (tokens.matches(",")) {
            tokens.consume(",");
            nameList.add(this.parseName(tokens));
        }
        if (tokens.canConsume("CASCADE")) {
            behavior = "CASCADE";
        } else if (tokens.canConsume("RESTRICT")) {
            behavior = "RESTRICT";
        }
        AstNode dropNode = this.nodeFactory().node((String)nameList.get(0), parentNode, stmtType);
        if (behavior != null) {
            dropNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)behavior);
        }
        this.markEndOfStatement(tokens, dropNode);
        return dropNode;
    }

    protected AstNode parseInsertStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_INSERT_INTO)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_INSERT_INTO);
            String prefix = this.getStatementTypeName(STMT_INSERT_INTO);
            AstNode node = this.nodeFactory().node(prefix, parentNode, StandardDdlLexicon.TYPE_INSERT_STATEMENT);
            this.parseUntilTerminator(tokens);
            this.markEndOfStatement(tokens, node);
            return node;
        }
        return null;
    }

    protected AstNode parseSetStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches("SET")) {
            this.markStartOfStatement(tokens);
            tokens.consume("SET");
            AstNode node = this.nodeFactory().node("SET", parentNode, StandardDdlLexicon.TYPE_SET_STATEMENT);
            this.parseUntilTerminator(tokens);
            this.markEndOfStatement(tokens, node);
            return node;
        }
        return null;
    }

    protected AstNode parseGrantStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        String name;
        assert (tokens != null);
        assert (parentNode != null);
        assert (tokens.matches("GRANT"));
        this.markStartOfStatement(tokens);
        AstNode grantNode = null;
        boolean allPrivileges = false;
        ArrayList<AstNode> privileges = new ArrayList<AstNode>();
        tokens.consume("GRANT");
        if (tokens.canConsume("ALL", new String[]{"PRIVILEGES"})) {
            allPrivileges = true;
        } else {
            this.parseGrantPrivileges(tokens, privileges);
        }
        tokens.consume("ON");
        if (tokens.canConsume("DOMAIN")) {
            name = this.parseName(tokens);
            grantNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_GRANT_ON_DOMAIN_STATEMENT);
        } else if (tokens.canConsume("COLLATION")) {
            name = this.parseName(tokens);
            grantNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_GRANT_ON_COLLATION_STATEMENT);
        } else if (tokens.canConsume("CHARACTER", new String[]{"SET"})) {
            name = this.parseName(tokens);
            grantNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_GRANT_ON_CHARACTER_SET_STATEMENT);
        } else if (tokens.canConsume("TRANSLATION")) {
            name = this.parseName(tokens);
            grantNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_GRANT_ON_TRANSLATION_STATEMENT);
        } else {
            tokens.canConsume("TABLE");
            name = this.parseName(tokens);
            grantNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_GRANT_ON_TABLE_STATEMENT);
        }
        for (AstNode node : privileges) {
            node.setParent(grantNode);
        }
        if (allPrivileges) {
            grantNode.setProperty(StandardDdlLexicon.ALL_PRIVILEGES, (Object)allPrivileges);
        }
        tokens.consume("TO");
        do {
            String grantee = this.parseName(tokens);
            this.nodeFactory().node(grantee, grantNode, StandardDdlLexicon.GRANTEE);
        } while (tokens.canConsume(","));
        if (tokens.canConsume("WITH", new String[]{"GRANT", "OPTION"})) {
            grantNode.setProperty(StandardDdlLexicon.WITH_GRANT_OPTION, (Object)"WITH GRANT OPTION");
        }
        this.markEndOfStatement(tokens, grantNode);
        return grantNode;
    }

    protected void parseGrantPrivileges(DdlTokenStream tokens, List<AstNode> privileges) throws ParsingException {
        do {
            AstNode node = null;
            if (tokens.canConsume("DELETE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"DELETE");
            } else if (tokens.canConsume("INSERT")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"INSERT");
                this.parseColumnNameList(tokens, node, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
            } else if (tokens.canConsume("REFERENCES")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"REFERENCES");
                this.parseColumnNameList(tokens, node, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
            } else if (tokens.canConsume("SELECT")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"SELECT");
            } else if (tokens.canConsume("USAGE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"USAGE");
            } else if (tokens.canConsume("UPDATE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(StandardDdlLexicon.TYPE, (Object)"UPDATE");
                this.parseColumnNameList(tokens, node, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
            }
            if (node == null) break;
            this.nodeFactory().setType(node, StandardDdlLexicon.GRANT_PRIVILEGE);
            privileges.add(node);
        } while (tokens.canConsume(","));
    }

    protected AstNode parseRevokeStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        String name;
        assert (tokens != null);
        assert (parentNode != null);
        assert (tokens.matches("REVOKE"));
        this.markStartOfStatement(tokens);
        AstNode revokeNode = null;
        boolean allPrivileges = false;
        boolean withGrantOption = false;
        ArrayList<AstNode> privileges = new ArrayList<AstNode>();
        tokens.consume("REVOKE");
        withGrantOption = tokens.canConsume("WITH", new String[]{"GRANT", "OPTION"});
        if (tokens.canConsume("ALL", new String[]{"PRIVILEGES"})) {
            allPrivileges = true;
        } else {
            this.parseGrantPrivileges(tokens, privileges);
        }
        tokens.consume("ON");
        if (tokens.canConsume("DOMAIN")) {
            name = this.parseName(tokens);
            revokeNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_REVOKE_ON_DOMAIN_STATEMENT);
        } else if (tokens.canConsume("COLLATION")) {
            name = this.parseName(tokens);
            revokeNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_REVOKE_ON_COLLATION_STATEMENT);
        } else if (tokens.canConsume("CHARACTER", new String[]{"SET"})) {
            name = this.parseName(tokens);
            revokeNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_REVOKE_ON_CHARACTER_SET_STATEMENT);
        } else if (tokens.canConsume("TRANSLATION")) {
            name = this.parseName(tokens);
            revokeNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_REVOKE_ON_TRANSLATION_STATEMENT);
        } else {
            tokens.canConsume("TABLE");
            name = this.parseName(tokens);
            revokeNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_REVOKE_ON_TABLE_STATEMENT);
        }
        for (AstNode node : privileges) {
            node.setParent(revokeNode);
        }
        if (allPrivileges) {
            revokeNode.setProperty(StandardDdlLexicon.ALL_PRIVILEGES, (Object)allPrivileges);
        }
        tokens.consume("FROM");
        do {
            String grantee = this.parseName(tokens);
            this.nodeFactory().node(grantee, revokeNode, StandardDdlLexicon.GRANTEE);
        } while (tokens.canConsume(","));
        String behavior = null;
        if (tokens.canConsume("CASCADE")) {
            behavior = "CASCADE";
        } else if (tokens.canConsume("RESTRICT")) {
            behavior = "RESTRICT";
        }
        if (behavior != null) {
            revokeNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)behavior);
        }
        if (withGrantOption) {
            revokeNode.setProperty(StandardDdlLexicon.WITH_GRANT_OPTION, (Object)"WITH GRANT OPTION");
        }
        this.markEndOfStatement(tokens, revokeNode);
        return revokeNode;
    }

    protected AstNode parseCreateDomainStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_DOMAIN);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_CREATE_DOMAIN_STATEMENT);
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseCreateCollationStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_COLLATION);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_CREATE_COLLATION_STATEMENT);
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseCreateTranslationStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_TRANSLATION);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_CREATE_TRANSLATION_STATEMENT);
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseCreateCharacterSetStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_CHARACTER_SET);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_CREATE_CHARACTER_SET_STATEMENT);
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseCustomStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        return null;
    }

    protected AstNode parseCreateTableStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("CREATE");
        String temporaryValue = null;
        if (tokens.canConsume("LOCAL")) {
            tokens.consume("TEMPORARY");
            temporaryValue = "LOCAL";
        } else if (tokens.canConsume("GLOBAL")) {
            tokens.consume("TEMPORARY");
            temporaryValue = "GLOBAL";
        }
        tokens.consume("TABLE");
        String tableName = this.parseName(tokens);
        AstNode tableNode = this.nodeFactory().node(tableName, parentNode, StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
        if (temporaryValue != null) {
            tableNode.setProperty(StandardDdlLexicon.TEMPORARY, (Object)temporaryValue);
        }
        this.parseColumnsAndConstraints(tokens, tableNode);
        this.parseCreateTableOptions(tokens, tableNode);
        this.markEndOfStatement(tokens, tableNode);
        return tableNode;
    }

    protected void parseCreateTableOptions(DdlTokenStream tokens, AstNode tableNode) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        while (this.areNextTokensCreateTableOptions(tokens)) {
            this.parseNextCreateTableOption(tokens, tableNode);
        }
    }

    protected void parseNextCreateTableOption(DdlTokenStream tokens, AstNode tableNode) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        if (tokens.canConsume("ON", new String[]{"COMMIT"})) {
            String option = "";
            if (tokens.canConsume("PRESERVE", new String[]{"ROWS"})) {
                option = option + "ON COMMIT PRESERVE ROWS";
            } else if (tokens.canConsume("DELETE", new String[]{"ROWS"})) {
                option = option + "ON COMMIT DELETE ROWS";
            } else if (tokens.canConsume("DROP")) {
                option = option + "ON COMMIT DROP";
            }
            if (option.length() > 0) {
                AstNode tableOption = this.nodeFactory().node("option", tableNode, StandardDdlLexicon.TYPE_STATEMENT_OPTION);
                tableOption.setProperty(StandardDdlLexicon.VALUE, (Object)option);
            }
        }
    }

    protected boolean areNextTokensCreateTableOptions(DdlTokenStream tokens) throws ParsingException {
        assert (tokens != null);
        boolean result = false;
        if (tokens.matches("ON", new String[]{"COMMIT"})) {
            result = true;
        }
        return result;
    }

    protected void parseColumnsAndConstraints(DdlTokenStream tokens, AstNode tableNode) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        if (!tokens.matches("(")) {
            return;
        }
        String tableElementString = this.getTableElementsString(tokens, false);
        DdlTokenStream localTokens = new DdlTokenStream(tableElementString, DdlTokenStream.ddlTokenizer(false), false);
        localTokens.start();
        StringBuffer unusedTokensSB = new StringBuffer();
        do {
            if (this.isTableConstraint(localTokens)) {
                this.parseTableConstraint(localTokens, tableNode, false);
                continue;
            }
            if (this.isColumnDefinitionStart(localTokens)) {
                this.parseColumnDefinition(localTokens, tableNode, false);
                continue;
            }
            unusedTokensSB.append(" ").append(localTokens.consume());
        } while (localTokens.canConsume(","));
        if (unusedTokensSB.length() > 0) {
            String msg = DdlSequencerI18n.unusedTokensParsingColumnsAndConstraints.text(new Object[]{tableNode.getProperty(StandardDdlLexicon.NAME)});
            DdlParserProblem problem = new DdlParserProblem(1, Position.EMPTY_CONTENT_POSITION, msg);
            problem.setUnusedSource(unusedTokensSB.toString());
            this.addProblem(problem, tableNode);
        }
    }

    protected void parseColumnDefinition(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        tokens.canConsume("COLUMN");
        String columnName = this.parseName(tokens);
        DataType datatype = this.getDatatypeParser().parse(tokens);
        AstNode columnNode = this.nodeFactory().node(columnName, tableNode, StandardDdlLexicon.TYPE_COLUMN_DEFINITION);
        this.getDatatypeParser().setPropertiesOnNode(columnNode, datatype);
        StringBuffer unusedTokensSB = new StringBuffer();
        while (tokens.hasNext() && !tokens.matches(",")) {
            boolean parsedDefaultClause = this.parseDefaultClause(tokens, columnNode);
            if (!parsedDefaultClause) {
                boolean parsedCollate = this.parseCollateClause(tokens, columnNode);
                boolean parsedConstraint = this.parseColumnConstraint(tokens, columnNode, isAlterTable);
                if (!parsedCollate && !parsedConstraint) {
                    unusedTokensSB.append(" ").append(tokens.consume());
                }
            }
            tokens.canConsume(32);
        }
        if (unusedTokensSB.length() > 0) {
            String msg = DdlSequencerI18n.unusedTokensParsingColumnDefinition.text(new Object[]{tableNode.getName()});
            DdlParserProblem problem = new DdlParserProblem(1, Position.EMPTY_CONTENT_POSITION, msg);
            problem.setUnusedSource(unusedTokensSB.toString());
            this.addProblem(problem, tableNode);
        }
    }

    protected void parseSingleTerminatedColumnDefinition(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        tokens.canConsume("COLUMN");
        String columnName = this.parseName(tokens);
        DataType datatype = this.getDatatypeParser().parse(tokens);
        AstNode columnNode = this.nodeFactory().node(columnName, tableNode, StandardDdlLexicon.TYPE_COLUMN_DEFINITION);
        this.getDatatypeParser().setPropertiesOnNode(columnNode, datatype);
        while (tokens.hasNext() && !tokens.matches(this.getTerminator()) && !tokens.matches(128)) {
            boolean parsedDefaultClause;
            boolean foundSomething = parsedDefaultClause = this.parseDefaultClause(tokens, columnNode);
            if (!parsedDefaultClause) {
                foundSomething |= this.parseCollateClause(tokens, columnNode);
                foundSomething |= this.parseColumnConstraint(tokens, columnNode, isAlterTable);
            }
            if (!tokens.canConsume(",") && (foundSomething |= this.consumeComment(tokens))) continue;
            break;
        }
    }

    protected String getTableElementsString(DdlTokenStream tokens, boolean useTerminator) throws ParsingException {
        assert (tokens != null);
        StringBuffer sb = new StringBuffer(100);
        if (useTerminator) {
            while (!this.isTerminator(tokens)) {
                sb.append(" ").append(tokens.consume());
            }
        } else {
            tokens.consume("(");
            int iParen = 0;
            while (tokens.hasNext()) {
                if (tokens.matches("(")) {
                    ++iParen;
                } else if (tokens.matches(")")) {
                    if (iParen == 0) {
                        tokens.consume(")");
                        break;
                    }
                    --iParen;
                }
                if (this.isComment(tokens)) {
                    tokens.consume();
                    continue;
                }
                sb.append(" ").append(tokens.consume());
            }
        }
        return sb.toString();
    }

    protected String consumeParenBoundedTokens(DdlTokenStream tokens, boolean includeParens) throws ParsingException {
        assert (tokens != null);
        if (tokens.canConsume("(")) {
            StringBuffer sb = new StringBuffer(100);
            if (includeParens) {
                sb.append("(");
            }
            int iParen = 0;
            while (tokens.hasNext()) {
                if (tokens.matches("(")) {
                    ++iParen;
                } else if (tokens.matches(")")) {
                    if (iParen == 0) {
                        tokens.consume(")");
                        if (!includeParens) break;
                        sb.append(" ").append(")");
                        break;
                    }
                    --iParen;
                }
                if (this.isComment(tokens)) {
                    tokens.consume();
                    continue;
                }
                sb.append(" ").append(tokens.consume());
            }
            return sb.toString();
        }
        return null;
    }

    protected boolean parseColumnConstraint(DdlTokenStream tokens, AstNode columnNode, boolean isAlterTable) throws ParsingException {
        assert (tokens != null);
        assert (columnNode != null);
        Name mixinType = isAlterTable ? StandardDdlLexicon.TYPE_ADD_TABLE_CONSTRAINT_DEFINITION : StandardDdlLexicon.TYPE_TABLE_CONSTRAINT;
        boolean result = false;
        String colName = columnNode.getName().getString();
        if (tokens.canConsume("NULL")) {
            columnNode.setProperty(StandardDdlLexicon.NULLABLE, (Object)"NULL");
            result = true;
        } else if (tokens.canConsume("NOT", new String[]{"NULL"})) {
            columnNode.setProperty(StandardDdlLexicon.NULLABLE, (Object)"NOT NULL");
            result = true;
        } else if (tokens.matches("CONSTRAINT")) {
            result = true;
            tokens.consume("CONSTRAINT");
            String constraintName = this.parseName(tokens);
            AstNode constraintNode = this.nodeFactory().node(constraintName, columnNode.getParent(), mixinType);
            if (tokens.matches("UNIQUE")) {
                tokens.consume("UNIQUE");
                constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"UNIQUE");
                boolean columnsAdded = this.parseColumnNameList(tokens, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
                if (!columnsAdded) {
                    this.nodeFactory().node(colName, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
                }
                this.parseConstraintAttributes(tokens, constraintNode);
            } else if (tokens.matches("PRIMARY", new String[]{"KEY"})) {
                tokens.consume("PRIMARY");
                tokens.consume("KEY");
                constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"PRIMARY KEY");
                boolean columnsAdded = this.parseColumnNameList(tokens, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
                if (!columnsAdded) {
                    this.nodeFactory().node(colName, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
                }
                this.parseConstraintAttributes(tokens, constraintNode);
            } else if (tokens.matches("REFERENCES")) {
                constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"FOREIGN KEY");
                this.nodeFactory().node(colName, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
                this.parseReferences(tokens, constraintNode);
                this.parseConstraintAttributes(tokens, constraintNode);
            }
        } else if (tokens.matches("UNIQUE")) {
            result = true;
            tokens.consume("UNIQUE");
            String uc_name = "UC_1";
            AstNode constraintNode = this.nodeFactory().node(uc_name, columnNode.getParent(), mixinType);
            constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"UNIQUE");
            this.nodeFactory().node(colName, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
        } else if (tokens.matches("PRIMARY", new String[]{"KEY"})) {
            result = true;
            tokens.consume("PRIMARY", new String[]{"KEY"});
            String pk_name = "PK_1";
            AstNode constraintNode = this.nodeFactory().node(pk_name, columnNode.getParent(), mixinType);
            constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"PRIMARY KEY");
            this.nodeFactory().node(colName, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
        } else if (tokens.matches("FOREIGN", new String[]{"KEY"})) {
            result = true;
            tokens.consume("FOREIGN", new String[]{"KEY"});
            String constraintName = this.parseName(tokens);
            AstNode constraintNode = this.nodeFactory().node(constraintName, columnNode.getParent(), mixinType);
            constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"FOREIGN KEY");
            this.nodeFactory().node(colName, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
            this.parseReferences(tokens, constraintNode);
            this.parseConstraintAttributes(tokens, constraintNode);
        } else if (tokens.matches("REFERENCES")) {
            result = true;
            String constraintName = "FK_1";
            AstNode constraintNode = this.nodeFactory().node(constraintName, columnNode.getParent(), mixinType);
            constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"FOREIGN KEY");
            this.nodeFactory().node(colName, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
            this.parseReferences(tokens, constraintNode);
            this.parseConstraintAttributes(tokens, constraintNode);
        } else if (tokens.matches("CHECK")) {
            result = true;
            tokens.consume("CHECK");
            String ck_name = "CHECK_1";
            AstNode constraintNode = this.nodeFactory().node(ck_name, columnNode.getParent(), mixinType);
            constraintNode.setProperty(StandardDdlLexicon.NAME, (Object)ck_name);
            constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"CHECK");
            String clause = this.consumeParenBoundedTokens(tokens, true);
            constraintNode.setProperty(StandardDdlLexicon.CHECK_SEARCH_CONDITION, (Object)clause);
        }
        return result;
    }

    protected void parseTableConstraint(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        Name mixinType = isAlterTable ? StandardDdlLexicon.TYPE_ADD_TABLE_CONSTRAINT_DEFINITION : StandardDdlLexicon.TYPE_TABLE_CONSTRAINT;
        this.consumeComment(tokens);
        if (tokens.matches("PRIMARY", new String[]{"KEY"}) || tokens.matches("FOREIGN", new String[]{"KEY"}) || tokens.matches("UNIQUE")) {
            if (tokens.matches("UNIQUE")) {
                String uc_name = "UC_1";
                tokens.consume();
                AstNode constraintNode = this.nodeFactory().node(uc_name, tableNode, mixinType);
                constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"UNIQUE");
                this.parseColumnNameList(tokens, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
                this.parseConstraintAttributes(tokens, constraintNode);
                this.consumeComment(tokens);
            } else if (tokens.matches("PRIMARY", new String[]{"KEY"})) {
                String pk_name = "PK_1";
                tokens.consume("PRIMARY", new String[]{"KEY"});
                AstNode constraintNode = this.nodeFactory().node(pk_name, tableNode, mixinType);
                constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"PRIMARY KEY");
                this.parseColumnNameList(tokens, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
                this.parseConstraintAttributes(tokens, constraintNode);
                this.consumeComment(tokens);
            } else if (tokens.matches("FOREIGN", new String[]{"KEY"})) {
                String fk_name = "FK_1";
                tokens.consume("FOREIGN", new String[]{"KEY"});
                if (!tokens.matches("(")) {
                    fk_name = tokens.consume();
                }
                AstNode constraintNode = this.nodeFactory().node(fk_name, tableNode, mixinType);
                constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"FOREIGN KEY");
                this.parseColumnNameList(tokens, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
                this.parseReferences(tokens, constraintNode);
                this.parseConstraintAttributes(tokens, constraintNode);
                this.consumeComment(tokens);
            }
        } else if (tokens.matches("CONSTRAINT", new String[]{"any value", "UNIQUE"})) {
            tokens.consume();
            String uc_name = this.parseName(tokens);
            tokens.consume("UNIQUE");
            AstNode constraintNode = this.nodeFactory().node(uc_name, tableNode, mixinType);
            constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"UNIQUE");
            this.parseColumnNameList(tokens, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
            this.parseConstraintAttributes(tokens, constraintNode);
            this.consumeComment(tokens);
        } else if (tokens.matches("CONSTRAINT", new String[]{"any value", "PRIMARY", "KEY"})) {
            tokens.consume("CONSTRAINT");
            String pk_name = this.parseName(tokens);
            tokens.consume("PRIMARY", new String[]{"KEY"});
            AstNode constraintNode = this.nodeFactory().node(pk_name, tableNode, mixinType);
            constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"PRIMARY KEY");
            this.parseColumnNameList(tokens, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
            this.parseConstraintAttributes(tokens, constraintNode);
            this.consumeComment(tokens);
        } else if (tokens.matches("CONSTRAINT", new String[]{"any value", "FOREIGN", "KEY"})) {
            tokens.consume("CONSTRAINT");
            String fk_name = this.parseName(tokens);
            tokens.consume("FOREIGN", new String[]{"KEY"});
            AstNode constraintNode = this.nodeFactory().node(fk_name, tableNode, mixinType);
            constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"FOREIGN KEY");
            this.parseColumnNameList(tokens, constraintNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
            this.parseReferences(tokens, constraintNode);
            this.parseConstraintAttributes(tokens, constraintNode);
            this.consumeComment(tokens);
        } else if (tokens.matches("CONSTRAINT", new String[]{"any value", "CHECK"})) {
            tokens.consume("CONSTRAINT");
            String ck_name = this.parseName(tokens);
            tokens.consume("CHECK");
            AstNode constraintNode = this.nodeFactory().node(ck_name, tableNode, mixinType);
            constraintNode.setProperty(StandardDdlLexicon.CONSTRAINT_TYPE, (Object)"CHECK");
            String clause = this.consumeParenBoundedTokens(tokens, true);
            constraintNode.setProperty(StandardDdlLexicon.CHECK_SEARCH_CONDITION, (Object)clause);
        }
    }

    protected void parseConstraintAttributes(DdlTokenStream tokens, AstNode constraintNode) throws ParsingException {
        AstNode attrNode;
        assert (tokens != null);
        assert (constraintNode != null);
        if (tokens.canConsume("INITIALLY", new String[]{"DEFERRED"})) {
            attrNode = this.nodeFactory().node("CONSTRAINT_ATTRIBUTE", constraintNode, StandardDdlLexicon.CONSTRAINT_ATTRIBUTE_TYPE);
            attrNode.setProperty(StandardDdlLexicon.PROPERTY_VALUE, (Object)"INITIALLY DEFERRED");
        }
        if (tokens.canConsume("INITIALLY", new String[]{"IMMEDIATE"})) {
            attrNode = this.nodeFactory().node("CONSTRAINT_ATTRIBUTE", constraintNode, StandardDdlLexicon.CONSTRAINT_ATTRIBUTE_TYPE);
            attrNode.setProperty(StandardDdlLexicon.PROPERTY_VALUE, (Object)"INITIALLY IMMEDIATE");
        }
        if (tokens.canConsume("NOT", new String[]{"DEFERRABLE"})) {
            attrNode = this.nodeFactory().node("CONSTRAINT_ATTRIBUTE", constraintNode, StandardDdlLexicon.CONSTRAINT_ATTRIBUTE_TYPE);
            attrNode.setProperty(StandardDdlLexicon.PROPERTY_VALUE, (Object)"NOT DEFERRABLE");
        }
        if (tokens.canConsume("DEFERRABLE")) {
            attrNode = this.nodeFactory().node("CONSTRAINT_ATTRIBUTE", constraintNode, StandardDdlLexicon.CONSTRAINT_ATTRIBUTE_TYPE);
            attrNode.setProperty(StandardDdlLexicon.PROPERTY_VALUE, (Object)"DEFERRABLE");
        }
        if (tokens.canConsume("INITIALLY", new String[]{"DEFERRED"})) {
            attrNode = this.nodeFactory().node("CONSTRAINT_ATTRIBUTE", constraintNode, StandardDdlLexicon.CONSTRAINT_ATTRIBUTE_TYPE);
            attrNode.setProperty(StandardDdlLexicon.PROPERTY_VALUE, (Object)"INITIALLY DEFERRED");
        }
        if (tokens.canConsume("INITIALLY", new String[]{"IMMEDIATE"})) {
            attrNode = this.nodeFactory().node("CONSTRAINT_ATTRIBUTE", constraintNode, StandardDdlLexicon.CONSTRAINT_ATTRIBUTE_TYPE);
            attrNode.setProperty(StandardDdlLexicon.PROPERTY_VALUE, (Object)"INITIALLY IMMEDIATE");
        }
    }

    protected void parseReferences(DdlTokenStream tokens, AstNode constraintNode) throws ParsingException {
        assert (tokens != null);
        assert (constraintNode != null);
        if (tokens.matches("REFERENCES")) {
            tokens.consume("REFERENCES");
            String tableName = this.parseName(tokens);
            this.nodeFactory().node(tableName, constraintNode, StandardDdlLexicon.TYPE_TABLE_REFERENCE);
            this.parseColumnNameList(tokens, constraintNode, StandardDdlLexicon.TYPE_FK_COLUMN_REFERENCE);
            tokens.canConsume("MATCH", new String[]{"FULL"});
            tokens.canConsume("MATCH", new String[]{"PARTIAL"});
            while (tokens.canConsume("ON", new String[]{"UPDATE"}) || tokens.canConsume("ON", new String[]{"DELETE"})) {
                if (tokens.matches("CASCADE") || tokens.matches("NOW()")) {
                    tokens.consume();
                    continue;
                }
                if (tokens.matches("SET", new String[]{"NULL"})) {
                    tokens.consume("SET", new String[]{"NULL"});
                    continue;
                }
                if (tokens.matches("SET", new String[]{"DEFAULT"})) {
                    tokens.consume("SET", new String[]{"DEFAULT"});
                    continue;
                }
                if (tokens.matches("NO", new String[]{"ACTION"})) {
                    tokens.consume("NO", new String[]{"ACTION"});
                    continue;
                }
                System.out.println(" ERROR:   ColumnDefinition REFERENCES has NO REFERENCIAL ACTION.");
            }
        }
    }

    protected AstNode parseCreateViewStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        String stmtType = "CREATE";
        tokens.consume("CREATE");
        if (tokens.canConsume("OR", new String[]{"REPLACE"})) {
            stmtType = stmtType + " " + "OR REPLACE";
        }
        tokens.consume("VIEW");
        stmtType = stmtType + " " + "VIEW";
        String name = this.parseName(tokens);
        AstNode createViewNode = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_CREATE_VIEW_STATEMENT);
        this.parseColumnNameList(tokens, createViewNode, StandardDdlLexicon.TYPE_COLUMN_REFERENCE);
        tokens.consume("AS");
        String queryExpression = this.parseUntilTerminator(tokens);
        createViewNode.setProperty(StandardDdlLexicon.CREATE_VIEW_QUERY_EXPRESSION, (Object)queryExpression);
        this.markEndOfStatement(tokens, createViewNode);
        return createViewNode;
    }

    protected AstNode parseCreateSchemaStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        this.markStartOfStatement(tokens);
        AstNode schemaNode = null;
        String authorizationIdentifier = null;
        String schemaName = null;
        tokens.consume("CREATE", new String[]{"SCHEMA"});
        if (tokens.canConsume("AUTHORIZATION")) {
            authorizationIdentifier = tokens.consume();
        } else {
            schemaName = this.parseName(tokens);
            if (tokens.canConsume("AUTHORIZATION")) {
                authorizationIdentifier = this.parseName(tokens);
            }
        }
        assert (authorizationIdentifier != null || schemaName != null);
        schemaNode = schemaName != null ? this.nodeFactory().node(schemaName, parentNode, StandardDdlLexicon.TYPE_CREATE_SCHEMA_STATEMENT) : this.nodeFactory().node(authorizationIdentifier, parentNode, StandardDdlLexicon.TYPE_CREATE_SCHEMA_STATEMENT);
        if (tokens.canConsume("DEFAULT", new String[]{"CHARACTER", "SET"})) {
            this.parseName(tokens);
        }
        this.markEndOfStatement(tokens, schemaNode);
        return schemaNode;
    }

    protected AstNode parseCreateAssertionStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        this.markStartOfStatement(tokens);
        AstNode node = null;
        tokens.consume("CREATE", new String[]{"ASSERTION"});
        String name = this.parseName(tokens);
        node = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_CREATE_ASSERTION_STATEMENT);
        tokens.consume("CHECK");
        String searchCondition = this.consumeParenBoundedTokens(tokens, false);
        node.setProperty(StandardDdlLexicon.CHECK_SEARCH_CONDITION, (Object)searchCondition);
        this.parseConstraintAttributes(tokens, node);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseIgnorableStatement(DdlTokenStream tokens, String name, AstNode parentNode) {
        AstNode node = this.nodeFactory().node(name, parentNode, StandardDdlLexicon.TYPE_STATEMENT);
        this.parseUntilTerminator(tokens);
        return node;
    }

    protected AstNode parseIgnorableStatement(DdlTokenStream tokens, String name, AstNode parentNode, Name mixinType) {
        CheckArg.isNotNull((Object)((Object)tokens), (String)"tokens");
        CheckArg.isNotNull((Object)name, (String)"name");
        CheckArg.isNotNull((Object)parentNode, (String)"parentNode");
        CheckArg.isNotNull((Object)mixinType, (String)"mixinType");
        AstNode node = this.nodeFactory().node(name, parentNode, mixinType);
        this.parseUntilTerminator(tokens);
        return node;
    }

    protected AstNode parseStatement(DdlTokenStream tokens, String[] stmt_start_phrase, AstNode parentNode, Name mixinType) {
        CheckArg.isNotNull((Object)((Object)tokens), (String)"tokens");
        CheckArg.isNotNull((Object)stmt_start_phrase, (String)"stmt_start_phrase");
        CheckArg.isNotNull((Object)parentNode, (String)"parentNode");
        CheckArg.isNotNull((Object)mixinType, (String)"mixinType");
        this.markStartOfStatement(tokens);
        tokens.consume(stmt_start_phrase);
        AstNode result = this.parseIgnorableStatement(tokens, this.getStatementTypeName(stmt_start_phrase), parentNode, mixinType);
        this.markEndOfStatement(tokens, result);
        return result;
    }

    public final AstNode unknownTerminatedNode(AstNode parentNode) {
        return this.nodeFactory.node("unknownStatement", parentNode, StandardDdlLexicon.TYPE_UNKNOWN_STATEMENT);
    }

    public final AstNode missingTerminatorNode(AstNode parentNode) {
        return this.nodeFactory.node("missingTerminator", parentNode, StandardDdlLexicon.TYPE_MISSING_TERMINATOR);
    }

    public final boolean isMissingTerminatorNode(AstNode node) {
        return node.getName().getString().equals("missingTerminator") && this.nodeFactory().hasMixinType(node, StandardDdlLexicon.TYPE_MISSING_TERMINATOR);
    }

    public final boolean isValidSchemaChild(AstNode node) {
        Name[] schemaChildMixins = this.getValidSchemaChildTypes();
        for (Object mixin : node.getProperty(JcrLexicon.MIXIN_TYPES).getValuesAsArray()) {
            if (!(mixin instanceof Name)) continue;
            for (Name nextType : schemaChildMixins) {
                if (!nextType.equals(mixin)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean setAsSchemaChildNode(AstNode statementNode, boolean stmtIsMissingTerminator) {
        if (!this.isValidSchemaChild(statementNode)) {
            return false;
        }
        List<AstNode> children = this.getRootNode().getChildren();
        if (children.size() > 2) {
            AstNode theSchemaNode;
            AstNode previousNode = children.get(children.size() - 2);
            if (this.nodeFactory().hasMixinType(previousNode, StandardDdlLexicon.TYPE_MISSING_TERMINATOR) && ((theSchemaNode = children.get(children.size() - 3)).getChildCount() == 0 || this.nodeFactory().hasMixinType(theSchemaNode.getLastChild(), StandardDdlLexicon.TYPE_MISSING_TERMINATOR)) && this.nodeFactory().hasMixinType(theSchemaNode, StandardDdlLexicon.TYPE_CREATE_SCHEMA_STATEMENT)) {
                statementNode.setParent(theSchemaNode);
                if (stmtIsMissingTerminator) {
                    this.missingTerminatorNode(theSchemaNode);
                }
                return true;
            }
        }
        return false;
    }

    protected String getTerminator() {
        return this.terminator;
    }

    protected boolean setTerminator(String terminator) {
        CheckArg.isNotNull((Object)terminator, (String)"terminator");
        if (this.terminator.equalsIgnoreCase(terminator)) {
            return false;
        }
        this.terminator = terminator;
        return true;
    }

    protected Name[] getValidSchemaChildTypes() {
        return VALID_SCHEMA_CHILD_TYPES;
    }

    protected boolean isComment(DdlTokenStream tokens) throws ParsingException {
        return tokens.matches(32);
    }

    protected boolean consumeComment(DdlTokenStream tokens) throws ParsingException {
        return tokens.canConsume(32);
    }

    protected boolean isTableConstraint(DdlTokenStream tokens) throws ParsingException {
        boolean result = false;
        if (tokens.matches("PRIMARY", new String[]{"KEY"}) || tokens.matches("FOREIGN", new String[]{"KEY"}) || tokens.matches("UNIQUE")) {
            result = true;
        } else if (tokens.matches("CONSTRAINT") && (tokens.matches("CONSTRAINT", new String[]{"any value", "UNIQUE"}) || tokens.matches("CONSTRAINT", new String[]{"any value", "PRIMARY", "KEY"}) || tokens.matches("CONSTRAINT", new String[]{"any value", "FOREIGN", "KEY"}) || tokens.matches("CONSTRAINT", new String[]{"any value", "CHECK"}))) {
            result = true;
        }
        return result;
    }

    protected boolean isColumnDefinitionStart(DdlTokenStream tokens) throws ParsingException {
        boolean result = false;
        if (this.isTableConstraint(tokens)) {
            result = false;
        } else {
            String dTypeStartWord;
            Iterator<String> i$ = this.getDataTypeStartWords().iterator();
            while (i$.hasNext() && !(result = tokens.matches("any value", new String[]{dTypeStartWord = i$.next()}) || tokens.matches("COLUMN", new String[]{"any value", dTypeStartWord}))) {
            }
        }
        return result;
    }

    protected List<String> getDataTypeStartWords() {
        if (this.allDataTypeStartWords == null) {
            this.allDataTypeStartWords = new ArrayList<String>();
            this.allDataTypeStartWords.addAll(DdlConstants.DataTypes.DATATYPE_START_WORDS);
            this.allDataTypeStartWords.addAll(this.getCustomDataTypeStartWords());
        }
        return this.allDataTypeStartWords;
    }

    protected List<String> getCustomDataTypeStartWords() {
        return Collections.emptyList();
    }

    protected String parseName(DdlTokenStream tokens) {
        StringBuffer sb = new StringBuffer();
        if (tokens.matches('[')) {
            while (true) {
                tokens.consume('[');
                sb.append(this.consumeIdentifier(tokens));
                tokens.consume(']');
                if (tokens.matches('.')) {
                    sb.append(tokens.consume());
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                sb.append(this.consumeIdentifier(tokens));
                if (!tokens.matches('.')) break;
                sb.append(tokens.consume());
            }
        }
        return sb.toString();
    }

    protected String consumeIdentifier(DdlTokenStream tokens) throws ParsingException {
        String value = tokens.consume();
        if (value.charAt(0) == '\"') {
            int length = value.length();
            value = value.substring(1, length - 1);
        }
        return value;
    }

    protected boolean isTerminator(DdlTokenStream tokens) throws ParsingException {
        boolean result = tokens.matches(this.getTerminator());
        return result;
    }

    protected boolean parseColumnNameList(DdlTokenStream tokens, AstNode parentNode, Name referenceType) {
        boolean parsedColumns = false;
        List<Object> columnNameList = new ArrayList();
        if (tokens.matches("(")) {
            tokens.consume("(");
            columnNameList = this.parseColumnNameList(tokens);
            tokens.consume(")");
        }
        for (String columnName : columnNameList) {
            this.nodeFactory().node(columnName, parentNode, referenceType);
            parsedColumns = true;
        }
        return parsedColumns;
    }

    protected List<String> parseColumnNameList(DdlTokenStream tokens) throws ParsingException {
        LinkedList<String> columnNames = new LinkedList<String>();
        do {
            columnNames.add(this.parseName(tokens));
        } while (tokens.canConsume(","));
        return columnNames;
    }

    protected String parseUntilTerminator(DdlTokenStream tokens) throws ParsingException {
        StringBuffer sb = new StringBuffer();
        if (this.doUseTerminator()) {
            boolean lastTokenWasPeriod = false;
            while (tokens.hasNext() && !tokens.matches(128) && !this.isTerminator(tokens)) {
                String thisToken = tokens.consume();
                boolean thisTokenIsPeriod = thisToken.equals(".");
                boolean thisTokenIsComma = thisToken.equals(",");
                if (lastTokenWasPeriod || thisTokenIsPeriod || thisTokenIsComma) {
                    sb.append(thisToken);
                } else {
                    sb.append(" ").append(thisToken);
                }
                if (thisTokenIsPeriod) {
                    lastTokenWasPeriod = true;
                    continue;
                }
                lastTokenWasPeriod = false;
            }
        } else {
            boolean lastTokenWasPeriod = false;
            while (tokens.hasNext() && !tokens.matches(128)) {
                String thisToken = tokens.consume();
                boolean thisTokenIsPeriod = thisToken.equals(".");
                boolean thisTokenIsComma = thisToken.equals(",");
                if (lastTokenWasPeriod || thisTokenIsPeriod || thisTokenIsComma) {
                    sb.append(thisToken);
                } else {
                    sb.append(" ").append(thisToken);
                }
                if (thisTokenIsPeriod) {
                    lastTokenWasPeriod = true;
                    continue;
                }
                lastTokenWasPeriod = false;
            }
        }
        return sb.toString();
    }

    protected String parseUntilTerminatorIgnoreEmbeddedStatements(DdlTokenStream tokens) throws ParsingException {
        StringBuffer sb = new StringBuffer();
        boolean lastTokenWasPeriod = false;
        while (tokens.hasNext() && !this.isTerminator(tokens)) {
            String thisToken = tokens.consume();
            boolean thisTokenIsPeriod = thisToken.equals(".");
            boolean thisTokenIsComma = thisToken.equals(",");
            if (lastTokenWasPeriod || thisTokenIsPeriod || thisTokenIsComma) {
                sb.append(thisToken);
            } else {
                sb.append(" ").append(thisToken);
            }
            if (thisTokenIsPeriod) {
                lastTokenWasPeriod = true;
                continue;
            }
            lastTokenWasPeriod = false;
        }
        return sb.toString();
    }

    protected String parseUntilSemiColon(DdlTokenStream tokens) throws ParsingException {
        StringBuffer sb = new StringBuffer();
        boolean lastTokenWasPeriod = false;
        while (tokens.hasNext() && !tokens.matches(";")) {
            String thisToken = tokens.consume();
            boolean thisTokenIsPeriod = thisToken.equals(".");
            boolean thisTokenIsComma = thisToken.equals(",");
            if (lastTokenWasPeriod || thisTokenIsPeriod || thisTokenIsComma) {
                sb.append(thisToken);
            } else {
                sb.append(" ").append(thisToken);
            }
            if (thisTokenIsPeriod) {
                lastTokenWasPeriod = true;
                continue;
            }
            lastTokenWasPeriod = false;
        }
        return sb.toString();
    }

    protected String parseUntilCommaOrTerminator(DdlTokenStream tokens) throws ParsingException {
        StringBuffer sb = new StringBuffer();
        if (this.doUseTerminator()) {
            while (tokens.hasNext() && !tokens.matches(128) && !this.isTerminator(tokens) && !tokens.matches(",")) {
                sb.append(" ").append(tokens.consume());
            }
        } else {
            while (tokens.hasNext() && !tokens.matches(128) && !tokens.matches(",")) {
                sb.append(" ").append(tokens.consume());
            }
        }
        return sb.toString();
    }

    public boolean doUseTerminator() {
        return this.useTerminator;
    }

    public void setDoUseTerminator(boolean useTerminator) {
        this.useTerminator = useTerminator;
    }

    public String getStatementTypeName(String[] stmtPhrase) {
        StringBuffer sb = new StringBuffer(100);
        for (int i = 0; i < stmtPhrase.length; ++i) {
            if (i == 0) {
                sb.append(stmtPhrase[0]);
                continue;
            }
            sb.append(" ").append(stmtPhrase[i]);
        }
        return sb.toString();
    }

    protected boolean parseDefaultClause(DdlTokenStream tokens, AstNode columnNode) throws ParsingException {
        assert (tokens != null);
        assert (columnNode != null);
        String defaultValue = "";
        if (tokens.canConsume("DEFAULT")) {
            int optionID = -1;
            int precision = -1;
            if (tokens.canConsume("CURRENT_DATE")) {
                optionID = 1;
                defaultValue = "CURRENT_DATE";
            } else if (tokens.canConsume("CURRENT_TIME")) {
                optionID = 1;
                defaultValue = "CURRENT_TIME";
                if (tokens.canConsume("(")) {
                    precision = this.integer(tokens.consume());
                    tokens.canConsume(")");
                }
            } else if (tokens.canConsume("CURRENT_TIMESTAMP")) {
                optionID = 1;
                defaultValue = "CURRENT_TIMESTAMP";
                if (tokens.canConsume("(")) {
                    precision = this.integer(tokens.consume());
                    tokens.canConsume(")");
                }
            } else if (tokens.canConsume("USER")) {
                optionID = 2;
                defaultValue = "USER";
            } else if (tokens.canConsume("CURRENT_USER")) {
                optionID = 3;
                defaultValue = "CURRENT_USER";
            } else if (tokens.canConsume("SESSION_USER")) {
                optionID = 4;
                defaultValue = "SESSION_USER";
            } else if (tokens.canConsume("SYSTEM_USER")) {
                optionID = 5;
                defaultValue = "SYSTEM_USER";
            } else if (tokens.canConsume("NULL")) {
                optionID = 6;
                defaultValue = "NULL";
            } else if (tokens.canConsume("(")) {
                optionID = 0;
                while (!tokens.canConsume(")")) {
                    defaultValue = defaultValue + tokens.consume();
                }
            } else {
                optionID = 0;
                defaultValue = tokens.consume();
                if (tokens.canConsume(".")) {
                    defaultValue = defaultValue + '.' + tokens.consume();
                }
            }
            columnNode.setProperty(StandardDdlLexicon.DEFAULT_OPTION, (Object)optionID);
            columnNode.setProperty(StandardDdlLexicon.DEFAULT_VALUE, (Object)defaultValue);
            if (precision > -1) {
                columnNode.setProperty(StandardDdlLexicon.DEFAULT_PRECISION, (Object)precision);
            }
            return true;
        }
        return false;
    }

    protected boolean parseCollateClause(DdlTokenStream tokens, AstNode columnNode) throws ParsingException {
        assert (tokens != null);
        assert (columnNode != null);
        if (tokens.matches("COLLATE")) {
            tokens.consume("COLLATE");
            String collationName = this.parseName(tokens);
            columnNode.setProperty(StandardDdlLexicon.COLLATION_NAME, (Object)collationName);
            return true;
        }
        return false;
    }

    protected int integer(String value) {
        assert (value != null);
        assert (value.length() > 0);
        return new BigInteger(value).intValue();
    }

    public final Position getCurrentMarkedPosition() {
        return this.currentMarkedPosition;
    }

    public final void markStartOfStatement(DdlTokenStream tokens) {
        tokens.mark();
        this.currentMarkedPosition = tokens.nextPosition();
    }

    public final void markEndOfStatement(DdlTokenStream tokens, AstNode statementNode) {
        if (!tokens.canConsume(this.getTerminator())) {
            if (!this.setAsSchemaChildNode(statementNode, true)) {
                this.missingTerminatorNode(this.getRootNode());
            }
        } else {
            this.setAsSchemaChildNode(statementNode, false);
        }
        String source = tokens.getMarkedContent().trim();
        statementNode.setProperty(StandardDdlLexicon.DDL_EXPRESSION, (Object)source);
        statementNode.setProperty(StandardDdlLexicon.DDL_START_LINE_NUMBER, (Object)this.currentMarkedPosition.getLine());
        statementNode.setProperty(StandardDdlLexicon.DDL_START_CHAR_INDEX, (Object)this.currentMarkedPosition.getIndexInContent());
        statementNode.setProperty(StandardDdlLexicon.DDL_START_COLUMN_NUMBER, (Object)this.currentMarkedPosition.getColumn());
        this.testPrint("== >> SOURCE:\n" + source + "\n");
    }

    protected void testPrint(String str) {
        if (this.isTestMode()) {
            System.out.println(str);
        }
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    @Override
    public String getId() {
        return "SQL92";
    }

    public int hashCode() {
        return this.parserId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DdlParser) {
            return ((DdlParser)obj).getId().equals(this.getId());
        }
        return false;
    }
}

