/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.TokenStream;
import org.modeshape.sequencer.ddl.DdlParserTestHelper;
import org.modeshape.sequencer.ddl.DdlTokenStream;

public class DdlTokenStreamTest
extends DdlParserTestHelper {
    public static final int WORD = 1;
    public static final int SYMBOL = 2;
    public static final int DECIMAL = 4;
    public static final int SINGLE_QUOTED_STRING = 8;
    public static final int DOUBLE_QUOTED_STRING = 16;
    public static final int COMMENT = 32;
    public static final int KEYWORD = 64;
    public static final int STATEMENT_KEY = 128;
    public static final String CREATE = "CREATE";
    public static final String ALTER = "ALTER";
    public static final String DROP = "DROP";
    public static final String PUNT = "PUNT";
    public static final String FOOBAR = "FOOBAR";
    public static final String[] STMT_CREATE_FOOBAR = new String[]{"CREATE", "FOOBAR"};
    public static final String[] STMT_ALTER_FOOBAR = new String[]{"ALTER", "FOOBAR"};
    public static final String[] STMT_DROP_FOOBAR = new String[]{"DROP", "FOOBAR"};
    public static final String[] STMT_PUNT_FOOBAR = new String[]{"PUNT", "FOOBAR"};
    private static final String[] CUSTOM_KEYWORDS = new String[]{"CREATE", "ALTER", "DROP", "PUNT", "FOOBAR"};
    private TokenStream.Tokenizer tokenizer;

    @Before
    public void beforeEach() {
        this.tokenizer = DdlTokenStream.ddlTokenizer((boolean)true);
        this.setPrintToConsole(false);
    }

    private DdlTokenStream getTokens(String content) {
        DdlTokenStream tokens = new DdlTokenStream(content, this.tokenizer, false);
        return tokens;
    }

    @Test
    public void shouldRegisterKeyWords() {
        this.printTest("shouldRegisterKeyWords()");
        String content = "CREATE FOOBAR with NO WORDS";
        DdlTokenStream tokens = this.getTokens(content);
        tokens.registerKeyWords(CUSTOM_KEYWORDS);
        tokens.start();
        Assert.assertTrue((boolean)tokens.isKeyWord(CREATE));
        Assert.assertTrue((boolean)tokens.isKeyWord(ALTER));
        Assert.assertTrue((boolean)tokens.isKeyWord(DROP));
        Assert.assertTrue((boolean)tokens.isKeyWord(PUNT));
        Assert.assertTrue((boolean)tokens.isKeyWord(FOOBAR));
        Assert.assertFalse((boolean)tokens.isKeyWord("BARNYARD"));
        Assert.assertTrue((boolean)tokens.matches(CREATE, new String[]{FOOBAR}));
        Assert.assertFalse((boolean)tokens.matches(PUNT, new String[]{FOOBAR}));
        Assert.assertTrue((boolean)tokens.matches(64));
        Assert.assertTrue((boolean)tokens.matches(1));
        Assert.assertTrue((boolean)tokens.isNextKeyWord());
        Assert.assertTrue((boolean)tokens.canConsume(CREATE));
        Assert.assertTrue((boolean)tokens.isNextKeyWord());
        Assert.assertTrue((boolean)tokens.canConsume(FOOBAR));
        Assert.assertThat((Object)tokens.nextPosition().getIndexInContent(), (Matcher)Is.is((Object)14));
        Assert.assertFalse((boolean)tokens.isNextKeyWord());
    }

    @Test
    public void shouldRegisterStatementStarts() {
        this.printTest("shouldRegisterStatementStarts()");
        String content = "CREATE FOOBAR with NO WORDS";
        DdlTokenStream tokens = this.getTokens(content);
        tokens.registerKeyWords(CUSTOM_KEYWORDS);
        tokens.registerStatementStartPhrase(STMT_CREATE_FOOBAR);
        tokens.registerStatementStartPhrase(STMT_ALTER_FOOBAR);
        tokens.registerStatementStartPhrase(STMT_DROP_FOOBAR);
        tokens.registerStatementStartPhrase(STMT_PUNT_FOOBAR);
        tokens.start();
        Assert.assertTrue((boolean)tokens.isNextStatementStart());
        Assert.assertTrue((boolean)tokens.matches(CREATE, new String[]{FOOBAR}));
        Assert.assertTrue((boolean)tokens.matches(STMT_CREATE_FOOBAR));
        Assert.assertFalse((boolean)tokens.matches(PUNT, new String[]{FOOBAR}));
        Assert.assertFalse((boolean)tokens.matches(STMT_ALTER_FOOBAR));
        Assert.assertTrue((boolean)tokens.matches(64));
        Assert.assertTrue((boolean)tokens.matches(128));
        Assert.assertTrue((boolean)tokens.matches(1));
    }

    @Test
    public void shouldMarkPosition() {
        this.printTest("shouldMarkPosition()");
        String content = "CREATE FOOBAR with NO WORDS";
        DdlTokenStream tokens = this.getTokens(content);
        tokens.start();
        tokens.consume(CREATE);
        tokens.mark();
        tokens.consume();
        tokens.consume();
        tokens.consume();
        String stringFragment = tokens.getMarkedContent();
        Assert.assertThat((Object)stringFragment, (Matcher)Is.is((Object)"FOOBAR with NO "));
    }

    @Test
    public void shouldMarkPositionWithMultilineContent() {
        this.printTest("shouldMarkPositionWithMultilineContent()");
        String content = "CREATE FOOBAR with NO WORDS;\nCREATE BARFOO with lots of words after it;\nCREATE TABLE myTable (column definition data);";
        String fragment = "with lots of words after it;\nCREATE TABLE myTable (column definition data);";
        DdlTokenStream tokens = this.getTokens(content);
        tokens.start();
        while (tokens.hasNext()) {
            String lastToken = tokens.consume();
            if (!lastToken.equalsIgnoreCase("BARFOO")) continue;
            tokens.mark();
        }
        String stringFragment = tokens.getMarkedContent();
        Assert.assertThat((Object)stringFragment, (Matcher)Is.is((Object)fragment));
    }

    @Test
    public void shouldFindNextPositionStartIndex() {
        this.printTest("shouldFindNextPositionStartIndex()");
        String content = "Select all columns from this table";
        DdlTokenStream tokens = this.getTokens(content);
        tokens.start();
        Assert.assertThat((Object)tokens.nextPosition().getIndexInContent(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)tokens.nextPosition().getColumn(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)tokens.nextPosition().getLine(), (Matcher)Is.is((Object)1));
        tokens.consume();
        Assert.assertThat((Object)tokens.nextPosition().getIndexInContent(), (Matcher)Is.is((Object)7));
        Assert.assertThat((Object)tokens.nextPosition().getColumn(), (Matcher)Is.is((Object)8));
        Assert.assertThat((Object)tokens.nextPosition().getLine(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseMultiLineString() {
        this.printTest("shouldParseMultiLineString()");
        String content = "ALTER DATABASE \nDO SOMETHING; \nALTER DATABASE \n      SET DEFAULT BIGFILE TABLESPACE;";
        DdlTokenStream tokens = this.getTokens(content);
        tokens.start();
        tokens.consume();
        tokens.consume();
        tokens.consume();
        tokens.consume();
        tokens.consume();
        Assert.assertThat((Object)tokens.nextPosition().getIndexInContent(), (Matcher)Is.is((Object)31));
        Assert.assertThat((Object)tokens.nextPosition().getColumn(), (Matcher)Is.is((Object)1));
        tokens.consume();
        Assert.assertThat((Object)tokens.nextPosition().getIndexInContent(), (Matcher)Is.is((Object)37));
        Assert.assertThat((Object)tokens.nextPosition().getColumn(), (Matcher)Is.is((Object)7));
    }
}

