/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.node;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.sequencer.ddl.StandardDdlLexicon;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.modeshape.sequencer.ddl.node.AstNodeFactory;

public class AstNodeFactoryTest {
    private AstNodeFactory nodeFactory;
    private AstNode rootNode;

    @Before
    public void beforeEach() {
        this.nodeFactory = new AstNodeFactory();
        this.rootNode = this.nodeFactory.node("testRootNode");
        this.rootNode.setProperty(JcrLexicon.MIXIN_TYPES, (Object)StandardDdlLexicon.STATEMENTS_CONTAINER);
        this.rootNode.setProperty(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.UNSTRUCTURED);
    }

    @Test
    public void shouldCreateName() {
        String nodeName = "myNodeName";
        Name name = this.nodeFactory.name(nodeName);
        Assert.assertNotNull((Object)name);
        Assert.assertEquals((Object)nodeName, (Object)name.getString());
    }

    @Test
    public void shouldCreateChildNode() {
        String name = "myNodeName";
        this.nodeFactory.node(name, this.rootNode, StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertEquals((Object)this.rootNode.getProperty(JcrLexicon.MIXIN_TYPES).getFirstValue(), (Object)StandardDdlLexicon.STATEMENTS_CONTAINER);
        Assert.assertEquals((Object)this.rootNode.getChild(0).getProperty(JcrLexicon.MIXIN_TYPES).getFirstValue(), (Object)StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
        Assert.assertThat((Object)this.rootNode.getChild(0).getName().getString(), (Matcher)Is.is((Object)name));
    }

    @Test
    public void shouldHaveMixinTypeForNode() {
        String name = "myNodeName";
        this.nodeFactory.node(name, this.rootNode, StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.nodeFactory.hasMixinType(this.rootNode, StandardDdlLexicon.STATEMENTS_CONTAINER), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.nodeFactory.hasMixinType(this.rootNode.getChild(0), StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldFindChildForNameAndType() {
        String name = "myNodeName";
        this.nodeFactory.node(name, this.rootNode, StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
        AstNode node = this.nodeFactory.getChildforNameAndType(this.rootNode, name, StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.nodeFactory.hasMixinType(this.rootNode, StandardDdlLexicon.STATEMENTS_CONTAINER), (Matcher)Is.is((Object)true));
        Assert.assertNotNull((Object)node);
    }

    @Test
    public void shouldNotFindChildForRightNameWrongType() {
        String name = "myNodeName";
        this.nodeFactory.node(name, this.rootNode, StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
        AstNode node = this.nodeFactory.getChildforNameAndType(this.rootNode, name, StandardDdlLexicon.TYPE_CREATE_VIEW_STATEMENT);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.nodeFactory.hasMixinType(this.rootNode, StandardDdlLexicon.STATEMENTS_CONTAINER), (Matcher)Is.is((Object)true));
        Assert.assertNull((Object)node);
    }

    @Test
    public void shouldNotFindChildForWrongNameRightType() {
        String name = "myNodeName";
        this.nodeFactory.node(name, this.rootNode, StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
        AstNode node = this.nodeFactory.getChildforNameAndType(this.rootNode, "wrongName", StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
        Assert.assertNull((Object)node);
    }

    @Test
    public void shouldSetTypeOnNode() {
        String name = "myNodeName";
        AstNode node = this.nodeFactory.node(name);
        Assert.assertNotNull((Object)node);
        this.nodeFactory.setType(node, StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
        Assert.assertThat((Object)this.nodeFactory.hasMixinType(node, StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT), (Matcher)Is.is((Object)true));
    }
}

