/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.derby;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.text.ParsingException;
import org.modeshape.graph.property.Name;
import org.modeshape.sequencer.ddl.DdlParserProblem;
import org.modeshape.sequencer.ddl.DdlSequencerI18n;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.StandardDdlLexicon;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.datatype.DataType;
import org.modeshape.sequencer.ddl.datatype.DataTypeParser;
import org.modeshape.sequencer.ddl.dialect.derby.DerbyDdlConstants;
import org.modeshape.sequencer.ddl.dialect.derby.DerbyDdlLexicon;
import org.modeshape.sequencer.ddl.node.AstNode;

public class DerbyDdlParser
extends StandardDdlParser
implements DerbyDdlConstants,
DerbyDdlConstants.DerbyStatementStartPhrases {
    private final String parserId = "DERBY";
    protected static final List<String[]> derbyDataTypeStrings = new ArrayList<String[]>(DerbyDdlConstants.DerbyDataTypes.CUSTOM_DATATYPE_START_PHRASES);
    private static final String TERMINATOR = ";";

    public DerbyDdlParser() {
        this.setDatatypeParser(new DerbyDataTypeParser());
        this.setDoUseTerminator(true);
        this.setTerminator(TERMINATOR);
    }

    @Override
    protected void initializeTokenStream(DdlTokenStream tokens) {
        super.initializeTokenStream(tokens);
        tokens.registerKeyWords(CUSTOM_KEYWORDS);
        tokens.registerStatementStartPhrase(ALTER_PHRASES);
        tokens.registerStatementStartPhrase(CREATE_PHRASES);
        tokens.registerStatementStartPhrase(DROP_PHRASES);
        tokens.registerStatementStartPhrase(SET_PHRASES);
        tokens.registerStatementStartPhrase(MISC_PHRASES);
    }

    @Override
    public String getId() {
        return this.parserId;
    }

    @Override
    protected Name[] getValidSchemaChildTypes() {
        return VALID_SCHEMA_CHILD_STMTS;
    }

    @Override
    protected AstNode parseCustomStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        AstNode result = super.parseCustomStatement(tokens, parentNode);
        if (result == null) {
            if (tokens.matches(STMT_LOCK_TABLE)) {
                result = this.parseLockTable(tokens, parentNode);
            } else if (tokens.matches(STMT_RENAME_TABLE)) {
                result = this.parseRenameTable(tokens, parentNode);
            } else if (tokens.matches(STMT_RENAME_INDEX)) {
                result = this.parseRenameIndex(tokens, parentNode);
            } else if (tokens.matches(STMT_DECLARE_GLOBAL_TEMP_TABLE)) {
                result = this.parseDeclareGlobalTempTable(tokens, parentNode);
            }
        }
        return result;
    }

    @Override
    protected AstNode parseCreateStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_CREATE_INDEX) || tokens.matches(STMT_CREATE_UNIQUE_INDEX)) {
            return this.parseCreateIndex(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_FUNCTION)) {
            return this.parseCreateFunction(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_PROCEDURE)) {
            return this.parseCreateProcedure(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_ROLE)) {
            return this.parseCreateRole(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_SYNONYM)) {
            return this.parseCreateSynonym(tokens, parentNode);
        }
        if (tokens.matches(STMT_CREATE_TRIGGER)) {
            return this.parseCreateTrigger(tokens, parentNode);
        }
        return super.parseCreateStatement(tokens, parentNode);
    }

    protected AstNode parseCreateIndex(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("CREATE");
        boolean isUnique = tokens.canConsume("UNIQUE");
        tokens.consume("INDEX");
        String indexName = this.parseName(tokens);
        tokens.consume("ON");
        String tableName = this.parseName(tokens);
        AstNode indexNode = this.nodeFactory().node(indexName, parentNode, DerbyDdlLexicon.TYPE_CREATE_INDEX_STATEMENT);
        indexNode.setProperty(DerbyDdlLexicon.UNIQUE_INDEX, (Object)isUnique);
        indexNode.setProperty(DerbyDdlLexicon.TABLE_NAME, (Object)tableName);
        this.parseIndexTableColumns(tokens, indexNode);
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, indexNode);
        return indexNode;
    }

    private void parseIndexTableColumns(DdlTokenStream tokens, AstNode indexNode) throws ParsingException {
        assert (tokens != null);
        assert (indexNode != null);
        tokens.consume("(");
        while (!tokens.canConsume(")")) {
            String colName = this.parseName(tokens);
            AstNode colRefNode = this.nodeFactory().node(colName, indexNode, DerbyDdlLexicon.TYPE_INDEX_COLUMN_REFERENCE);
            if (tokens.canConsume("ASC")) {
                colRefNode.setProperty(DerbyDdlLexicon.ORDER, (Object)"ASC");
            } else if (tokens.canConsume("DESC")) {
                colRefNode.setProperty(DerbyDdlLexicon.ORDER, (Object)"DESC");
            }
            tokens.canConsume(",");
        }
    }

    protected AstNode parseCreateFunction(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("CREATE", new String[]{"FUNCTION"});
        String functionName = this.parseName(tokens);
        AstNode functionNode = this.nodeFactory().node(functionName, parentNode, DerbyDdlLexicon.TYPE_CREATE_FUNCTION_STATEMENT);
        this.parseFunctionParameters(tokens, functionNode);
        tokens.consume("RETURNS");
        if (tokens.canConsume("TABLE")) {
            AstNode tableNode = this.nodeFactory().node("TABLE", functionNode, DerbyDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
            tableNode.setProperty(DerbyDdlLexicon.DDL_START_LINE_NUMBER, (Object)this.getCurrentMarkedPosition().getLine());
            tableNode.setProperty(DerbyDdlLexicon.DDL_START_CHAR_INDEX, (Object)this.getCurrentMarkedPosition().getIndexInContent());
            tableNode.setProperty(DerbyDdlLexicon.DDL_START_COLUMN_NUMBER, (Object)this.getCurrentMarkedPosition().getColumn());
            this.parseColumnsAndConstraints(tokens, tableNode);
            String expressionSource = "TABLE " + tokens.getMarkedContent();
            tableNode.setProperty(DerbyDdlLexicon.DDL_EXPRESSION, (Object)expressionSource);
            tableNode.setProperty(DerbyDdlLexicon.DDL_LENGTH, (Object)expressionSource.length());
            functionNode.setProperty(DerbyDdlLexicon.IS_TABLE_TYPE, (Object)true);
        } else {
            DataType datatype = this.getDatatypeParser().parse(tokens);
            if (datatype != null) {
                this.getDatatypeParser().setPropertiesOnNode(functionNode, datatype);
            } else {
                String msg = DdlSequencerI18n.missingReturnTypeForFunction.text(new Object[]{functionName});
                DdlParserProblem problem = new DdlParserProblem(1, this.getCurrentMarkedPosition(), msg);
                this.addProblem(problem, functionNode);
            }
        }
        while (!this.isTerminator(tokens)) {
            AstNode optionNode;
            if (tokens.matches("LANGUAGE")) {
                optionNode = this.nodeFactory().node("language", functionNode, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
                if (tokens.canConsume("LANGUAGE", new String[]{"JAVA"})) {
                    optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"LANGUAGE JAVA");
                    continue;
                }
                tokens.consume("LANGUAGE");
                optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"LANGUAGE");
                continue;
            }
            if (tokens.canConsume("DETERMINISTIC")) {
                optionNode = this.nodeFactory().node("deterministic", functionNode, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
                optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"DETERMINISTIC");
                continue;
            }
            if (tokens.canConsume("NOT", new String[]{"DETERMINISTIC"})) {
                optionNode = this.nodeFactory().node("deterministic", functionNode, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
                optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"NOT DETERMINISTIC");
                continue;
            }
            if (tokens.canConsume("EXTERNAL", new String[]{"NAME"})) {
                String extName = this.parseName(tokens);
                AstNode optionNode2 = this.nodeFactory().node("externalName", functionNode, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
                optionNode2.setProperty(DerbyDdlLexicon.VALUE, (Object)("EXTERNAL NAME " + extName));
                continue;
            }
            if (tokens.canConsume("PARAMETER", new String[]{"STYLE"})) {
                if (tokens.canConsume("JAVA")) {
                    functionNode.setProperty(DerbyDdlLexicon.PARAMETER_STYLE, (Object)"PARAMETER STYLE JAVA");
                    continue;
                }
                tokens.consume("DERBY_JDBC_RESULT_SET");
                functionNode.setProperty(DerbyDdlLexicon.PARAMETER_STYLE, (Object)"PARAMETER STYLE DERBY_JDBC_RESULT_SET");
                continue;
            }
            if (tokens.canConsume("NO", new String[]{"SQL"})) {
                optionNode = this.nodeFactory().node("sqlStatus", functionNode, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
                optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"NO SQL");
                continue;
            }
            if (tokens.canConsume("CONTAINS", new String[]{"SQL"})) {
                optionNode = this.nodeFactory().node("sqlStatus", functionNode, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
                optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"CONTAINS SQL");
                continue;
            }
            if (tokens.canConsume("READS", new String[]{"SQL", "DATA"})) {
                optionNode = this.nodeFactory().node("sqlStatus", functionNode, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
                optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"READS SQL DATA");
                continue;
            }
            if (tokens.canConsume("RETURNS", new String[]{"NULL", "ON", "NULL", "INPUT"})) {
                optionNode = this.nodeFactory().node("nullInput", functionNode, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
                optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"RETURNS NULL ON NULL INPUT");
                continue;
            }
            if (tokens.canConsume("CALLED", new String[]{"ON", "NULL", "INPUT"})) {
                optionNode = this.nodeFactory().node("nullInput", functionNode, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
                optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"CALLED ON NULL INPUT");
                continue;
            }
            String msg = DdlSequencerI18n.errorParsingDdlContent.text(new Object[]{functionName});
            DdlParserProblem problem = new DdlParserProblem(2, this.getCurrentMarkedPosition(), msg);
            this.addProblem(problem, functionNode);
            break;
        }
        this.markEndOfStatement(tokens, functionNode);
        return functionNode;
    }

    private void parseFunctionParameters(DdlTokenStream tokens, AstNode functionNode) throws ParsingException {
        assert (tokens != null);
        assert (functionNode != null);
        tokens.consume("(");
        while (!tokens.canConsume(")")) {
            DataType datatype = this.getDatatypeParser().parse(tokens);
            if (datatype == null) {
                String paramName = this.parseName(tokens);
                datatype = this.getDatatypeParser().parse(tokens);
                AstNode paramNode = this.nodeFactory().node(paramName, functionNode, DerbyDdlLexicon.TYPE_FUNCTION_PARAMETER);
                this.getDatatypeParser().setPropertiesOnNode(paramNode, datatype);
            } else {
                AstNode paramNode = this.nodeFactory().node("functionParameter", functionNode, DerbyDdlLexicon.TYPE_FUNCTION_PARAMETER);
                this.getDatatypeParser().setPropertiesOnNode(paramNode, datatype);
            }
            tokens.canConsume(",");
        }
    }

    protected AstNode parseCreateProcedure(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("CREATE", new String[]{"PROCEDURE"});
        String functionName = this.parseName(tokens);
        AstNode functionNode = this.nodeFactory().node(functionName, parentNode, DerbyDdlLexicon.TYPE_CREATE_PROCEDURE_STATEMENT);
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, functionNode);
        return functionNode;
    }

    protected AstNode parseCreateRole(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("CREATE", new String[]{"ROLE"});
        String functionName = this.parseName(tokens);
        AstNode functionNode = this.nodeFactory().node(functionName, parentNode, DerbyDdlLexicon.TYPE_CREATE_ROLE_STATEMENT);
        this.markEndOfStatement(tokens, functionNode);
        return functionNode;
    }

    @Override
    protected AstNode parseDropStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        AstNode dropNode = null;
        String name = null;
        if (tokens.matches(STMT_DROP_FUNCTION)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_DROP_FUNCTION);
            name = this.parseName(tokens);
            dropNode = this.nodeFactory().node(name, parentNode, DerbyDdlLexicon.TYPE_DROP_FUNCTION_STATEMENT);
        } else if (tokens.matches(STMT_DROP_INDEX)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_DROP_INDEX);
            name = this.parseName(tokens);
            dropNode = this.nodeFactory().node(name, parentNode, DerbyDdlLexicon.TYPE_DROP_INDEX_STATEMENT);
        } else if (tokens.matches(STMT_DROP_PROCEDURE)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_DROP_PROCEDURE);
            name = this.parseName(tokens);
            dropNode = this.nodeFactory().node(name, parentNode, DerbyDdlLexicon.TYPE_DROP_PROCEDURE_STATEMENT);
        } else if (tokens.matches(STMT_DROP_ROLE)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_DROP_ROLE);
            name = this.parseName(tokens);
            dropNode = this.nodeFactory().node(name, parentNode, DerbyDdlLexicon.TYPE_DROP_ROLE_STATEMENT);
        } else if (tokens.matches(STMT_DROP_SYNONYM)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_DROP_SYNONYM);
            name = this.parseName(tokens);
            dropNode = this.nodeFactory().node(name, parentNode, DerbyDdlLexicon.TYPE_DROP_SYNONYM_STATEMENT);
        } else if (tokens.matches(STMT_DROP_TRIGGER)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_DROP_TRIGGER);
            name = this.parseName(tokens);
            dropNode = this.nodeFactory().node(name, parentNode, DerbyDdlLexicon.TYPE_DROP_TRIGGER_STATEMENT);
        }
        if (dropNode != null) {
            this.markEndOfStatement(tokens, dropNode);
        }
        if (dropNode == null) {
            dropNode = super.parseDropStatement(tokens, parentNode);
        }
        return dropNode;
    }

    @Override
    protected AstNode parseGrantStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        assert (tokens.matches("GRANT"));
        this.markStartOfStatement(tokens);
        AstNode grantNode = null;
        boolean allPrivileges = false;
        ArrayList<AstNode> privileges = new ArrayList<AstNode>();
        tokens.consume("GRANT");
        if (tokens.canConsume("EXECUTE", new String[]{"ON"})) {
            String name;
            AstNode node = this.nodeFactory().node("privilege");
            this.nodeFactory().setType(node, DerbyDdlLexicon.GRANT_PRIVILEGE);
            node.setProperty(DerbyDdlLexicon.TYPE, (Object)"EXECUTE");
            privileges = new ArrayList();
            privileges.add(node);
            if (tokens.canConsume("FUNCTION")) {
                name = this.parseName(tokens);
                grantNode = this.nodeFactory().node(name, parentNode, DerbyDdlLexicon.TYPE_GRANT_ON_FUNCTION_STATEMENT);
            } else {
                tokens.consume("PROCEDURE");
                name = this.parseName(tokens);
                grantNode = this.nodeFactory().node(name, parentNode, DerbyDdlLexicon.TYPE_GRANT_ON_PROCEDURE_STATEMENT);
            }
        } else {
            if (tokens.canConsume("ALL", new String[]{"PRIVILEGES"})) {
                allPrivileges = true;
            } else {
                this.parseGrantPrivileges(tokens, privileges);
                if (privileges.isEmpty()) {
                    grantNode = this.nodeFactory().node("grantRoles", parentNode, DerbyDdlLexicon.TYPE_GRANT_ROLES_STATEMENT);
                    do {
                        String roleName = this.parseName(tokens);
                        this.nodeFactory().node(roleName, grantNode, DerbyDdlLexicon.ROLE_NAME);
                    } while (tokens.canConsume(","));
                }
            }
            if (grantNode == null) {
                tokens.consume("ON");
                tokens.canConsume("TABLE");
                String name = this.parseName(tokens);
                grantNode = this.nodeFactory().node(name, parentNode, DerbyDdlLexicon.TYPE_GRANT_ON_TABLE_STATEMENT);
                for (AstNode node : privileges) {
                    node.setParent(grantNode);
                }
                if (allPrivileges) {
                    grantNode.setProperty(DerbyDdlLexicon.ALL_PRIVILEGES, (Object)allPrivileges);
                }
            }
        }
        tokens.consume("TO");
        do {
            String grantee = this.parseName(tokens);
            this.nodeFactory().node(grantee, grantNode, DerbyDdlLexicon.GRANTEE);
        } while (tokens.canConsume(","));
        this.markEndOfStatement(tokens, grantNode);
        return grantNode;
    }

    @Override
    protected void parseGrantPrivileges(DdlTokenStream tokens, List<AstNode> privileges) throws ParsingException {
        do {
            AstNode node = null;
            if (tokens.canConsume("DELETE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(DerbyDdlLexicon.TYPE, (Object)"DELETE");
            } else if (tokens.canConsume("INSERT")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(DerbyDdlLexicon.TYPE, (Object)"INSERT");
            } else if (tokens.canConsume("REFERENCES")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(DerbyDdlLexicon.TYPE, (Object)"REFERENCES");
                this.parseColumnNameList(tokens, node, DerbyDdlLexicon.TYPE_COLUMN_REFERENCE);
            } else if (tokens.canConsume("SELECT")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(DerbyDdlLexicon.TYPE, (Object)"SELECT");
                this.parseColumnNameList(tokens, node, DerbyDdlLexicon.TYPE_COLUMN_REFERENCE);
            } else if (tokens.canConsume("TRIGGER")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(DerbyDdlLexicon.TYPE, (Object)"TRIGGER");
            } else if (tokens.canConsume("UPDATE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty(DerbyDdlLexicon.TYPE, (Object)"UPDATE");
                this.parseColumnNameList(tokens, node, DerbyDdlLexicon.TYPE_COLUMN_REFERENCE);
            }
            if (node == null) break;
            this.nodeFactory().setType(node, DerbyDdlLexicon.GRANT_PRIVILEGE);
            privileges.add(node);
        } while (tokens.canConsume(","));
    }

    @Override
    protected AstNode parseAlterTableStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("ALTER", new String[]{"TABLE"});
        String tableName = this.parseName(tokens);
        AstNode alterTableNode = this.nodeFactory().node(tableName, parentNode, DerbyDdlLexicon.TYPE_ALTER_TABLE_STATEMENT);
        if (tokens.canConsume("ADD")) {
            if (this.isTableConstraint(tokens)) {
                this.parseTableConstraint(tokens, alterTableNode, true);
            } else if (tokens.matches("(")) {
                this.parseColumns(tokens, alterTableNode, true);
            } else {
                this.parseSingleTerminatedColumnDefinition(tokens, alterTableNode, true);
            }
        } else if (tokens.canConsume("DROP")) {
            if (tokens.canConsume("PRIMARY", new String[]{"KEY"})) {
                String name = this.parseName(tokens);
                this.nodeFactory().node(name, alterTableNode, DerbyDdlLexicon.TYPE_DROP_TABLE_CONSTRAINT_DEFINITION);
            } else if (tokens.canConsume("FOREIGN", new String[]{"KEY"})) {
                String name = this.parseName(tokens);
                this.nodeFactory().node(name, alterTableNode, DerbyDdlLexicon.TYPE_DROP_TABLE_CONSTRAINT_DEFINITION);
            } else if (tokens.canConsume("UNIQUE")) {
                String name = this.parseName(tokens);
                this.nodeFactory().node(name, alterTableNode, DerbyDdlLexicon.TYPE_DROP_TABLE_CONSTRAINT_DEFINITION);
            } else if (tokens.canConsume("CHECK")) {
                String name = this.parseName(tokens);
                this.nodeFactory().node(name, alterTableNode, DerbyDdlLexicon.TYPE_DROP_TABLE_CONSTRAINT_DEFINITION);
            } else if (tokens.canConsume("CONSTRAINT")) {
                String name = this.parseName(tokens);
                this.nodeFactory().node(name, alterTableNode, DerbyDdlLexicon.TYPE_DROP_TABLE_CONSTRAINT_DEFINITION);
            } else {
                tokens.canConsume("COLUMN");
                String columnName = this.parseName(tokens);
                AstNode columnNode = this.nodeFactory().node(columnName, alterTableNode, DerbyDdlLexicon.TYPE_DROP_COLUMN_DEFINITION);
                if (tokens.canConsume("CASCADE")) {
                    columnNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"CASCADE");
                } else if (tokens.canConsume("RESTRICT")) {
                    columnNode.setProperty(StandardDdlLexicon.DROP_BEHAVIOR, (Object)"RESTRICT");
                }
            }
        } else if (tokens.canConsume("ALTER")) {
            tokens.canConsume("COLUMN");
            String alterColumnName = this.parseName(tokens);
            AstNode columnNode = this.nodeFactory().node(alterColumnName, alterTableNode, DerbyDdlLexicon.TYPE_ALTER_COLUMN_DEFINITION);
            if (tokens.matches("DEFAULT")) {
                this.parseDefaultClause(tokens, columnNode);
            } else if (tokens.canConsume("SET")) {
                if (tokens.canConsume("DATA", new String[]{"TYPE"})) {
                    DataType datatype = this.getDatatypeParser().parse(tokens);
                    columnNode.setProperty(StandardDdlLexicon.DATATYPE_NAME, (Object)datatype.getName());
                    if (datatype.getLength() >= 0L) {
                        columnNode.setProperty(StandardDdlLexicon.DATATYPE_LENGTH, (Object)datatype.getLength());
                    }
                    if (datatype.getPrecision() >= 0) {
                        columnNode.setProperty(StandardDdlLexicon.DATATYPE_PRECISION, (Object)datatype.getPrecision());
                    }
                    if (datatype.getScale() >= 0) {
                        columnNode.setProperty(StandardDdlLexicon.DATATYPE_SCALE, (Object)datatype.getScale());
                    }
                } else if (tokens.canConsume("INCREMENT")) {
                    tokens.consume("BY", new String[]{"any value"});
                }
                if (tokens.matches("DEFAULT")) {
                    this.parseDefaultClause(tokens, columnNode);
                }
            } else if (tokens.canConsume("WITH")) {
                this.parseDefaultClause(tokens, columnNode);
            } else {
                tokens.canConsume("RESTART", new String[]{"WITH", "any value"});
                tokens.canConsume("DROP", new String[]{"DEFAULT"});
                if (tokens.canConsume("NOT", new String[]{"NULL"})) {
                    columnNode.setProperty(StandardDdlLexicon.NULLABLE, (Object)"NOT NULL");
                } else if (tokens.canConsume("NULL")) {
                    columnNode.setProperty(StandardDdlLexicon.NULLABLE, (Object)"NULL");
                }
            }
        } else if (tokens.canConsume("LOCKSIZE")) {
            tokens.canConsume("ROWS");
            tokens.canConsume("TABLE");
        }
        this.markEndOfStatement(tokens, alterTableNode);
        return alterTableNode;
    }

    @Override
    protected void parseColumnDefinition(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        tokens.canConsume("COLUMN");
        String columnName = this.parseName(tokens);
        DataType datatype = this.getDatatypeParser().parse(tokens);
        AstNode columnNode = this.nodeFactory().node(columnName, tableNode, DerbyDdlLexicon.TYPE_COLUMN_DEFINITION);
        columnNode.setProperty(StandardDdlLexicon.DATATYPE_NAME, (Object)datatype.getName());
        if (datatype.getLength() >= 0L) {
            columnNode.setProperty(StandardDdlLexicon.DATATYPE_LENGTH, (Object)datatype.getLength());
        }
        if (datatype.getPrecision() >= 0) {
            columnNode.setProperty(StandardDdlLexicon.DATATYPE_PRECISION, (Object)datatype.getPrecision());
        }
        if (datatype.getScale() >= 0) {
            columnNode.setProperty(StandardDdlLexicon.DATATYPE_SCALE, (Object)datatype.getScale());
        }
        StringBuffer unusedTokensSB = new StringBuffer();
        while (tokens.hasNext() && !tokens.matches(",")) {
            boolean parsedDefaultClause = this.parseDefaultClause(tokens, columnNode);
            if (!parsedDefaultClause) {
                boolean parsedCollate = this.parseCollateClause(tokens, columnNode);
                boolean parsedConstraint = this.parseColumnConstraint(tokens, columnNode, isAlterTable);
                boolean parsedGeneratedColumn = this.parseGeneratedColumnSpecClause(tokens, columnNode);
                if (!(parsedCollate || parsedConstraint || parsedGeneratedColumn)) {
                    unusedTokensSB.append(" ").append(tokens.consume());
                }
            }
            tokens.canConsume(32);
        }
        if (unusedTokensSB.length() > 0) {
            String msg = DdlSequencerI18n.unusedTokensParsingColumnDefinition.text(new Object[]{tableNode.getName()});
            DdlParserProblem problem = new DdlParserProblem(1, this.getCurrentMarkedPosition(), msg);
            problem.setUnusedSource(unusedTokensSB.toString());
            this.addProblem(problem, tableNode);
        }
    }

    protected void parseColumns(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        String tableElementString = this.getTableElementsString(tokens, false);
        DdlTokenStream localTokens = new DdlTokenStream(tableElementString, DdlTokenStream.ddlTokenizer(false), false);
        localTokens.start();
        StringBuffer unusedTokensSB = new StringBuffer();
        do {
            if (this.isColumnDefinitionStart(localTokens)) {
                this.parseColumnDefinition(localTokens, tableNode, isAlterTable);
                continue;
            }
            unusedTokensSB.append(" ").append(localTokens.consume());
        } while (localTokens.canConsume(","));
        if (unusedTokensSB.length() > 0) {
            String msg = DdlSequencerI18n.unusedTokensParsingColumnDefinition.text(new Object[]{tableNode.getName()});
            DdlParserProblem problem = new DdlParserProblem(1, this.getCurrentMarkedPosition(), msg);
            problem.setUnusedSource(unusedTokensSB.toString());
            this.addProblem(problem, tableNode);
        }
    }

    private boolean parseGeneratedColumnSpecClause(DdlTokenStream tokens, AstNode columnNode) throws ParsingException {
        assert (tokens != null);
        assert (columnNode != null);
        if (tokens.canConsume("GENERATED")) {
            StringBuffer sb = new StringBuffer("GENERATED");
            if (tokens.canConsume("ALWAYS")) {
                sb.append(" ").append("ALWAYS");
            } else {
                tokens.consume("BY", new String[]{"DEFAULT"});
                sb.append(" ").append("BY DEFAULT");
            }
            tokens.consume("AS", new String[]{"IDENTITY"});
            sb.append(" ").append("AS IDENTITY");
            if (tokens.canConsume("(", new String[]{"START", "WITH"})) {
                String value = tokens.consume();
                sb.append(" ").append("(").append(" ").append("START WITH").append(" ").append(value);
                if (tokens.canConsume(",", new String[]{"INCREMENT", "BY"})) {
                    value = tokens.consume();
                    sb.append(",").append("INCREMENT BY").append(" ").append(value);
                }
                tokens.consume(")");
                sb.append(" ").append(")");
            }
            AstNode propNode = this.nodeFactory().node(StandardDdlLexicon.COLUMN_ATTRIBUTE_TYPE.getString(), columnNode, DerbyDdlLexicon.TYPE_SIMPLE_PROPERTY);
            propNode.setProperty(DerbyDdlLexicon.PROPERTY_VALUE, (Object)sb.toString());
            return true;
        }
        return false;
    }

    private AstNode parseDeclareGlobalTempTable(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        AstNode optionNode;
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_DECLARE_GLOBAL_TEMP_TABLE);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, DerbyDdlLexicon.TYPE_DECLARE_GLOBAL_TEMPORARY_TABLE_STATEMENT);
        this.parseColumnsAndConstraints(tokens, node);
        if (tokens.canConsume("ON", new String[]{"COMMIT"})) {
            optionNode = this.nodeFactory().node("onCommit", node, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
            if (tokens.canConsume("DELETE", new String[]{"ROWS"})) {
                optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"ON COMMIT DELETE ROWS");
            } else {
                tokens.consume("PRESERVE", new String[]{"ROWS"});
                optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"ON COMMIT PRESERVE ROWS");
            }
        }
        tokens.consume("NOT", new String[]{"LOGGED"});
        if (tokens.canConsume("ON", new String[]{"ROLLBACK", "DELETE", "ROWS"})) {
            optionNode = this.nodeFactory().node("onRollback", node, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"ON ROLLBACK DELETE ROWS");
        }
        this.markEndOfStatement(tokens, node);
        return node;
    }

    private AstNode parseLockTable(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_LOCK_TABLE);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, DerbyDdlLexicon.TYPE_LOCK_TABLE_STATEMENT);
        tokens.consume("IN");
        if (tokens.canConsume("SHARE")) {
            AstNode propNode = this.nodeFactory().node("lockMode", node, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
            propNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"SHARE");
        } else {
            tokens.consume("EXCLUSIVE");
            AstNode propNode = this.nodeFactory().node("lockMode", node, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
            propNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"EXCLUSIVE");
        }
        tokens.consume("MODE");
        this.markEndOfStatement(tokens, node);
        return node;
    }

    private AstNode parseRenameTable(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_RENAME_TABLE);
        String oldName = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(oldName, parentNode, DerbyDdlLexicon.TYPE_RENAME_TABLE_STATEMENT);
        tokens.consume("TO");
        String newName = this.parseName(tokens);
        node.setProperty(DerbyDdlLexicon.NEW_NAME, (Object)newName);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    private AstNode parseRenameIndex(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_RENAME_INDEX);
        String oldName = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(oldName, parentNode, DerbyDdlLexicon.TYPE_RENAME_INDEX_STATEMENT);
        tokens.consume("TO");
        String newName = this.parseName(tokens);
        node.setProperty(DerbyDdlLexicon.NEW_NAME, (Object)newName);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    private AstNode parseCreateSynonym(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_SYNONYM);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, DerbyDdlLexicon.TYPE_CREATE_SYNONYM_STATEMENT);
        tokens.consume("FOR");
        String tableOrViewName = this.parseName(tokens);
        node.setProperty(DerbyDdlLexicon.TABLE_NAME, (Object)tableOrViewName);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    private AstNode parseCreateTrigger(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        AstNode optionNode;
        AstNode optionNode2;
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_TRIGGER);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, DerbyDdlLexicon.TYPE_CREATE_TRIGGER_STATEMENT);
        String type = null;
        if (tokens.canConsume("AFTER")) {
            optionNode2 = this.nodeFactory().node("beforeOrAfter", node, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode2.setProperty(DerbyDdlLexicon.VALUE, (Object)"AFTER");
        } else {
            tokens.consume("NO", new String[]{"CASCADE", "BEFORE"});
            optionNode2 = this.nodeFactory().node("beforeOrAfter", node, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode2.setProperty(DerbyDdlLexicon.VALUE, (Object)"NO CASCADE BEFORE");
        }
        if (tokens.canConsume("INSERT")) {
            optionNode2 = this.nodeFactory().node("eventType", node, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode2.setProperty(DerbyDdlLexicon.VALUE, (Object)"INSERT");
            type = "INSERT";
        } else if (tokens.canConsume("DELETE")) {
            optionNode2 = this.nodeFactory().node("eventType", node, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode2.setProperty(DerbyDdlLexicon.VALUE, (Object)"DELETE");
            type = "DELETE";
        } else {
            tokens.consume("UPDATE");
            optionNode2 = this.nodeFactory().node("eventType", node, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode2.setProperty(DerbyDdlLexicon.VALUE, (Object)"UPDATE");
            type = "UPDATE";
        }
        if (tokens.canConsume("OF")) {
            String colName = this.parseName(tokens);
            this.nodeFactory().node(colName, node, DerbyDdlLexicon.TYPE_COLUMN_REFERENCE);
            while (tokens.canConsume(",")) {
                colName = this.parseName(tokens);
                this.nodeFactory().node(colName, node, DerbyDdlLexicon.TYPE_COLUMN_REFERENCE);
            }
        }
        tokens.consume("ON");
        String tableName = this.parseName(tokens);
        node.setProperty(DerbyDdlLexicon.TABLE_NAME, (Object)tableName);
        if (tokens.canConsume("REFERENCING")) {
            StringBuffer sb = new StringBuffer();
            if (tokens.matchesAnyOf("OLD", new String[]{"NEW"})) {
                if (tokens.canConsume("OLD")) {
                    sb.append("OLD");
                } else {
                    tokens.consume("NEW");
                    sb.append("NEW");
                }
                if (tokens.canConsume("ROW")) {
                    sb.append(" ").append("ROW");
                }
                if (tokens.canConsume("AS")) {
                    sb.append(" ").append("AS");
                }
                if (tokens.matchesAnyOf("OLD", new String[]{"NEW"})) {
                    if (tokens.canConsume("OLD")) {
                        sb.append(" ").append("OLD");
                    } else {
                        tokens.consume("NEW");
                        sb.append(" ").append("NEW");
                    }
                    if (tokens.canConsume("ROW")) {
                        sb.append(" ").append("ROW");
                    }
                    if (tokens.canConsume("AS")) {
                        sb.append(" ").append("AS");
                    }
                    if (!tokens.matchesAnyOf("FOR", new String[]{"MODE", type})) {
                        String corrName = this.parseName(tokens);
                        sb.append(" ").append(corrName);
                    }
                } else {
                    String corrName = this.parseName(tokens);
                    sb.append(" ").append(corrName);
                    if (tokens.matchesAnyOf("OLD", new String[]{"NEW"})) {
                        if (tokens.canConsume("OLD")) {
                            sb.append(" ").append("OLD");
                        } else {
                            tokens.consume("NEW");
                            sb.append(" ").append("NEW");
                        }
                        if (tokens.canConsume("ROW")) {
                            sb.append(" ").append("ROW");
                        }
                        if (tokens.canConsume("AS")) {
                            sb.append(" ").append("AS");
                        }
                        if (!tokens.matchesAnyOf("FOR", new String[]{"MODE", type})) {
                            corrName = this.parseName(tokens);
                            sb.append(" ").append(corrName);
                        }
                    }
                }
            }
        }
        if (tokens.canConsume("FOR", new String[]{"EACH"})) {
            if (tokens.canConsume("ROW")) {
                optionNode = this.nodeFactory().node("forEach", node, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
                optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"FOR EACH ROW");
            } else {
                tokens.consume("STATEMENT");
                optionNode = this.nodeFactory().node("forEach", node, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
                optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"FOR EACH STATEMENT");
            }
        }
        if (tokens.canConsume("MODE")) {
            tokens.consume("DB2SQL");
            optionNode = this.nodeFactory().node("mode", node, DerbyDdlLexicon.TYPE_STATEMENT_OPTION);
            optionNode.setProperty(DerbyDdlLexicon.VALUE, (Object)"MODE DB2SQL");
        }
        String sql = this.parseUntilTerminatorIgnoreEmbeddedStatements(tokens);
        node.setProperty(DerbyDdlLexicon.SQL, (Object)sql);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    @Override
    protected List<String> getCustomDataTypeStartWords() {
        return DerbyDdlConstants.DerbyDataTypes.CUSTOM_DATATYPE_START_WORDS;
    }

    class DerbyDataTypeParser
    extends DataTypeParser {
        DerbyDataTypeParser() {
        }

        @Override
        protected boolean isCustomDataType(DdlTokenStream tokens) throws ParsingException {
            for (String[] stmts : derbyDataTypeStrings) {
                if (!tokens.matches(stmts)) continue;
                return true;
            }
            return super.isCustomDataType(tokens);
        }

        @Override
        protected DataType parseApproxNumericType(DdlTokenStream tokens) throws ParsingException {
            return super.parseApproxNumericType(tokens);
        }

        @Override
        protected DataType parseBitStringType(DdlTokenStream tokens) throws ParsingException {
            return super.parseBitStringType(tokens);
        }

        @Override
        protected DataType parseCharStringType(DdlTokenStream tokens) throws ParsingException {
            DataType result = super.parseCharStringType(tokens);
            this.canConsume(tokens, result, true, "FOR", "BIT", "DATA");
            return result;
        }

        @Override
        protected DataType parseCustomType(DdlTokenStream tokens) throws ParsingException {
            DataType dataType = null;
            String typeName = null;
            long length = 0L;
            if (tokens.matches(DerbyDdlConstants.DerbyDataTypes.DTYPE_BINARY_LARGE_OBJECT) || tokens.matches(DerbyDdlConstants.DerbyDataTypes.DTYPE_CHARACTER_LARGE_OBJECT)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true) + " " + this.consume(tokens, dataType, true) + " " + this.consume(tokens, dataType, true);
                if (this.canConsume(tokens, dataType, true, "(", new String[0])) {
                    String lengthValue = this.consume(tokens, dataType, false);
                    length = this.parseLong(lengthValue);
                    this.consume(tokens, dataType, true, ")");
                }
                dataType.setName(typeName);
                dataType.setLength(length);
            } else if (tokens.matches(DerbyDdlConstants.DerbyDataTypes.DTYPE_CLOB) || tokens.matches(DerbyDdlConstants.DerbyDataTypes.DTYPE_BLOB)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true);
                if (this.canConsume(tokens, dataType, true, "(", new String[0])) {
                    String lengthValue = this.consume(tokens, dataType, false);
                    length = this.parseLong(lengthValue);
                    this.consume(tokens, dataType, true, ")");
                }
                dataType.setName(typeName);
                dataType.setLength(length);
            } else if (tokens.matches(DerbyDdlConstants.DerbyDataTypes.DTYPE_BIGINT)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true);
                dataType.setName(typeName);
            } else if (tokens.matches(DerbyDdlConstants.DerbyDataTypes.DTYPE_LONG_VARCHAR_FBD)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true) + " " + this.consume(tokens, dataType, true) + " " + this.consume(tokens, dataType, true) + " " + this.consume(tokens, dataType, true) + " " + this.consume(tokens, dataType, true);
                dataType.setName(typeName);
            } else if (tokens.matches(DerbyDdlConstants.DerbyDataTypes.DTYPE_LONG_VARCHAR)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true) + " " + this.consume(tokens, dataType, true);
                typeName = this.consume(tokens, dataType, true);
                dataType.setName(typeName);
            } else if (tokens.matches(DerbyDdlConstants.DerbyDataTypes.DTYPE_DOUBLE)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true);
                dataType.setName(typeName);
            } else if (tokens.matches(DerbyDdlConstants.DerbyDataTypes.DTYPE_XML)) {
                dataType = new DataType();
                typeName = this.consume(tokens, dataType, true);
                dataType.setName(typeName);
            }
            if (dataType == null) {
                super.parseCustomType(tokens);
            }
            return dataType;
        }

        @Override
        protected DataType parseDateTimeType(DdlTokenStream tokens) throws ParsingException {
            return super.parseDateTimeType(tokens);
        }

        @Override
        protected DataType parseExactNumericType(DdlTokenStream tokens) throws ParsingException {
            return super.parseExactNumericType(tokens);
        }
    }
}

