/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.node;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.util.CheckArg;
import org.modeshape.sequencer.ddl.node.AstNode;

public final class AstNodeFactory {
    public AstNode node(String name) {
        CheckArg.isNotNull((Object)name, (String)"name");
        AstNode node = new AstNode(name);
        node.setProperty("jcr:primaryType", (Object)"nt:unstructured");
        return node;
    }

    public AstNode node(String name, AstNode parent, Object ... types) {
        CheckArg.isNotNull((Object)name, (String)"name");
        CheckArg.isNotNull((Object)parent, (String)"parent");
        CheckArg.isNotEmpty((Object[])types, (String)"types");
        AstNode node = new AstNode(name);
        node.setProperty("jcr:mixinTypes", types);
        node.setProperty("jcr:primaryType", (Object)"nt:unstructured");
        node.setParent(parent);
        return node;
    }

    public AstNode node(String name, AstNode parent, String type) {
        CheckArg.isNotNull((Object)name, (String)"name");
        CheckArg.isNotNull((Object)parent, (String)"parent");
        CheckArg.isNotNull((Object)type, (String)"type");
        AstNode node = new AstNode(name);
        node.setProperty("jcr:mixinTypes", (Object)type);
        node.setProperty("jcr:primaryType", (Object)"nt:unstructured");
        node.setParent(parent);
        return node;
    }

    public void setType(AstNode node, String type) {
        CheckArg.isNotNull((Object)node, (String)"node");
        CheckArg.isNotNull((Object)type, (String)"parent");
        node.setProperty("jcr:mixinTypes", (Object)type);
    }

    public List<AstNode> getChildrenForType(AstNode astNode, String nodeType) {
        CheckArg.isNotNull((Object)astNode, (String)"astNode");
        CheckArg.isNotNull((Object)nodeType, (String)"nodeType");
        ArrayList<AstNode> childrenOfType = new ArrayList<AstNode>();
        for (AstNode child : astNode.getChildren()) {
            if (!this.hasMixinType(child, nodeType)) continue;
            childrenOfType.add(child);
        }
        return childrenOfType;
    }

    public AstNode getChildforNameAndType(AstNode astNode, String name, String nodeType) {
        CheckArg.isNotNull((Object)astNode, (String)"astNode");
        CheckArg.isNotNull((Object)name, (String)"name");
        CheckArg.isNotNull((Object)nodeType, (String)"nodeType");
        for (AstNode child : astNode.getChildren()) {
            if (!this.hasMixinType(child, nodeType) || !name.equalsIgnoreCase(child.getName())) continue;
            return child;
        }
        return null;
    }

    public boolean hasMixinType(AstNode node, String mixinType) {
        CheckArg.isNotNull((Object)node, (String)"node");
        CheckArg.isNotNull((Object)mixinType, (String)"mixinType");
        return node.getMixins().contains(mixinType);
    }
}

