/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.text.TokenStream;
import org.modeshape.sequencer.ddl.DdlParserProblem;
import org.modeshape.sequencer.ddl.DdlParserScorer;
import org.modeshape.sequencer.ddl.DdlParserTestHelper;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.node.AstNode;

public class StandardDdlParserTest
extends DdlParserTestHelper {
    public static final String DDL_FILE_PATH = "ddl/";

    @Before
    public void beforeEach() {
        this.parser = new StandardDdlParser();
        this.setPrintToConsole(false);
        this.parser.setTestMode(this.isPrintToConsole());
        this.rootNode = this.parser.nodeFactory().node("ddlRootNode");
        this.parser.setRootNode(this.rootNode);
        this.scorer = new DdlParserScorer();
    }

    @After
    public void afterEach() {
        this.rootNode.removeAllChildren();
        this.rootNode = null;
        this.parser = null;
    }

    private DdlTokenStream getTokens(String content) {
        DdlTokenStream tokens = new DdlTokenStream(content, (TokenStream.Tokenizer)DdlTokenStream.ddlTokenizer((boolean)true), false);
        tokens.start();
        return tokens;
    }

    private void printNodeChildren(AstNode node) {
        if (this.isPrintToConsole()) {
            int count = 1;
            for (AstNode childNode : node.getChildren()) {
                System.out.println("NODE(" + count++ + ")  NAME = " + childNode.getName());
            }
        }
    }

    @Test
    public void shouldParseName() {
        this.printTest("shouldParseName()");
        String content = "simpleName";
        String targetName = "simpleName";
        DdlTokenStream tokens = this.getTokens(content);
        String result = this.parser.parseName(tokens);
        Assert.assertEquals((Object)targetName, (Object)result);
        content = "schema_name.table_name";
        targetName = "schema_name.table_name";
        tokens = this.getTokens(content);
        result = this.parser.parseName(tokens);
        Assert.assertEquals((Object)targetName, (Object)result);
        content = "[schema_name].[table_name]";
        targetName = "schema_name.table_name";
        tokens = this.getTokens(content);
        result = this.parser.parseName(tokens);
        Assert.assertEquals((Object)targetName, (Object)result);
        content = "[schema_name].[\"COLUMN\"]";
        targetName = "schema_name.COLUMN";
        tokens = this.getTokens(content);
        result = this.parser.parseName(tokens);
        Assert.assertEquals((Object)targetName, (Object)result);
        content = "\"_RETURN\"";
        targetName = "_RETURN";
        tokens = this.getTokens(content);
        result = this.parser.parseName(tokens);
        Assert.assertEquals((Object)targetName, (Object)result);
    }

    @Test
    public void isTableConstraint() {
        this.printTest("isTableConstraint()");
        String content = "PRIMARY KEY";
        DdlTokenStream tokens = this.getTokens(content);
        boolean result = this.parser.isTableConstraint(tokens);
        Assert.assertTrue((boolean)result);
        content = "FOREIGN KEY";
        tokens = this.getTokens(content);
        result = this.parser.isTableConstraint(tokens);
        Assert.assertTrue((boolean)result);
        content = "UNIQUE";
        tokens = this.getTokens(content);
        result = this.parser.isTableConstraint(tokens);
        Assert.assertTrue((boolean)result);
        content = "CONSTRAINT constraint_name PRIMARY KEY";
        tokens = this.getTokens(content);
        result = this.parser.isTableConstraint(tokens);
        Assert.assertTrue((boolean)result);
        content = "CONSTRAINT constraint_name FOREIGN KEY";
        tokens = this.getTokens(content);
        result = this.parser.isTableConstraint(tokens);
        Assert.assertTrue((boolean)result);
        content = "CONSTRAINT constraint_name UNIQUE";
        tokens = this.getTokens(content);
        result = this.parser.isTableConstraint(tokens);
        Assert.assertTrue((boolean)result);
        content = "XXXXX";
        tokens = this.getTokens(content);
        result = this.parser.isTableConstraint(tokens);
        Assert.assertFalse((boolean)result);
        content = "CONSTRAINT constraint_name XXXXX";
        tokens = this.getTokens(content);
        result = this.parser.isTableConstraint(tokens);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldParseCreateStatement() {
        this.printTest("shouldParseCreateStatement()");
        String content = "CREATE TABLE EQPT_TYPE ( CAT_CODE CHAR(7) NOT NULL);";
        Object result = this.parser.score(content, null, this.scorer);
        this.parser.parse(content, this.rootNode, result);
    }

    @Test
    public void shouldParseCreateBogusStatement() {
        this.printTest("shouldParseCreateBogusStatement()");
        String content = "CREATE TABLE myTable (PART_COLOR varchar(255) NOT NULL DEFAULT BLUE, PRIMARY KEY (PART_COLOR), PART_ID int NOT NULL DEFAULT (1000));CREATE BOGUS more JUNK after this JUNK;CREATE LOCAL TEMPORARY TABLE yourTable (PART_COLOR varchar(255) NOT NULL DEFAULT BLUE);";
        this.parser.setDoUseTerminator(true);
        Object result = this.parser.score(content, null, this.scorer);
        this.parser.parse(content, this.rootNode, result);
        this.printNodeChildren(this.rootNode);
        Assert.assertEquals((long)0L, (long)this.parser.getProblems().size());
        Assert.assertEquals((long)3L, (long)this.rootNode.getChildCount());
        AstNode tableNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(tableNode, "ddl:createTableStatement"));
        Assert.assertEquals((Object)"myTable", (Object)tableNode.getName());
        Assert.assertEquals((long)3L, (long)tableNode.getChildCount());
    }

    @Test
    public void shouldParseCreateStatementWithUnusedTokens() {
        this.printTest("shouldParseCreateStatementWithUnusedTokens()");
        String content = "CREATE TABLE myTable (PART_COLOR varchar(255) NOT NULL DEFAULT BLUE BOGUS TOKENS, PRIMARY KEY (PART_COLOR), PART_ID int NOT NULL DEFAULT (1000));";
        this.parser.setDoUseTerminator(true);
        Object result = this.parser.score(content, null, this.scorer);
        this.parser.parse(content, this.rootNode, result);
        this.printNodeChildren(this.rootNode);
        Assert.assertEquals((long)2L, (long)this.rootNode.getChildCount());
        AstNode tableNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(tableNode, "ddl:createTableStatement"));
        Assert.assertEquals((Object)"myTable", (Object)tableNode.getName());
        Assert.assertEquals((long)4L, (long)tableNode.getChildCount());
        Assert.assertEquals((long)1L, (long)this.parser.getProblems().size());
        Assert.assertTrue((boolean)((DdlParserProblem)this.parser.getProblems().get(0)).getMessage().startsWith("The following unused tokens were found"));
    }

    @Test
    public void shouldParseAlterTableDefinitionAddConstraintFK() {
        this.printTest("shouldParseAlterTableDefinition_1()");
        String content = "ALTER TABLE table_name_14 ADD CONSTRAINT fk_name FOREIGN KEY (ref_col_name) REFERENCES ref_table_name(ref_table_column_name);";
        Object result = this.parser.score(content, null, this.scorer);
        this.parser.parse(content, this.rootNode, result);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode alterTableNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(alterTableNode, "ddl:alterTableStatement"));
        Assert.assertEquals((Object)"table_name_14", (Object)alterTableNode.getName());
        Assert.assertEquals((long)1L, (long)alterTableNode.getChildCount());
        AstNode constraintNode = alterTableNode.getChild(0);
        Assert.assertEquals((Object)"fk_name", (Object)constraintNode.getName());
        Assert.assertEquals((Object)"FOREIGN KEY", (Object)constraintNode.getProperty("ddl:constraintType").toString());
        Assert.assertTrue((boolean)this.hasMixinType(constraintNode, "ddl:addTableConstraintDefinition"));
        Assert.assertEquals((long)3L, (long)constraintNode.getChildCount());
    }

    @Test
    public void shouldParseCreateSchemaWithNestedTable() {
        this.printTest("shouldParseSchemaDefinitionStatements()");
        String content = "CREATE SCHEMA hollywood \n      CREATE TABLE films (title varchar(255), release date, producerName varchar(255))\n      GRANT SELECT ON TABLE films TO producer_role       CREATE VIEW winners AS\n              SELECT title, release FROM films WHERE producerName IS NOT NULL;";
        Object result = this.parser.score(content, null, this.scorer);
        this.parser.parse(content, this.rootNode, result);
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        List schemaNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:createSchemaStatement");
        Assert.assertThat((Object)schemaNodes.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((AstNode)schemaNodes.get(0)).getChildCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)((AstNode)schemaNodes.get(0)).getName(), (Matcher)Is.is((Object)"hollywood"));
        List tableNodes = this.parser.nodeFactory().getChildrenForType((AstNode)schemaNodes.get(0), "ddl:createTableStatement");
        Assert.assertThat((Object)tableNodes.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((AstNode)tableNodes.get(0)).getName(), (Matcher)Is.is((Object)"films"));
        List viewNodes = this.parser.nodeFactory().getChildrenForType((AstNode)schemaNodes.get(0), "ddl:createViewStatement");
        Assert.assertThat((Object)viewNodes.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((AstNode)viewNodes.get(0)).getName(), (Matcher)Is.is((Object)"winners"));
        List columnNodes = this.parser.nodeFactory().getChildrenForType((AstNode)tableNodes.get(0), "ddl:columnDefinition");
        Assert.assertThat((Object)columnNodes.size(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldParseSchemaDefinitionStatements() {
        this.printTest("shouldParseSchemaDefinitionStatements()");
        String content = this.getFileContent("ddl/schema_definition.ddl");
        Object result = this.parser.score(content, "schema_definition.ddl", this.scorer);
        this.parser.parse(content, this.rootNode, result);
        Assert.assertEquals((long)13L, (long)this.rootNode.getChildCount());
        List schemaNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:createSchemaStatement");
        Assert.assertEquals((long)5L, (long)schemaNodes.size());
    }

    @Test
    public void shouldParseSchemaManipulationStatements() {
        this.printTest("shouldParseSchemaManipulationStatements()");
        String content = this.getFileContent("ddl/schema_manipulation.ddl");
        Object result = this.parser.score(content, "schema_manipulation.ddl", this.scorer);
        this.parser.parse(content, this.rootNode, result);
        Assert.assertEquals((long)31L, (long)this.rootNode.getChildCount());
        List theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:alterTableStatement");
        Assert.assertEquals((long)14L, (long)theNodes.size());
        theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:dropTableStatement");
        Assert.assertEquals((long)2L, (long)theNodes.size());
    }

    @Test
    public void shouldParseTableDefinitionStatements() {
        this.printTest("shouldParseTableDefinitionStatements()");
        String content = this.getFileContent("ddl/table_definition.ddl");
        Object result = this.parser.score(content, "table_definition.ddl", this.scorer);
        this.parser.parse(content, this.rootNode, result);
    }

    @Test
    public void shoudParseUntilTerminated() {
        this.printTest("shoudParseUntilTerminated()");
        String prefix = " ( COL_SUM, COL_DIFF ) AS SELECT COMM + BONUS, COMM - BONUS FROM SAMP.EMPLOYEE";
        String content = prefix + "; CREATE TABLE someName";
        DdlTokenStream tokens = this.getTokens(content);
        String result = this.parser.parseUntilTerminator(tokens);
        this.printTest(result);
        Assert.assertEquals((Object)prefix, (Object)result);
    }

    @Test
    public void shouldParseColumnDefinition() {
        this.printTest("shouldParseColumnDefinition()");
        String content = "PARTID VARCHAR (255) NOT NULL DEFAULT '12345'";
        DdlTokenStream tokens = this.getTokens(content);
        AstNode tableNode = this.parser.nodeFactory().node("PARTID", this.rootNode, new Object[]{"ddl:createTableStatement", this.rootNode});
        this.parser.setRootNode(this.rootNode);
        this.parser.parseColumnDefinition(tokens, tableNode, false);
        Assert.assertEquals((long)1L, (long)tableNode.getChildCount());
        AstNode column = (AstNode)tableNode.getChildren().get(0);
        Assert.assertEquals((Object)"VARCHAR", (Object)column.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)255L, (Object)column.getProperty("ddl:datatypeLength"));
        Assert.assertTrue((column.getProperty("ddl:datatypePrecision") == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"NOT NULL", (Object)column.getProperty("ddl:nullable"));
        Assert.assertEquals((Object)"LITERAL", (Object)column.getProperty("ddl:defaultOption"));
        Assert.assertEquals((Object)"'12345'", (Object)column.getProperty("ddl:defaultValue"));
        tableNode.removeAllChildren();
        content = "PARTID CHARACTER (255) NULL DEFAULT (12345)";
        tokens = this.getTokens(content);
        this.parser.parseColumnDefinition(tokens, tableNode, false);
        Assert.assertEquals((long)1L, (long)tableNode.getChildCount());
        column = (AstNode)tableNode.getChildren().get(0);
        Assert.assertEquals((Object)"CHARACTER", (Object)column.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)255L, (Object)column.getProperty("ddl:datatypeLength"));
        Assert.assertTrue((column.getProperty("ddl:datatypePrecision") == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"NULL", (Object)column.getProperty("ddl:nullable"));
        Assert.assertEquals((Object)"LITERAL", (Object)column.getProperty("ddl:defaultOption"));
        Assert.assertEquals((Object)"12345", (Object)column.getProperty("ddl:defaultValue"));
        tableNode.removeAllChildren();
        content = "PARTID DECIMAL (6, 2) DEFAULT (6.213)";
        tokens = this.getTokens(content);
        this.parser.parseColumnDefinition(tokens, tableNode, false);
        Assert.assertEquals((long)1L, (long)tableNode.getChildCount());
        column = (AstNode)tableNode.getChildren().get(0);
        Assert.assertEquals((Object)"DECIMAL", (Object)column.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)6, (Object)column.getProperty("ddl:datatypePrecision"));
        Assert.assertEquals((Object)2, (Object)column.getProperty("ddl:datatypeScale"));
        Assert.assertTrue((column.getProperty("ddl:datatypeLength") == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"LITERAL", (Object)column.getProperty("ddl:defaultOption"));
        Assert.assertEquals((Object)"6.213", (Object)column.getProperty("ddl:defaultValue"));
    }

    @Test
    @FixFor(value={"MODE-820"})
    public void shouldParseColumnDefinitionWithKilobyteInSize() {
        this.printTest("shouldParseColumnDefinitionWithKilobyteInSize()");
        String content = "PARTID CHAR(2K) NOT NULL";
        DdlTokenStream tokens = this.getTokens(content);
        AstNode tableNode = this.parser.nodeFactory().node("PARTID", this.rootNode, new Object[]{"ddl:createTableStatement", this.rootNode});
        this.parser.setRootNode(this.rootNode);
        this.parser.parseColumnDefinition(tokens, tableNode, false);
        Assert.assertEquals((long)1L, (long)tableNode.getChildCount());
        AstNode column = (AstNode)tableNode.getChildren().get(0);
        Assert.assertEquals((Object)"CHAR", (Object)column.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)2048L, (Object)column.getProperty("ddl:datatypeLength"));
        Assert.assertTrue((column.getProperty("ddl:datatypePrecision") == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"NOT NULL", (Object)column.getProperty("ddl:nullable"));
        tableNode.removeAllChildren();
    }

    @Test
    @FixFor(value={"MODE-820"})
    public void shouldParseColumnDefinitionWithMegabyteInSize() {
        this.printTest("shouldParseColumnDefinitionWithKilobyteInSize()");
        String content = "PARTID CHAR(4M) NOT NULL";
        DdlTokenStream tokens = this.getTokens(content);
        AstNode tableNode = this.parser.nodeFactory().node("PARTID", this.rootNode, new Object[]{"ddl:createTableStatement", this.rootNode});
        this.parser.setRootNode(this.rootNode);
        this.parser.parseColumnDefinition(tokens, tableNode, false);
        Assert.assertEquals((long)1L, (long)tableNode.getChildCount());
        AstNode column = (AstNode)tableNode.getChildren().get(0);
        Assert.assertEquals((Object)"CHAR", (Object)column.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)0x400000L, (Object)column.getProperty("ddl:datatypeLength"));
        Assert.assertTrue((column.getProperty("ddl:datatypePrecision") == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"NOT NULL", (Object)column.getProperty("ddl:nullable"));
        tableNode.removeAllChildren();
    }

    @Test
    @FixFor(value={"MODE-820"})
    public void shouldParseColumnDefinitionWithGigabyteInSize() {
        this.printTest("shouldParseColumnDefinitionWithKilobyteInSize()");
        String content = "PARTID CHAR(5G) NOT NULL";
        DdlTokenStream tokens = this.getTokens(content);
        AstNode tableNode = this.parser.nodeFactory().node("PARTID", this.rootNode, new Object[]{"ddl:createTableStatement", this.rootNode});
        this.parser.setRootNode(this.rootNode);
        this.parser.parseColumnDefinition(tokens, tableNode, false);
        Assert.assertEquals((long)1L, (long)tableNode.getChildCount());
        AstNode column = (AstNode)tableNode.getChildren().get(0);
        Assert.assertEquals((Object)"CHAR", (Object)column.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)0x140000000L, (Object)column.getProperty("ddl:datatypeLength"));
        Assert.assertTrue((column.getProperty("ddl:datatypePrecision") == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"NOT NULL", (Object)column.getProperty("ddl:nullable"));
        tableNode.removeAllChildren();
    }

    @Test
    public void shouldGetTableElementString() {
        this.printTest("shouldGetTableElementString()");
        String content = "(PARTID VARCHAR (255) NOT NULL DEFAULT (100),  -- COLUMN 1 COMMENT with comma \nPARTCOLOR INTEGER NOT NULL)";
        DdlTokenStream tokens = this.getTokens(content);
        String result = this.parser.getTableElementsString(tokens, false);
        this.printResult("   STRING = " + result);
    }

    @Test
    public void shouldParseCreateTable() {
        this.printTest("shouldParseCreateTable()");
        String content = "CREATE TABLE MY_TABLE_A (PARTID VARCHAR (255) NOT NULL DEFAULT (100),  -- COLUMN 1 COMMENT with comma \nPARTCOLOR INTEGER NOT NULL) ON COMMIT DELETE ROWS;";
        DdlTokenStream tokens = this.getTokens(content);
        this.parser.setRootNode(this.rootNode);
        AstNode result = this.parser.parseCreateTableStatement(tokens, this.rootNode);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode tableNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)tableNode));
        Assert.assertEquals((Object)"MY_TABLE_A", (Object)tableNode.getName());
        Assert.assertEquals((long)3L, (long)tableNode.getChildCount());
        AstNode column = (AstNode)tableNode.getChildren().get(0);
        Assert.assertEquals((Object)"PARTID", (Object)column.getName());
        Assert.assertEquals((Object)"VARCHAR", (Object)column.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)255L, (Object)column.getProperty("ddl:datatypeLength"));
        Assert.assertTrue((column.getProperty("ddl:datatypePrecision") == null ? 1 : 0) != 0);
        List tableOptions = this.parser.nodeFactory().getChildrenForType(tableNode, "ddl:statementOption");
        Assert.assertEquals((long)1L, (long)tableOptions.size());
        Assert.assertEquals((Object)"ON COMMIT DELETE ROWS", (Object)((AstNode)tableOptions.get(0)).getProperty("ddl:value"));
    }

    @Test
    @FixFor(value={"MODE-820"})
    public void shouldParseCreateTableWithKilobyteInSize() {
        this.printTest("shouldParseCreateTableWithKilobyteInSize()");
        String content = "CREATE TABLE MY_TABLE_A (PARTID CHAR (2K) NOT NULL,  -- COLUMN 1 COMMENT with comma \nPARTCOLOR CHAR(4M) NOT NULL) ON COMMIT DELETE ROWS;";
        DdlTokenStream tokens = this.getTokens(content);
        this.parser.setRootNode(this.rootNode);
        AstNode result = this.parser.parseCreateTableStatement(tokens, this.rootNode);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode tableNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)tableNode));
        Assert.assertEquals((Object)"MY_TABLE_A", (Object)tableNode.getName());
        Assert.assertEquals((long)3L, (long)tableNode.getChildCount());
        AstNode column1 = (AstNode)tableNode.getChildren().get(0);
        Assert.assertEquals((Object)"PARTID", (Object)column1.getName());
        Assert.assertEquals((Object)"CHAR", (Object)column1.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)2048L, (Object)column1.getProperty("ddl:datatypeLength"));
        Assert.assertTrue((column1.getProperty("ddl:datatypePrecision") == null ? 1 : 0) != 0);
        AstNode column2 = (AstNode)tableNode.getChildren().get(1);
        Assert.assertEquals((Object)"PARTCOLOR", (Object)column2.getName());
        Assert.assertEquals((Object)"CHAR", (Object)column2.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)0x400000L, (Object)column2.getProperty("ddl:datatypeLength"));
        Assert.assertTrue((column2.getProperty("ddl:datatypePrecision") == null ? 1 : 0) != 0);
        List tableOptions = this.parser.nodeFactory().getChildrenForType(tableNode, "ddl:statementOption");
        Assert.assertEquals((long)1L, (long)tableOptions.size());
        Assert.assertEquals((Object)"ON COMMIT DELETE ROWS", (Object)((AstNode)tableOptions.get(0)).getProperty("ddl:value"));
    }

    @Test
    public void shouldParseNextTableOption() {
        this.printTest("shouldParseNextTableOption()");
        String content = "ON COMMIT PRESERVE ROWS";
        DdlTokenStream tokens = this.getTokens(content);
        AstNode tableNode = this.parser.nodeFactory().node("PARTS_COLOR", this.rootNode, "ddl:createTableStatement");
        this.parser.parseNextCreateTableOption(tokens, tableNode);
        List options = this.parser.nodeFactory().getChildrenForType(tableNode, "ddl:statementOption");
        Assert.assertEquals((long)1L, (long)options.size());
        Assert.assertEquals((Object)content, (Object)((AstNode)options.get(0)).getProperty("ddl:value"));
        tableNode.removeAllChildren();
        content = "ON COMMIT DELETE ROWS";
        tokens = this.getTokens(content);
        this.parser.parseNextCreateTableOption(tokens, tableNode);
        options = this.parser.nodeFactory().getChildrenForType(tableNode, "ddl:statementOption");
        Assert.assertEquals((long)1L, (long)options.size());
        Assert.assertEquals((Object)content, (Object)((AstNode)options.get(0)).getProperty("ddl:value"));
        tableNode.removeAllChildren();
        content = "ON COMMIT DROP";
        tokens = this.getTokens(content);
        this.parser.parseNextCreateTableOption(tokens, tableNode);
        options = this.parser.nodeFactory().getChildrenForType(tableNode, "ddl:statementOption");
        Assert.assertEquals((long)1L, (long)options.size());
        Assert.assertEquals((Object)content, (Object)((AstNode)options.get(0)).getProperty("ddl:value"));
        tableNode.removeAllChildren();
    }

    @Test
    public void shouldAreNextTokensCreateTableOptions() {
        this.printTest("shouldAreNextTokensCreateTableOptions()");
        String content = "ON COMMIT PRESERVE ROWS";
        DdlTokenStream tokens = this.getTokens(content);
        Assert.assertTrue((boolean)this.parser.areNextTokensCreateTableOptions(tokens));
        content = "OFF COMMIT PRESERVE ROWS";
        tokens = this.getTokens(content);
        Assert.assertFalse((boolean)this.parser.areNextTokensCreateTableOptions(tokens));
    }

    @Test
    public void shouldParseConstraintAttributes() {
        this.printTest("shouldParseConstraintAttributes()");
        String content = "INITIALLY DEFERRED";
        DdlTokenStream tokens = this.getTokens(content);
        AstNode constraintNode = this.parser.nodeFactory().node("FK_1", this.rootNode, "ddl:tableConstraint");
        this.parser.parseConstraintAttributes(tokens, constraintNode);
        Assert.assertEquals((long)1L, (long)constraintNode.getChildCount());
        List attributes = this.parser.nodeFactory().getChildrenForType(constraintNode, "ddl:constraintAttribute");
        Assert.assertEquals((long)1L, (long)attributes.size());
        Assert.assertEquals((Object)content, (Object)((AstNode)attributes.get(0)).getProperty("ddl:propValue"));
        constraintNode.removeAllChildren();
        content = "INITIALLY IMMEDIATE DEFERRABLE";
        tokens = this.getTokens(content);
        this.parser.parseConstraintAttributes(tokens, constraintNode);
        Assert.assertEquals((long)2L, (long)constraintNode.getChildCount());
        attributes = this.parser.nodeFactory().getChildrenForType(constraintNode, "ddl:constraintAttribute");
        Assert.assertEquals((long)2L, (long)attributes.size());
        Assert.assertEquals((Object)"INITIALLY IMMEDIATE", (Object)((AstNode)attributes.get(0)).getProperty("ddl:propValue"));
        Assert.assertEquals((Object)"DEFERRABLE", (Object)((AstNode)attributes.get(1)).getProperty("ddl:propValue"));
        constraintNode.removeAllChildren();
        content = "NOT DEFERRABLE INITIALLY IMMEDIATE";
        tokens = this.getTokens(content);
        this.parser.parseConstraintAttributes(tokens, constraintNode);
        Assert.assertEquals((long)2L, (long)constraintNode.getChildCount());
        attributes = this.parser.nodeFactory().getChildrenForType(constraintNode, "ddl:constraintAttribute");
        Assert.assertEquals((long)2L, (long)attributes.size());
        Assert.assertEquals((Object)"NOT DEFERRABLE", (Object)((AstNode)attributes.get(0)).getProperty("ddl:propValue"));
        Assert.assertEquals((Object)"INITIALLY IMMEDIATE", (Object)((AstNode)attributes.get(1)).getProperty("ddl:propValue"));
        constraintNode.removeAllChildren();
    }

    @Test
    public void shouldParseColumnsAndConstraints() {
        this.printTest("shouldParseColumnsAndConstraints()");
        String content = "(PART_COLOR varchar(255) NOT NULL DEFAULT BLUE, PRIMARY KEY (PART_COLOR), PART_ID int NOT NULL DEFAULT (1000), FOREIGN KEY FK_SUPPLIER REFERENCES SUPPLIERS (SUPPLIER_ID, SUPPLIER_NAME) );";
        DdlTokenStream tokens = this.getTokens(content);
        AstNode tableNode = this.parser.nodeFactory().node("PART_COLOR", this.rootNode, "ddl:createTableStatement");
        this.parser.parseColumnsAndConstraints(tokens, tableNode);
        Assert.assertEquals((long)4L, (long)tableNode.getChildCount());
        AstNode column = this.parser.nodeFactory().getChildforNameAndType(tableNode, "PART_COLOR", "ddl:columnDefinition");
        Assert.assertNotNull((Object)column);
        Assert.assertEquals((Object)"VARCHAR", (Object)column.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)255L, (Object)column.getProperty("ddl:datatypeLength"));
        Assert.assertTrue((column.getProperty("ddl:datatypePrecision") == null ? 1 : 0) != 0);
        Assert.assertTrue((column.getProperty("ddl:datatypeScale") == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"NOT NULL", (Object)column.getProperty("ddl:nullable"));
        Assert.assertEquals((Object)"LITERAL", (Object)column.getProperty("ddl:defaultOption"));
        Assert.assertEquals((Object)"BLUE", (Object)column.getProperty("ddl:defaultValue"));
        AstNode foreignKeyNode = this.parser.nodeFactory().getChildforNameAndType(tableNode, "FK_SUPPLIER", "ddl:tableConstraint");
        Assert.assertEquals((Object)"FOREIGN KEY", (Object)foreignKeyNode.getProperty("ddl:constraintType"));
        Assert.assertEquals((long)3L, (long)foreignKeyNode.getChildCount());
    }

    @Test
    public void shouldParseCreateLocalTemporaryTable() {
        this.printTest("shouldParseCreateLocalTemporaryTable()");
        String tableName = "MY_TABLE_A";
        String content = "CREATE LOCAL TEMPORARY TABLE MY_TABLE_A (PARTID VARCHAR (255) NOT NULL DEFAULT (100),  -- COLUMN 1 COMMENT with comma \nPARTCOLOR INTEGER NOT NULL);";
        DdlTokenStream tokens = this.getTokens(content);
        AstNode result = this.parser.parseCreateTableStatement(tokens, this.rootNode);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode tableNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)tableNode));
        Assert.assertEquals((Object)tableName, (Object)tableNode.getName());
        Assert.assertEquals((long)2L, (long)tableNode.getChildCount());
        AstNode column = (AstNode)tableNode.getChildren().get(0);
        Assert.assertEquals((Object)"VARCHAR", (Object)column.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)255L, (Object)column.getProperty("ddl:datatypeLength"));
        Assert.assertTrue((column.getProperty("ddl:datatypePrecision") == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"NOT NULL", (Object)column.getProperty("ddl:nullable"));
        Assert.assertEquals((Object)"LITERAL", (Object)column.getProperty("ddl:defaultOption"));
        Assert.assertEquals((Object)"100", (Object)column.getProperty("ddl:defaultValue"));
    }

    @Test
    public void shouldParseCreateTableWithConstraint() {
        this.printTest("shouldParseCreateTableWithConstraint()");
        String tableName = "MY_TABLE_B";
        String content = "CREATE TABLE MY_TABLE_B (PARTID VARCHAR (255), PRIMARY KEY (C1, C2), \nPARTCOLOR INTEGER NOT NULL, CONSTRAINT PK_A PRIMARY KEY (FILE_UID) );";
        DdlTokenStream tokens = this.getTokens(content);
        AstNode result = this.parser.parseCreateTableStatement(tokens, this.rootNode);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode tableNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)tableNode));
        Assert.assertEquals((Object)tableName, (Object)tableNode.getName());
        Assert.assertEquals((long)4L, (long)tableNode.getChildCount());
        AstNode column1 = (AstNode)tableNode.getChildren().get(0);
        Assert.assertEquals((Object)"VARCHAR", (Object)column1.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)255L, (Object)column1.getProperty("ddl:datatypeLength"));
        Assert.assertTrue((column1.getProperty("ddl:datatypePrecision") == null ? 1 : 0) != 0);
    }

    @Test
    public void shouldParseCreateTableWithInlineConstraint() {
        this.printTest("shouldParseCreateTableWithInlineConstraint()");
        String tableName = "table_name_22_B";
        String content = "CREATE TABLE table_name_22_B ( column_name_1 VARCHAR(255) CONSTRAINT pk_name UNIQUE INITIALLY IMMEDIATE);";
        DdlTokenStream tokens = this.getTokens(content);
        AstNode result = this.parser.parseCreateTableStatement(tokens, this.rootNode);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode tableNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)tableNode));
        Assert.assertEquals((Object)tableName, (Object)tableNode.getName());
        Assert.assertEquals((long)2L, (long)tableNode.getChildCount());
        AstNode column = (AstNode)tableNode.getChildren().get(0);
        Assert.assertEquals((Object)"VARCHAR", (Object)column.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)255L, (Object)column.getProperty("ddl:datatypeLength"));
        Assert.assertTrue((column.getProperty("ddl:datatypePrecision") == null ? 1 : 0) != 0);
    }

    @Test
    public void shouldParseCreateTableWithInlineUniqueConstraint() {
        this.printTest("shouldParseCreateTableWithInlineUniqueConstraint()");
        String tableName = "table_name_22_B";
        String content = "CREATE TABLE table_name_22_B ( REALMUID     NUMERIC(10) NOT NULL CONSTRAINT PK_AUTHREALMS UNIQUE);";
        DdlTokenStream tokens = this.getTokens(content);
        AstNode result = this.parser.parseCreateTableStatement(tokens, this.rootNode);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode tableNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)tableNode));
        Assert.assertEquals((Object)tableName, (Object)tableNode.getName());
        Assert.assertEquals((long)2L, (long)tableNode.getChildCount());
        AstNode column = (AstNode)tableNode.getChildren().get(0);
        Assert.assertEquals((Object)"NUMERIC", (Object)column.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)10, (Object)column.getProperty("ddl:datatypePrecision"));
        Assert.assertTrue((column.getProperty("ddl:datatypeLength") == null ? 1 : 0) != 0);
        AstNode prim_key = (AstNode)tableNode.getChildren().get(1);
        AstNode columnRef = (AstNode)prim_key.getChildren().get(0);
        Assert.assertEquals((Object)"REALMUID", (Object)columnRef.getName());
    }

    @Test
    public void shouldParseCreateTableWithPrimaryKeyColumnConstraint() {
        this.printTest("shouldWork()");
        String PK_COL = "customerfamilyhistoryid";
        String content = "CREATE TABLE CustomerFamilyHistory (";
        content = content + PK_COL + " numeric(10) CONSTRAINT customerfamilyhistoryid_pk PRIMARY KEY, firstname varchar(50) NOT NULL, lastname varchar(50) NOT NULL, age numeric(3), sibling varchar(20), customerid numeric(7) NOT NULL);";
        DdlTokenStream tokens = this.getTokens(content);
        AstNode result = this.parser.parseCreateTableStatement(tokens, this.rootNode);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode tableNode = this.rootNode.getChild(0);
        Assert.assertEquals((long)7L, (long)tableNode.getChildCount());
        boolean foundConstraint = false;
        for (AstNode kid : tableNode.getChildren()) {
            Object value = kid.getProperty("ddl:constraintType");
            if (value == null) continue;
            Assert.assertFalse((boolean)foundConstraint);
            foundConstraint = true;
            Assert.assertEquals((Object)value, (Object)"PRIMARY KEY");
            Assert.assertEquals((long)1L, (long)kid.getChildCount());
            AstNode child = kid.getChild(0);
            Assert.assertTrue((boolean)this.hasMixinType(child, "ddl:columnReference"));
            Assert.assertEquals((Object)PK_COL, (Object)child.getName());
        }
    }

    @Test
    public void shouldParseCreateTableWithInlineUniqueConstraintWithColumns() {
        this.printTest("shouldParseCreateTableWithInlineUniqueConstraint()");
        String tableName = "table_name_24_B";
        String content = "CREATE TABLE table_name_24_B ( REALMUID     NUMERIC(10) NOT NULL CONSTRAINT PK_AUTHREALMS UNIQUE (columnA, columnB));";
        DdlTokenStream tokens = this.getTokens(content);
        AstNode result = this.parser.parseCreateTableStatement(tokens, this.rootNode);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode tableNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)tableNode));
        Assert.assertEquals((Object)tableName, (Object)tableNode.getName());
        Assert.assertEquals((long)2L, (long)tableNode.getChildCount());
        AstNode column = (AstNode)tableNode.getChildren().get(0);
        Assert.assertEquals((Object)"NUMERIC", (Object)column.getProperty("ddl:datatypeName"));
        Assert.assertEquals((Object)10, (Object)column.getProperty("ddl:datatypePrecision"));
        Assert.assertTrue((column.getProperty("ddl:datatypeLength") == null ? 1 : 0) != 0);
        AstNode prim_key = (AstNode)tableNode.getChildren().get(1);
        Assert.assertEquals((long)2L, (long)prim_key.getChildCount());
        AstNode columnRef = (AstNode)prim_key.getChildren().get(0);
        Assert.assertEquals((Object)"columnA", (Object)columnRef.getName());
    }

    @Test
    @FixFor(value={"MODE-817"})
    public void shouldParseAlterTables() {
        this.printTest("shouldParseAlterTables()");
        String content = this.getFileContent("ddl/alterTables.ddl");
        this.assertScoreAndParse(content, "alterTables.ddl", 31);
        List theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:createTableStatement");
        Assert.assertThat((Object)theNodes.size(), (Matcher)Is.is((Object)0));
        theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:alterTableStatement");
        Assert.assertThat((Object)theNodes.size(), (Matcher)Is.is((Object)13));
    }

    @Test
    public void shouldParseCreateTables() {
        this.printTest("shouldParseCreateTables()");
        String content = this.getFileContent("ddl/createTables.ddl");
        this.assertScoreAndParse(content, "createTables.ddl", 20);
        List theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:createTableStatement");
        Assert.assertThat((Object)theNodes.size(), (Matcher)Is.is((Object)16));
        theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:alterTableStatement");
        Assert.assertThat((Object)theNodes.size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldParseDropStatements() {
        this.printTest("shouldParseDropStatements()");
        String content = this.getFileContent("ddl/drop_statements.ddl");
        this.assertScoreAndParse(content, "drop_statements.ddl", 12);
        List theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:dropTableStatement");
        Assert.assertThat((Object)theNodes.size(), (Matcher)Is.is((Object)2));
        Assert.assertEquals((Object)"list_customers", (Object)((AstNode)theNodes.get(0)).getName());
        String prop = (String)((AstNode)theNodes.get(1)).getProperty("ddl:dropBehavior");
        Assert.assertEquals((Object)"RESTRICT", (Object)prop);
        theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:dropViewStatement");
        Assert.assertThat((Object)theNodes.size(), (Matcher)Is.is((Object)2));
        Assert.assertEquals((Object)"list_customers", (Object)((AstNode)theNodes.get(0)).getName());
        prop = (String)((AstNode)theNodes.get(1)).getProperty("ddl:dropBehavior");
        Assert.assertEquals((Object)"RESTRICT", (Object)prop);
        theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:dropSchemaStatement");
        Assert.assertThat((Object)theNodes.size(), (Matcher)Is.is((Object)2));
        Assert.assertEquals((Object)"list_customers", (Object)((AstNode)theNodes.get(0)).getName());
        prop = (String)((AstNode)theNodes.get(0)).getProperty("ddl:dropBehavior");
        Assert.assertEquals((Object)"CASCADE", (Object)prop);
        theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:dropDomainStatement");
        Assert.assertThat((Object)theNodes.size(), (Matcher)Is.is((Object)2));
        Assert.assertEquals((Object)"list_customers", (Object)((AstNode)theNodes.get(0)).getName());
        prop = (String)((AstNode)theNodes.get(0)).getProperty("ddl:dropBehavior");
        Assert.assertEquals((Object)"CASCADE", (Object)prop);
        theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:dropTranslationStatement");
        Assert.assertThat((Object)theNodes.size(), (Matcher)Is.is((Object)1));
        Assert.assertEquals((Object)"translation_name", (Object)((AstNode)theNodes.get(0)).getName());
        theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:dropCollationStatement");
        Assert.assertThat((Object)theNodes.size(), (Matcher)Is.is((Object)1));
        Assert.assertEquals((Object)"collation_name", (Object)((AstNode)theNodes.get(0)).getName());
        theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:dropCharacterSetStatement");
        Assert.assertThat((Object)theNodes.size(), (Matcher)Is.is((Object)1));
        Assert.assertEquals((Object)"character_set_name", (Object)((AstNode)theNodes.get(0)).getName());
        theNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:dropAssertionStatement");
        Assert.assertThat((Object)theNodes.size(), (Matcher)Is.is((Object)1));
        Assert.assertEquals((Object)"assertion_name", (Object)((AstNode)theNodes.get(0)).getName());
    }

    @Test
    public void shouldParseCreateViewNoViewColumnsNoOptions() {
        this.printTest("shouldParseCreateViewNoViewColumnsNoOptions()");
        String content = "CREATE VIEW new_product_view AS SELECT color, quantity FROM new_product WHERE color = 'RED' GRANT select ON new_product_view TO hr;";
        this.assertScoreAndParse(content, null, 2);
        AstNode viewNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertEquals((Object)"new_product_view", (Object)viewNode.getName());
        Assert.assertEquals((long)0L, (long)viewNode.getChildCount());
    }

    @Test
    public void shouldParseCreateViewWithViewColumnsNoOptions() {
        this.printTest("shouldParseCreateViewWithViewColumnsNoOptions()");
        String content = "CREATE VIEW CORPDATA.EMP_YEARSOFSERVICE (LASTNAME, YEARSOFSERVICE) AS SELECT LASTNAME, YEAR (CURRENT DATE - HIREDATE) FROM CORPDATA.EMPLOYEE;";
        this.assertScoreAndParse(content, null, 1);
        AstNode viewNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertEquals((Object)"CORPDATA.EMP_YEARSOFSERVICE", (Object)viewNode.getName());
        Assert.assertEquals((long)2L, (long)viewNode.getChildCount());
        AstNode columnRef = (AstNode)viewNode.getChildren().get(0);
        Assert.assertEquals((Object)"LASTNAME", (Object)columnRef.getName());
    }

    @Test
    public void shouldParseMixedTerminatedStatements() {
        this.printTest("");
        String content = this.getFileContent("ddl/standardDdlTest.ddl");
        this.assertScoreAndParse(content, "standardDdlTest.ddl", 11);
    }

    @Test
    public void shouldParseUnterminatedStatementsFile() {
        this.printTest("shouldParseUnterminatedOracleFile()");
        String content = this.getFileContent("ddl/GFM_Physical_Partial.ddl");
        this.assertScoreAndParse(content, "GFM_Physical_Partial.ddl", 5);
        List schemaNodes = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:createSchemaStatement");
        Assert.assertThat((Object)schemaNodes.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((AstNode)schemaNodes.get(0)).getChildCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)((AstNode)schemaNodes.get(0)).getName(), (Matcher)Is.is((Object)"GLOBALFORCEMGMT"));
    }

    @Test
    public void shouldParseStatementsWithDoubleQuotes() {
        this.printTest("shouldParseUnterminatedOracleFile()");
        String content = "ALTER JAVA CLASS \"Agent\"RESOLVER ((\"/home/java.101/bin/*\" pm)(* public)) RESOLVE;CREATE SERVER foo FOREIGN DATA WRAPPER \"default\";CREATE RULE \"_RETURN\" AS ON SELECT TO t1 DO INSTEAD SELECT * FROM t2;";
        this.assertScoreAndParse(content, null, 3);
    }

    @Test
    public void shouldParseGrantStatements() {
        this.printTest("shouldParseGrantStatements()");
        String content = "GRANT SELECT ON TABLE purchaseOrders TO maria,harry;\nGRANT UPDATE, USAGE ON TABLE purchaseOrders TO anita,zhi;\nGRANT SELECT ON TABLE orders.bills to PUBLIC;\nGRANT INSERT(a, b, c) ON TABLE purchaseOrders TO purchases_reader_role;";
        this.assertScoreAndParse(content, null, 4);
    }

    @Test
    public void shouldParseRevokeStatements() {
        this.printTest("shouldParseRevokeStatements()");
        String content = "REVOKE SELECT ON TABLE purchaseOrders FROM maria,harry;\nREVOKE UPDATE, USAGE ON TABLE purchaseOrders FROM anita,zhi CASCADE;\nREVOKE SELECT ON TABLE orders.bills FROM PUBLIC RESTRICT;\nREVOKE INSERT(a, b, c) ON TABLE purchaseOrders FROM purchases_reader_role;";
        this.assertScoreAndParse(content, null, 4);
    }

    @Test
    public void shouldParseSchemaWithTableAndView() {
        this.printTest("shouldParseSchemaWithTableAndView()");
        String content = "create schema schema_1 authorization ADM default character set UNICODE\n     create table table_1 (col1 varchar(20) not null, col2 nchar default current_user)\n     create view view_1 (col1, col2) as select*from a with check option\n;";
        this.assertScoreAndParse(content, null, 1);
    }
}

