/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.sequencer.ddl.DdlParserTestHelper;
import org.modeshape.sequencer.ddl.DdlParsers;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.modeshape.sequencer.ddl.node.AstNodeFactory;

public class DdlParsersTest
extends DdlParserTestHelper {
    private DdlParsers parsers;
    public static final String DDL_TEST_FILE_PATH = "ddl/";
    private AstNodeFactory nodeFactory;
    private AstNode rootNode;

    @Before
    public void beforeEach() {
        this.parsers = new DdlParsers();
        this.nodeFactory = new AstNodeFactory();
        this.rootNode = this.nodeFactory.node("root_node");
    }

    @Test
    public void shouldParseUntypedDdlFileWithTypeInFilename() {
        this.printTest("shouldParseTypedDdlFile()");
        String content = "-- SAMPLE DDL FILE\nCREATE TABLE myTableName (PART_COLOR VARCHAR(255) NOT NULL, PART_ID INTEGER DEFAULT (100))\nDROP TABLE list_customers CASCADE";
        this.rootNode = this.parsers.parse(content, "someSQL92.ddl");
        Assert.assertEquals((Object)"SQL92", (Object)this.rootNode.getProperty("ddl:parserId"));
    }

    @Test
    public void shouldParseTypedDdlFileWith() {
        this.printTest("shouldParseTypedDdlFile()");
        String content = "-- SAMPLE SQL92 DDL FILE\nCREATE TABLE myTableName (PART_COLOR VARCHAR(255) NOT NULL, PART_ID INTEGER DEFAULT (100))\nDROP TABLE list_customers CASCADE";
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertEquals((Object)"SQL92", (Object)this.rootNode.getProperty("ddl:parserId"));
    }

    @Test
    public void shouldParseUntypedDdlFile() {
        this.printTest("shouldParseUntypedDdlFile()");
        String content = "\n-- SAMPLE DDL FILE\nCREATE TABLE myTableName (PART_COLOR VARCHAR(255) NOT NULL, PART_ID INTEGER DEFAULT (100))\nDROP TABLE list_customers CASCADE";
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertEquals((Object)"SQL92", (Object)this.rootNode.getProperty("ddl:parserId"));
    }

    @Test
    public void shouldParseUntypedDerbyFile() {
        this.printTest("shouldParseUntypedDerbyFile()");
        String content = this.getFileContent("ddl/dialect/derby/derby_test_statements.ddl");
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertEquals((Object)"DERBY", (Object)this.rootNode.getProperty("ddl:parserId"));
    }

    @Test
    public void shouldParseTypedDerbyFile() {
        this.printTest("shouldParseTypedDerbyFile()");
        String content = this.getFileContent("ddl/dialect/derby/derby_test_statements_typed.ddl");
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertEquals((Object)"DERBY", (Object)this.rootNode.getProperty("ddl:parserId"));
    }

    @Test
    public void shouldParseUntypedOracleFile() {
        this.printTest("shouldParseUntypedOracleFile()");
        String content = this.getFileContent("ddl/dialect/oracle/oracle_test_statements_3.ddl");
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertEquals((Object)"ORACLE", (Object)this.rootNode.getProperty("ddl:parserId"));
    }

    @Test
    public void shouldParseUntypedPostgresFile() {
        this.printTest("shouldParseUntypedPostgresFile()");
        String content = this.getFileContent("ddl/dialect/postgres/postgres_test_statements_1.ddl");
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertThat((Object)"POSTGRES", (Matcher)Is.is((Object)((String)this.rootNode.getProperty("ddl:parserId"))));
    }

    @Test
    public void shouldParseUnterminatedOracleFile() {
        this.printTest("shouldParseUnterminatedOracleFile()");
        String content = this.getFileContent("ddl/GFM_Physical.ddl");
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertEquals((Object)"ORACLE", (Object)this.rootNode.getProperty("ddl:parserId"));
        this.setPrintToConsole(true);
        List problems = this.nodeFactory.getChildrenForType(this.rootNode, "ddl:ddlProblem");
        for (AstNode problem : problems) {
            this.printTest(problem.toString());
        }
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)123));
        List schemaNodes = this.nodeFactory.getChildrenForType(this.rootNode, "ddl:createSchemaStatement");
        Assert.assertThat((Object)schemaNodes.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((AstNode)schemaNodes.get(0)).getChildCount(), (Matcher)Is.is((Object)53));
        Assert.assertThat((Object)((AstNode)schemaNodes.get(0)).getName(), (Matcher)Is.is((Object)"GLOBALFORCEMGMT"));
        List alterNodes = this.nodeFactory.getChildrenForType(this.rootNode, "ddl:alterTableStatement");
        Assert.assertThat((Object)alterNodes.size(), (Matcher)Is.is((Object)120));
        List dropSchemaNodes = this.nodeFactory.getChildrenForType(this.rootNode, "ddl:dropSchemaStatement");
        Assert.assertThat((Object)dropSchemaNodes.size(), (Matcher)Is.is((Object)1));
        List unknownNodes = this.nodeFactory.getChildrenForType(this.rootNode, "ddl:unknownStatement");
        Assert.assertThat((Object)unknownNodes.size(), (Matcher)Is.is((Object)1));
    }
}

