/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.derby;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.sequencer.ddl.DdlParserScorer;
import org.modeshape.sequencer.ddl.DdlParserTestHelper;
import org.modeshape.sequencer.ddl.dialect.derby.DerbyDdlParser;

public class DerbyDdlParserTest
extends DdlParserTestHelper {
    public static final String DDL_FILE_PATH = "ddl/dialect/derby/";

    @Before
    public void beforeEach() {
        this.parser = new DerbyDdlParser();
        this.setPrintToConsole(false);
        this.parser.setTestMode(this.isPrintToConsole());
        this.parser.setDoUseTerminator(true);
        this.rootNode = this.parser.nodeFactory().node("ddlRootNode");
        this.scorer = new DdlParserScorer();
    }

    @Test
    public void shouldParseCreateFunctionWithDataTypeReturn() {
        this.printTest("shouldParseCreateFunctionWithDataTypeReturn()");
        String content = "CREATE FUNCTION TO_DEGREES\n( RADIANS DOUBLE )\nRETURNS DOUBLE\nPARAMETER STYLE JAVA\nNO SQL LANGUAGE JAVA\nEXTERNAL NAME 'java.lang.Math.toDegrees';";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParseCreateFunctionWithTableTypeReturn() {
        this.printTest("shouldParseCreateFunctionWithTableTypeReturn()");
        String content = "CREATE FUNCTION PROPERTY_FILE_READER\n( FILENAME VARCHAR( 32672 ), FILESIZE INTEGER )\nRETURNS TABLE (KEY_COL VARCHAR( 10 ), VALUE_COL VARCHAR( 1000 ))\nLANGUAGE JAVA\nPARAMETER STYLE DERBY_JDBC_RESULT_SET\nNO SQL\nEXTERNAL NAME 'vtis.example.PropertyFileVTI.propertyFileVTI';";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParseDropSchemaRestrict() {
        this.printTest("shouldParseDropSchemaRestrict()");
        String content = "DROP SCHEMA SAMP RESTRICT;";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParseCreateIndex() {
        this.printTest("shouldParseCreateIndex()");
        String content = "CREATE INDEX PAY_DESC ON SAMP.EMPLOYEE (SALARY DESC, UNIT);";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParseLockTable() {
        this.printTest("shouldParseLockTable()");
        String content = "LOCK TABLE FlightAvailability IN EXCLUSIVE MODE;";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParseDeclareGlobaTemporaryTable() {
        this.printTest("shouldParseDeclareGlobaTemporaryTable()");
        String content = "declare global temporary table SESSION.t1(c11 int) not logged;";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParseRenameTable() {
        this.printTest("shouldParseRenameTable()");
        String content = "RENAME TABLE SAMP.EMP_ACT TO EMPLOYEE_ACT;";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParseCreateSynonym() {
        this.printTest("shouldParseCreateSynonym()");
        String content = "CREATE SYNONYM SAMP.T1 FOR SAMP.TABLEWITHLONGNAME;";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParseCreateTrigger() {
        this.printTest("shouldParseCreateTrigger()");
        String content = "CREATE TRIGGER FLIGHTSDELETE3\nAFTER DELETE ON FLIGHTS\nREFERENCING OLD AS OLD\nFOR EACH ROW\nDELETE FROM FLIGHTAVAILABILITY WHERE FLIGHT_ID = OLD.FLIGHT_ID;";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParseCreateTrigger_2() {
        this.printTest("shouldParseCreateTrigger_2()");
        String content = "CREATE TRIGGER t1 NO CASCADE BEFORE UPDATE ON x\nFOR EACH ROW MODE DB2SQL\nvalues app.notifyEmail('Jerry', 'Table x is about to be updated');";
        this.assertScoreAndParse(content, null, 1);
    }

    @Test
    public void shouldParseGrantStatements() {
        this.printTest("shouldParseGrantStatements()");
        String content = "GRANT SELECT ON TABLE purchaseOrders TO maria,harry;\nGRANT UPDATE, TRIGGER ON TABLE purchaseOrders TO anita,zhi;\nGRANT SELECT ON TABLE orders.bills to PUBLIC;\nGRANT EXECUTE ON PROCEDURE updatePurchases TO george;\nGRANT purchases_reader_role TO george,maria;\nGRANT SELECT ON TABLE purchaseOrders TO purchases_reader_role;";
        this.assertScoreAndParse(content, null, 6);
    }

    @Test
    public void shouldParseAlterTableAlterColumnDefaultRealNumber() {
        this.printTest("shouldParseAlterTableAlterColumnDefaultRealNumber()");
        String content = "ALTER TABLE Employees ALTER COLUMN Salary DEFAULT 1000.0;";
        this.assertScoreAndParse(content, null, -1);
    }

    @Test
    public void shouldParseDropProcedure() {
        this.printTest("shouldParseDropProcedure()");
        String content = "DROP PROCEDURE some_procedure_name";
        this.assertScoreAndParse(content, null, -1);
    }

    @Test
    public void shouldParseDerbyStatements() {
        this.printTest("shouldParseDerbyStatements()");
        String content = this.getFileContent("ddl/dialect/derby/derby_test_statements.ddl");
        this.assertScoreAndParse(content, "derby_test_statements.ddl", -1);
        List problems = this.parser.nodeFactory().getChildrenForType(this.rootNode, "ddl:ddlProblem");
        int nStatements = this.rootNode.getChildCount() - problems.size();
        Assert.assertEquals((long)64L, (long)nStatements);
    }
}

