/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.ParsingException;
import org.modeshape.sequencer.ddl.dialect.teiid.CreateTableParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlTest;
import org.modeshape.sequencer.ddl.node.AstNode;

public class CreateTableParserTest
extends TeiidDdlTest {
    private CreateTableParser parser;
    private AstNode rootNode;

    @Before
    public void beforeEach() {
        TeiidDdlParser teiidDdlParser = new TeiidDdlParser();
        this.parser = new CreateTableParser(teiidDdlParser);
        this.rootNode = teiidDdlParser.nodeFactory().node("ddlRootNode");
    }

    @Test
    public void shouldParseForeignTable() {
        String content = "CREATE FOREIGN TABLE G1(e1 integer primary key, e2 varchar(10) unique,e3 date not null unique, e4 decimal(12,3) options (searchable 'unsearchable'),e5 integer auto_increment INDEX OPTIONS (UUID 'uuid', NAMEINSOURCE 'nis', SELECTABLE 'NO'),e6 varchar index default 'hello')OPTIONS (CARDINALITY 12, UUID 'uuid2', UPDATABLE 'true', FOO 'BAR', ANNOTATION 'Test Table')";
        AstNode tableNode = this.parser.parse(this.getTokens("CREATE FOREIGN TABLE G1(e1 integer primary key, e2 varchar(10) unique,e3 date not null unique, e4 decimal(12,3) options (searchable 'unsearchable'),e5 integer auto_increment INDEX OPTIONS (UUID 'uuid', NAMEINSOURCE 'nis', SELECTABLE 'NO'),e6 varchar index default 'hello')OPTIONS (CARDINALITY 12, UUID 'uuid2', UPDATABLE 'true', FOO 'BAR', ANNOTATION 'Test Table')"), this.rootNode);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElement").size(), (Matcher)Is.is((Object)6));
        Assert.assertThat((Object)tableNode.childrenWithName("e1").size(), (Matcher)Is.is((Object)1));
        AstNode e1 = (AstNode)tableNode.childrenWithName("e1").get(0);
        this.assertProperty(e1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        this.assertProperty(e1, "teiidddl:autoIncrement", false);
        this.assertProperty(e1, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e2").size(), (Matcher)Is.is((Object)1));
        AstNode e2 = (AstNode)tableNode.childrenWithName("e2").get(0);
        this.assertProperty(e2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(e2, "ddl:datatypeLength", 10L);
        this.assertProperty(e2, "teiidddl:autoIncrement", false);
        this.assertProperty(e2, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e3").size(), (Matcher)Is.is((Object)1));
        AstNode e3 = (AstNode)tableNode.childrenWithName("e3").get(0);
        this.assertProperty(e3, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.DATE.toDdl());
        this.assertProperty(e3, "teiidddl:autoIncrement", false);
        this.assertProperty(e3, "ddl:nullable", "NOT NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e4").size(), (Matcher)Is.is((Object)1));
        AstNode e4 = (AstNode)tableNode.childrenWithName("e4").get(0);
        this.assertProperty(e4, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.DECIMAL.toDdl());
        this.assertProperty(e4, "ddl:datatypePrecision", 12);
        this.assertProperty(e4, "ddl:datatypeScale", 3);
        this.assertProperty(e4, "teiidddl:autoIncrement", false);
        this.assertProperty(e4, "ddl:nullable", "NULL");
        Assert.assertThat((Object)e4.getChildren("ddl:statementOption").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((AstNode)e4.getChildren("ddl:statementOption").get(0)).getName(), (Matcher)Is.is((Object)"searchable"));
        this.assertProperty((AstNode)e4.getChildren("ddl:statementOption").get(0), "ddl:value", "unsearchable");
        Assert.assertThat((Object)tableNode.childrenWithName("e5").size(), (Matcher)Is.is((Object)1));
        AstNode e5 = (AstNode)tableNode.childrenWithName("e5").get(0);
        this.assertProperty(e5, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        this.assertProperty(e5, "teiidddl:autoIncrement", true);
        this.assertProperty(e5, "ddl:nullable", "NULL");
        Assert.assertThat((Object)e5.getChildren("ddl:statementOption").size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)e5.childrenWithName("UUID").size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)e5.childrenWithName("UUID").get(0), "ddl:value", "uuid");
        Assert.assertThat((Object)e5.childrenWithName("NAMEINSOURCE").size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)e5.childrenWithName("NAMEINSOURCE").get(0), "ddl:value", "nis");
        Assert.assertThat((Object)e5.childrenWithName("SELECTABLE").size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)e5.childrenWithName("SELECTABLE").get(0), "ddl:value", "NO");
        Assert.assertThat((Object)tableNode.childrenWithName("e6").size(), (Matcher)Is.is((Object)1));
        AstNode e6 = (AstNode)tableNode.childrenWithName("e6").get(0);
        this.assertProperty(e6, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(e6, "teiidddl:autoIncrement", false);
        this.assertProperty(e6, "ddl:nullable", "NULL");
        this.assertProperty(e6, "ddl:defaultValue", "hello");
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElementConstraint").size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)tableNode.childrenWithName("PRIMARY KEY").size(), (Matcher)Is.is((Object)1));
        Object temp = ((AstNode)tableNode.childrenWithName("PRIMARY KEY").get(0)).getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)temp, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        List references = (List)temp;
        Assert.assertThat((Object)references.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(references.get(0), (Matcher)Is.is(tableNode.childrenWithName("e1").get(0)));
        List uniques = tableNode.childrenWithName("UNIQUE");
        Assert.assertThat((Object)uniques.size(), (Matcher)Is.is((Object)2));
        Object temp1 = ((AstNode)uniques.get(0)).getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)temp1, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        List references1 = (List)temp1;
        Assert.assertThat((Object)references1.size(), (Matcher)Is.is((Object)1));
        Object temp2 = ((AstNode)uniques.get(1)).getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)temp2, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        List references2 = (List)temp2;
        Assert.assertThat((Object)references2.size(), (Matcher)Is.is((Object)1));
        if (((AstNode)references1.get(0)).equals(tableNode.childrenWithName("e2").get(0))) {
            Assert.assertThat((Object)references2, (Matcher)CoreMatchers.hasItem(tableNode.childrenWithName("e3").get(0)));
        } else if (((AstNode)references1.get(0)).equals(tableNode.childrenWithName("e3").get(0))) {
            Assert.assertThat((Object)references2, (Matcher)CoreMatchers.hasItem(tableNode.childrenWithName("e2").get(0)));
        } else {
            Assert.fail((String)"unique constraints for column 'e1' and 'e2' not found");
        }
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)tableNode.getChildren("ddl:statementOption").size(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)tableNode.childrenWithName("CARDINALITY").size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)tableNode.childrenWithName("CARDINALITY").get(0), "ddl:value", "12");
        Assert.assertThat((Object)tableNode.childrenWithName("UUID").size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)tableNode.childrenWithName("UUID").get(0), "ddl:value", "uuid2");
        Assert.assertThat((Object)tableNode.childrenWithName("UPDATABLE").size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)tableNode.childrenWithName("UPDATABLE").get(0), "ddl:value", "true");
        Assert.assertThat((Object)tableNode.childrenWithName("FOO").size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)tableNode.childrenWithName("FOO").get(0), "ddl:value", "BAR");
        Assert.assertThat((Object)tableNode.childrenWithName("ANNOTATION").size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)tableNode.childrenWithName("ANNOTATION").get(0), "ddl:value", "Test Table");
    }

    @Test
    public void shouldParseDuplicatePrimaryKey() {
        String content = "CREATE FOREIGN TABLE G1( e1 integer primary key, e2 varchar primary key)";
        AstNode tableNode = this.parser.parse(this.getTokens("CREATE FOREIGN TABLE G1( e1 integer primary key, e2 varchar primary key)"), this.rootNode);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElementConstraint").size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)tableNode.childrenWithName("e1").size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)tableNode.childrenWithName("e1").get(0), "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        Assert.assertThat((Object)tableNode.childrenWithName("e2").size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)tableNode.childrenWithName("e2").get(0), "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldParseAutoIncrementPrimaryKey() {
        String content = "CREATE FOREIGN TABLE G1( e1 integer auto_increment primary key, e2 varchar)";
        AstNode tableNode = this.parser.parse(this.getTokens("CREATE FOREIGN TABLE G1( e1 integer auto_increment primary key, e2 varchar)"), this.rootNode);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElement").size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)tableNode.childrenWithName("e1").size(), (Matcher)Is.is((Object)1));
        AstNode e1 = (AstNode)tableNode.childrenWithName("e1").get(0);
        this.assertProperty(e1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        this.assertProperty(e1, "teiidddl:autoIncrement", true);
        this.assertProperty(e1, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e2").size(), (Matcher)Is.is((Object)1));
        AstNode e2 = (AstNode)tableNode.childrenWithName("e2").get(0);
        this.assertProperty(e2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(e2, "teiidddl:autoIncrement", false);
        this.assertProperty(e2, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElementConstraint").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldParseUdt() {
        String content = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar OPTIONS (UDT 'NMTOKENS(12,13,14)'))";
        AstNode tableNode = this.parser.parse(this.getTokens("CREATE FOREIGN TABLE G1( e1 integer, e2 varchar OPTIONS (UDT 'NMTOKENS(12,13,14)'))"), this.rootNode);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElement").size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)tableNode.childrenWithName("e1").size(), (Matcher)Is.is((Object)1));
        AstNode e1 = (AstNode)tableNode.childrenWithName("e1").get(0);
        this.assertProperty(e1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        this.assertProperty(e1, "teiidddl:autoIncrement", false);
        this.assertProperty(e1, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e2").size(), (Matcher)Is.is((Object)1));
        AstNode e2 = (AstNode)tableNode.childrenWithName("e2").get(0);
        this.assertProperty(e2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(e2, "teiidddl:autoIncrement", false);
        this.assertProperty(e2, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElementConstraint").size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldParseFunctionIndex() {
        String content = "CREATE FOREIGN TABLE G1(e1 integer, e2 varchar, CONSTRAINT fbi INDEX (UPPER(e2)))";
        AstNode tableNode = this.parser.parse(this.getTokens("CREATE FOREIGN TABLE G1(e1 integer, e2 varchar, CONSTRAINT fbi INDEX (UPPER(e2)))"), this.rootNode);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toString());
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElement").size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)tableNode.childrenWithName("e1").size(), (Matcher)Is.is((Object)1));
        AstNode e1 = (AstNode)tableNode.childrenWithName("e1").get(0);
        this.assertProperty(e1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        this.assertProperty(e1, "teiidddl:autoIncrement", false);
        this.assertProperty(e1, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e2").size(), (Matcher)Is.is((Object)1));
        AstNode e2 = (AstNode)tableNode.childrenWithName("e2").get(0);
        this.assertProperty(e2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(e2, "teiidddl:autoIncrement", false);
        this.assertProperty(e2, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElementConstraint").size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)1));
        AstNode indexNode = (AstNode)tableNode.getChildren("teiidddl:indexConstraint").get(0);
        Assert.assertThat((Object)indexNode.getName(), (Matcher)Is.is((Object)"fbi"));
        this.assertProperty(indexNode, "teiidddl:expression", "UPPER(e2)");
        Object temp = indexNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)temp, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        List references = (List)temp;
        Assert.assertThat((Object)references.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(references.get(0), (Matcher)Is.is(tableNode.childrenWithName("e2").get(0)));
    }

    @Test
    public void shouldParseMultiKeyPrimaryKey() {
        String content = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, PRIMARY KEY (e1, e2))";
        AstNode tableNode = this.parser.parse(this.getTokens("CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, PRIMARY KEY (e1, e2))"), this.rootNode);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElement").size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)tableNode.childrenWithName("e1").size(), (Matcher)Is.is((Object)1));
        AstNode e1 = (AstNode)tableNode.childrenWithName("e1").get(0);
        this.assertProperty(e1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        this.assertProperty(e1, "teiidddl:autoIncrement", false);
        this.assertProperty(e1, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e2").size(), (Matcher)Is.is((Object)1));
        AstNode e2 = (AstNode)tableNode.childrenWithName("e2").get(0);
        this.assertProperty(e2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(e2, "teiidddl:autoIncrement", false);
        this.assertProperty(e2, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e3").size(), (Matcher)Is.is((Object)1));
        AstNode e3 = (AstNode)tableNode.childrenWithName("e3").get(0);
        this.assertProperty(e3, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.DATE.toDdl());
        this.assertProperty(e3, "teiidddl:autoIncrement", false);
        this.assertProperty(e3, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElementConstraint").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldParseOptionsKey() {
        String content = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, UNIQUE (e1) OPTIONS (CUSTOM_PROP 'VALUE'))";
        AstNode tableNode = this.parser.parse(this.getTokens("CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, UNIQUE (e1) OPTIONS (CUSTOM_PROP 'VALUE'))"), this.rootNode);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElement").size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)tableNode.childrenWithName("e1").size(), (Matcher)Is.is((Object)1));
        AstNode e1 = (AstNode)tableNode.childrenWithName("e1").get(0);
        this.assertProperty(e1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        this.assertProperty(e1, "teiidddl:autoIncrement", false);
        this.assertProperty(e1, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e2").size(), (Matcher)Is.is((Object)1));
        AstNode e2 = (AstNode)tableNode.childrenWithName("e2").get(0);
        this.assertProperty(e2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(e2, "teiidddl:autoIncrement", false);
        this.assertProperty(e2, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e3").size(), (Matcher)Is.is((Object)1));
        AstNode e3 = (AstNode)tableNode.childrenWithName("e3").get(0);
        this.assertProperty(e3, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.DATE.toDdl());
        this.assertProperty(e3, "teiidddl:autoIncrement", false);
        this.assertProperty(e3, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElementConstraint").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldParseConstraints() {
        String content = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, PRIMARY KEY (e1, e2), INDEX(e2, e3), ACCESSPATTERN(e1), UNIQUE(e1), ACCESSPATTERN(e2, e3))";
        AstNode tableNode = this.parser.parse(this.getTokens("CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, PRIMARY KEY (e1, e2), INDEX(e2, e3), ACCESSPATTERN(e1), UNIQUE(e1), ACCESSPATTERN(e2, e3))"), this.rootNode);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElement").size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)tableNode.childrenWithName("e1").size(), (Matcher)Is.is((Object)1));
        AstNode e1 = (AstNode)tableNode.childrenWithName("e1").get(0);
        this.assertProperty(e1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        this.assertProperty(e1, "teiidddl:autoIncrement", false);
        this.assertProperty(e1, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e2").size(), (Matcher)Is.is((Object)1));
        AstNode e2 = (AstNode)tableNode.childrenWithName("e2").get(0);
        this.assertProperty(e2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(e2, "teiidddl:autoIncrement", false);
        this.assertProperty(e2, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e3").size(), (Matcher)Is.is((Object)1));
        AstNode e3 = (AstNode)tableNode.childrenWithName("e3").get(0);
        this.assertProperty(e3, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.DATE.toDdl());
        this.assertProperty(e3, "teiidddl:autoIncrement", false);
        this.assertProperty(e3, "ddl:nullable", "NULL");
        List tableElementConstraints = tableNode.getChildren("teiidddl:tableElementConstraint");
        Assert.assertThat((Object)tableElementConstraints.size(), (Matcher)Is.is((Object)4));
        AstNode constraintNode = (AstNode)tableElementConstraints.get(0);
        Object temp = constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)temp, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        List references = (List)temp;
        Assert.assertThat((Object)references.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)references, (Matcher)CoreMatchers.hasItems((Object[])new AstNode[]{(AstNode)tableNode.childrenWithName("e1").get(0), (AstNode)tableNode.childrenWithName("e2").get(0)}));
        constraintNode = (AstNode)tableElementConstraints.get(1);
        temp = constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)temp, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        references = (List)temp;
        Assert.assertThat((Object)references.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)references, (Matcher)CoreMatchers.hasItems((Object[])new AstNode[]{(AstNode)tableNode.childrenWithName("e1").get(0)}));
        constraintNode = (AstNode)tableElementConstraints.get(2);
        temp = constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)temp, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        references = (List)temp;
        Assert.assertThat((Object)references.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)references, (Matcher)CoreMatchers.hasItems((Object[])new AstNode[]{(AstNode)tableNode.childrenWithName("e1").get(0)}));
        constraintNode = (AstNode)tableElementConstraints.get(3);
        temp = constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)temp, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        references = (List)temp;
        Assert.assertThat((Object)references.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)references, (Matcher)CoreMatchers.hasItems((Object[])new AstNode[]{(AstNode)tableNode.childrenWithName("e2").get(0), (AstNode)tableNode.childrenWithName("e3").get(0)}));
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)1));
        AstNode indexNode = (AstNode)tableNode.getChildren("teiidddl:indexConstraint").get(0);
        this.assertProperty(indexNode, "teiidddl:expression", "e2, e3");
        this.assertProperty(indexNode, "teiidddl:constraintType", "INDEX");
        Object temp2 = indexNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)temp2, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        List references2 = (List)temp2;
        Assert.assertThat((Object)references2.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)references2, (Matcher)CoreMatchers.hasItems((Object[])new AstNode[]{(AstNode)tableNode.childrenWithName("e2").get(0), (AstNode)tableNode.childrenWithName("e3").get(0)}));
    }

    @Test
    public void shouldParseConstraints2() {
        String content = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, ACCESSPATTERN(e1), UNIQUE(e1), ACCESSPATTERN(e2, e3))";
        AstNode tableNode = this.parser.parse(this.getTokens("CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, e3 date, ACCESSPATTERN(e1), UNIQUE(e1), ACCESSPATTERN(e2, e3))"), this.rootNode);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElement").size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)tableNode.childrenWithName("e1").size(), (Matcher)Is.is((Object)1));
        AstNode e1 = (AstNode)tableNode.childrenWithName("e1").get(0);
        this.assertProperty(e1, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        this.assertProperty(e1, "teiidddl:autoIncrement", false);
        this.assertProperty(e1, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e2").size(), (Matcher)Is.is((Object)1));
        AstNode e2 = (AstNode)tableNode.childrenWithName("e2").get(0);
        this.assertProperty(e2, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(e2, "teiidddl:autoIncrement", false);
        this.assertProperty(e2, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.childrenWithName("e3").size(), (Matcher)Is.is((Object)1));
        AstNode e3 = (AstNode)tableNode.childrenWithName("e3").get(0);
        this.assertProperty(e3, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.DATE.toDdl());
        this.assertProperty(e3, "teiidddl:autoIncrement", false);
        this.assertProperty(e3, "ddl:nullable", "NULL");
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElementConstraint").size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)tableNode.childrenWithName("AP_1").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)tableNode.childrenWithName("AP_2").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)tableNode.childrenWithName("UC_1").size(), (Matcher)Is.is((Object)1));
        Object temp = ((AstNode)tableNode.childrenWithName("UC_1").get(0)).getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)temp, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        List references = (List)temp;
        Assert.assertThat((Object)references.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(references.get(0), (Matcher)Is.is(tableNode.childrenWithName("e1").get(0)));
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldParseUnresolvedColumnInPrimaryKey() {
        String content = "CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, PRIMARY KEY (missingColumn))";
        AstNode tableNode = this.parser.parse(this.getTokens("CREATE FOREIGN TABLE G1( e1 integer, e2 varchar, PRIMARY KEY (missingColumn))"), this.rootNode);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)tableNode.childrenWithName("PK_1").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseUnresolvedTableInForeignKey() {
        String content = "CREATE FOREIGN TABLE G1 (e1 integer, e2 varchar, CONSTRAINT fk_1 FOREIGN KEY (e1, e2) REFERENCES missingTable)";
        AstNode tableNode = this.parser.parse(this.getTokens("CREATE FOREIGN TABLE G1 (e1 integer, e2 varchar, CONSTRAINT fk_1 FOREIGN KEY (e1, e2) REFERENCES missingTable)"), this.rootNode);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)tableNode.childrenWithName("fk_1").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldNotParseUnresolvedColumnReferenceInForeignKey() {
        this.parser.parse(this.getTokens("CREATE FOREIGN TABLE refTable( t1 integer, t2 varchar)"), this.rootNode);
        String content = "CREATE FOREIGN TABLE G1 (e1 integer, e2 varchar, CONSTRAINT fk_1 FOREIGN KEY (e1, e2) REFERENCES refTable (t1, missingColumn))";
        AstNode tableNode = this.parser.parse(this.getTokens("CREATE FOREIGN TABLE G1 (e1 integer, e2 varchar, CONSTRAINT fk_1 FOREIGN KEY (e1, e2) REFERENCES refTable (t1, missingColumn))"), this.rootNode);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)tableNode.childrenWithName("fk_1").size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseViewWithoutColumns() {
        String content = "CREATE VIEW V1 AS SELECT * FROM PM1.G1";
        AstNode viewNode = this.parser.parse(this.getTokens("CREATE VIEW V1 AS SELECT * FROM PM1.G1"), this.rootNode);
        Assert.assertThat((Object)viewNode.getName(), (Matcher)Is.is((Object)"V1"));
        this.assertMixinType(viewNode, "teiidddl:createView");
        this.assertProperty(viewNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(viewNode, "teiidddl:queryExpression", "SELECT * FROM PM1.G1");
        Assert.assertThat((Object)viewNode.getChildren("teiidddl:tableElement").size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)viewNode.getChildren("teiidddl:tableElementConstraint").size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)viewNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldParseView() {
        String content = "CREATE View G1( e1 integer, e2 varchar) OPTIONS (CARDINALITY 12) AS select e1, e2 from foo.bar";
        AstNode viewNode = this.parser.parse(this.getTokens("CREATE View G1( e1 integer, e2 varchar) OPTIONS (CARDINALITY 12) AS select e1, e2 from foo.bar"), this.rootNode);
        Assert.assertThat((Object)viewNode.getName(), (Matcher)Is.is((Object)"G1"));
        this.assertMixinType(viewNode, "teiidddl:createView");
        this.assertProperty(viewNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        this.assertProperty(viewNode, "teiidddl:queryExpression", "select e1, e2 from foo.bar");
        List columns = viewNode.getChildren("teiidddl:tableElement");
        Assert.assertThat((Object)columns.size(), (Matcher)Is.is((Object)2));
        if ("e1".equals(((AstNode)columns.get(0)).getName())) {
            this.assertProperty((AstNode)columns.get(0), "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
            Assert.assertThat((Object)"e2", (Matcher)Is.is((Object)((AstNode)columns.get(1)).getName()));
            this.assertProperty((AstNode)columns.get(1), "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        } else if ("e1".equals(((AstNode)columns.get(1)).getName())) {
            this.assertProperty((AstNode)columns.get(1), "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
            Assert.assertThat((Object)"e2", (Matcher)Is.is((Object)((AstNode)columns.get(0)).getName()));
            this.assertProperty((AstNode)columns.get(0), "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        } else {
            Assert.fail((String)"column 'e1' not found");
        }
        Assert.assertThat((Object)viewNode.childrenWithName("CARDINALITY").size(), (Matcher)Is.is((Object)1));
        this.assertProperty((AstNode)viewNode.childrenWithName("CARDINALITY").get(0), "ddl:value", "12");
        Assert.assertThat((Object)viewNode.getChildren("teiidddl:tableElementConstraint").size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)viewNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldParseCreateForeignTableWithoutBody() {
        String content = "CREATE FOREIGN TABLE FOO";
        AstNode tableNode = this.parser.parse(this.getTokens("CREATE FOREIGN TABLE FOO"), this.rootNode);
        Assert.assertThat((Object)tableNode.getName(), (Matcher)Is.is((Object)"FOO"));
        this.assertMixinType(tableNode, "teiidddl:createTable");
        this.assertProperty(tableNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElement").size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:tableElementConstraint").size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)tableNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldParseCreateViewWithoutBody() {
        String content = "CREATE VIEW FOO";
        AstNode viewNode = this.parser.parse(this.getTokens("CREATE VIEW FOO"), this.rootNode);
        Assert.assertThat((Object)viewNode.getName(), (Matcher)Is.is((Object)"FOO"));
        this.assertMixinType(viewNode, "teiidddl:createView");
        this.assertProperty(viewNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.FOREIGN.toDdl());
        Assert.assertThat((Object)viewNode.getChildren("teiidddl:tableElement").size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)viewNode.getChildren("teiidddl:tableElementConstraint").size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)viewNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldParseCreateVirtualViewWithoutBody() {
        String content = "CREATE VIRTUAL VIEW FOO";
        AstNode viewNode = this.parser.parse(this.getTokens("CREATE VIRTUAL VIEW FOO"), this.rootNode);
        Assert.assertThat((Object)viewNode.getName(), (Matcher)Is.is((Object)"FOO"));
        this.assertMixinType(viewNode, "teiidddl:createView");
        this.assertProperty(viewNode, "teiidddl:schemaElementType", TeiidDdlConstants.SchemaElementType.VIRTUAL.toDdl());
        Assert.assertThat((Object)viewNode.getChildren("teiidddl:tableElement").size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)viewNode.getChildren("teiidddl:tableElementConstraint").size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)viewNode.getChildren("teiidddl:indexConstraint").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldParseTableElement() {
        String content = "symbol string";
        AstNode node = this.parser.parseTableElement(this.getTokens("symbol string"), this.rootNode);
        this.assertMixinType(node, "teiidddl:tableElement");
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"symbol"));
        this.assertProperty(node, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseTableElementWithDataTypeLength() {
        String content = "company_name varchar(256)";
        AstNode node = this.parser.parseTableElement(this.getTokens("company_name varchar(256)"), this.rootNode);
        this.assertMixinType(node, "teiidddl:tableElement");
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"company_name"));
        this.assertProperty(node, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(node, "ddl:datatypeLength", 256L);
    }

    @Test
    public void shouldParseTableElementWithNotNull() {
        String content = "ACCOUNT_ID long NOT NULL";
        AstNode node = this.parser.parseTableElement(this.getTokens("ACCOUNT_ID long NOT NULL"), this.rootNode);
        this.assertMixinType(node, "teiidddl:tableElement");
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"ACCOUNT_ID"));
        this.assertProperty(node, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.LONG.toDdl());
        this.assertProperty(node, "ddl:nullable", "NOT NULL");
    }

    @Test
    public void shouldParseTableElementWithQuotedDefaultValue() {
        String content = "DATEOPENED timestamp DEFAULT 'CURRENT_TIMESTAMP'";
        AstNode node = this.parser.parseTableElement(this.getTokens("DATEOPENED timestamp DEFAULT 'CURRENT_TIMESTAMP'"), this.rootNode);
        this.assertMixinType(node, "teiidddl:tableElement");
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"DATEOPENED"));
        this.assertProperty(node, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.TIMESTAMP.toDdl());
        this.assertProperty(node, "ddl:defaultOption", "DATETIME");
        this.assertProperty(node, "ddl:defaultValue", "CURRENT_TIMESTAMP");
    }

    @Test
    public void shouldParseTableElementWithOptionsClause() {
        String content = "DATECLOSED timestamp OPTIONS (ANNOTATION 'This is the date closed', NAMEINSOURCE '`DATECLOSED`', NATIVE_TYPE 'TIMESTAMP')";
        AstNode node = this.parser.parseTableElement(this.getTokens("DATECLOSED timestamp OPTIONS (ANNOTATION 'This is the date closed', NAMEINSOURCE '`DATECLOSED`', NATIVE_TYPE 'TIMESTAMP')"), this.rootNode);
        this.assertMixinType(node, "teiidddl:tableElement");
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)"DATECLOSED"));
        this.assertProperty(node, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.TIMESTAMP.toDdl());
        List kids = node.getChildren();
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)3));
        for (AstNode kid : kids) {
            this.assertMixinType(kid, "ddl:statementOption");
        }
    }

    @Test
    public void shouldParseTableElementWithPrimaryKeyConstraint() {
        String content = "KEY STRING(9) PRIMARY KEY";
        AstNode columnNode = this.parser.parseTableElement(this.getTokens("KEY STRING(9) PRIMARY KEY"), this.rootNode);
        this.assertMixinType(columnNode, "teiidddl:tableElement");
        Assert.assertThat((Object)columnNode.getName(), (Matcher)Is.is((Object)"KEY"));
        this.assertProperty(columnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        this.assertProperty(columnNode, "ddl:datatypeLength", 9L);
        List kids = this.rootNode.getChildren();
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)2));
        AstNode constraintNode = kids.get(0) == columnNode ? (AstNode)kids.get(1) : (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:tableElementConstraint"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", "PRIMARY KEY");
        Object temp = constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)temp, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        List references = (List)temp;
        Assert.assertThat((Object)references.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(references.get(0), (Matcher)Is.is((Object)columnNode));
    }

    @Test
    public void shouldParseTableElementWithPrimaryUniqueConstraint() {
        String content = "KEY VARCHAR(9) UNIQUE";
        AstNode columnNode = this.parser.parseTableElement(this.getTokens("KEY VARCHAR(9) UNIQUE"), this.rootNode);
        this.assertMixinType(columnNode, "teiidddl:tableElement");
        Assert.assertThat((Object)columnNode.getName(), (Matcher)Is.is((Object)"KEY"));
        this.assertProperty(columnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.VARCHAR.toDdl());
        this.assertProperty(columnNode, "ddl:datatypeLength", 9L);
        List kids = this.rootNode.getChildren();
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)2));
        AstNode constraintNode = kids.get(0) == columnNode ? (AstNode)kids.get(1) : (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:tableElementConstraint"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", "UNIQUE");
        Object temp = constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)temp, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(List.class)));
        List references = (List)temp;
        Assert.assertThat((Object)references.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(references.get(0), (Matcher)Is.is((Object)columnNode));
    }

    @Test
    public void shouldParseTableElementWithIndexConstraint() {
        String content = "KEY STRING(9) INDEX";
        AstNode columnNode = this.parser.parseTableElement(this.getTokens("KEY STRING(9) INDEX"), this.rootNode);
        this.assertMixinType(columnNode, "teiidddl:tableElement");
        Assert.assertThat((Object)columnNode.getName(), (Matcher)Is.is((Object)"KEY"));
        this.assertProperty(columnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.STRING.toDdl());
        List kids = this.rootNode.getChildren();
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)2));
        AstNode constraintNode = kids.get(0) == columnNode ? (AstNode)kids.get(1) : (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:indexConstraint"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", "INDEX");
        Assert.assertThat((Object)constraintNode.getProperty("teiidddl:expression"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseTableElementWithAutoIncrementIndexConstraint() {
        String content = "e5 integer auto_increment INDEX";
        AstNode columnNode = this.parser.parseTableElement(this.getTokens("e5 integer auto_increment INDEX"), this.rootNode);
        this.assertMixinType(columnNode, "teiidddl:tableElement");
        Assert.assertThat((Object)columnNode.getName(), (Matcher)Is.is((Object)"e5"));
        this.assertProperty(columnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.INTEGER.toDdl());
        this.assertProperty(columnNode, "teiidddl:autoIncrement", true);
        this.assertProperty(columnNode, "ddl:nullable", "NULL");
        List kids = this.rootNode.getChildren();
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)2));
        AstNode constraintNode = kids.get(0) == columnNode ? (AstNode)kids.get(1) : (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:indexConstraint"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", "INDEX");
        Assert.assertThat((Object)constraintNode.getProperty("teiidddl:expression"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseTableElementWithAllClauses() {
        String name = "foo";
        int precision = 9;
        int scale = 3;
        String value = "bar";
        String content = "foo bigdecimal(9,3) NOT NULL auto_increment index DEFAULT 'bar' OPTIONS (CARDINALITY 12, UUID 'uuid2',  UPDATABLE 'true', FOO 'BAR', ANNOTATION 'Test Table')";
        AstNode columnNode = this.parser.parseTableElement(this.getTokens("foo bigdecimal(9,3) NOT NULL auto_increment index DEFAULT 'bar' OPTIONS (CARDINALITY 12, UUID 'uuid2',  UPDATABLE 'true', FOO 'BAR', ANNOTATION 'Test Table')"), this.rootNode);
        Assert.assertThat((Object)columnNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertProperty(columnNode, "ddl:datatypeName", TeiidDdlConstants.TeiidDataType.BIGDECIMAL.toDdl());
        this.assertProperty(columnNode, "ddl:datatypePrecision", 9);
        this.assertProperty(columnNode, "ddl:datatypeScale", 3);
        this.assertProperty(columnNode, "ddl:defaultOption", "LITERAL");
        this.assertProperty(columnNode, "ddl:defaultValue", "bar");
        this.assertProperty(columnNode, "teiidddl:autoIncrement", true);
        this.assertProperty(columnNode, "ddl:nullable", "NOT NULL");
        List rootKids = this.rootNode.getChildren();
        Assert.assertThat((Object)rootKids.size(), (Matcher)Is.is((Object)2));
        AstNode constraintNode = rootKids.get(0) == columnNode ? (AstNode)rootKids.get(1) : (AstNode)rootKids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:indexConstraint"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", "INDEX");
        Assert.assertThat((Object)constraintNode.getProperty("teiidddl:expression"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        List kids = columnNode.getChildren();
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)5));
        for (AstNode kid : kids) {
            this.assertMixinType(kid, "ddl:statementOption");
        }
    }

    @Test
    public void shouldParseNamedIndexConstraint() {
        String content = "CONSTRAINT fbi INDEX (UPPER(e2))";
        Assert.assertThat((Object)this.parser.parseTableBodyConstraint(this.getTokens("CONSTRAINT fbi INDEX (UPPER(e2))"), this.rootNode), (Matcher)Is.is((Object)true));
        List kids = this.rootNode.getChildren();
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        AstNode constraintNode = (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:indexConstraint"));
        Assert.assertThat((Object)constraintNode.getName(), (Matcher)Is.is((Object)"fbi"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", "INDEX");
        this.assertProperty(constraintNode, "teiidddl:expression", "UPPER(e2)");
    }

    @Test
    public void shouldParseUnnamedIndexConstraint() {
        String content = " INDEX (UPPER(e2))";
        Assert.assertThat((Object)this.parser.parseTableBodyConstraint(this.getTokens(" INDEX (UPPER(e2))"), this.rootNode), (Matcher)Is.is((Object)true));
        List kids = this.rootNode.getChildren();
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        AstNode constraintNode = (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:indexConstraint"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", "INDEX");
        Assert.assertThat((Object)constraintNode.getName(), (Matcher)Is.is((Object)"NDX_1"));
        this.assertProperty(constraintNode, "teiidddl:expression", "UPPER(e2)");
    }

    @Test
    public void shouldParseNamedPrimaryKeyConstraint() {
        AstNode col1Node = new AstNode(this.rootNode, "col1");
        AstNode col2Node = new AstNode(this.rootNode, "col2");
        String content = "CONSTRAINT pk_1 PRIMARY KEY (col1, col2)";
        Assert.assertThat((Object)this.parser.parseTableBodyConstraint(this.getTokens("CONSTRAINT pk_1 PRIMARY KEY (col1, col2)"), this.rootNode), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)3));
        List kids = this.rootNode.childrenWithName("pk_1");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        AstNode constraintNode = (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:tableElementConstraint"));
        Assert.assertThat((Object)constraintNode.getName(), (Matcher)Is.is((Object)"pk_1"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", "PRIMARY KEY");
        List refs = (List)constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)refs.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)refs, (Matcher)CoreMatchers.hasItems((Object[])new AstNode[]{col1Node, col2Node}));
    }

    @Test
    public void shouldParseUnnamedPrimaryKeyConstraint() {
        AstNode col1Node = new AstNode(this.rootNode, "col1");
        AstNode col2Node = new AstNode(this.rootNode, "col2");
        String content = "PRIMARY KEY (col1, col2)";
        Assert.assertThat((Object)this.parser.parseTableBodyConstraint(this.getTokens("PRIMARY KEY (col1, col2)"), this.rootNode), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)3));
        List kids = this.rootNode.childrenWithName("PK_1");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        AstNode constraintNode = (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:tableElementConstraint"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", "PRIMARY KEY");
        List refs = (List)constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)refs.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)refs, (Matcher)CoreMatchers.hasItems((Object[])new AstNode[]{col1Node, col2Node}));
    }

    @Test
    public void shouldParseNamedUniqueConstraint() {
        AstNode col1Node = new AstNode(this.rootNode, "col1");
        String content = "CONSTRAINT uk_1 UNIQUE (col1)";
        Assert.assertThat((Object)this.parser.parseTableBodyConstraint(this.getTokens("CONSTRAINT uk_1 UNIQUE (col1)"), this.rootNode), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)2));
        List kids = this.rootNode.childrenWithName("uk_1");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        AstNode constraintNode = (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:tableElementConstraint"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", TeiidDdlConstants.TeiidReservedWord.UNIQUE.toDdl());
        List refs = (List)constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)refs.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)refs, (Matcher)CoreMatchers.hasItem((Object)col1Node));
    }

    @Test
    public void shouldParseUnnamedUniqueConstraint() {
        AstNode col1Node = new AstNode(this.rootNode, "col1");
        String content = "UNIQUE (col1)";
        Assert.assertThat((Object)this.parser.parseTableBodyConstraint(this.getTokens("UNIQUE (col1)"), this.rootNode), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)2));
        List kids = this.rootNode.childrenWithName("UC_1");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        AstNode constraintNode = (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:tableElementConstraint"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", TeiidDdlConstants.TeiidReservedWord.UNIQUE.toDdl());
        List refs = (List)constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)refs.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)refs, (Matcher)CoreMatchers.hasItem((Object)col1Node));
    }

    @Test
    public void shouldParseNamedAccessPatternConstraint() {
        AstNode col1Node = new AstNode(this.rootNode, "col1");
        AstNode col2Node = new AstNode(this.rootNode, "col2");
        String content = "CONSTRAINT ap_1 ACCESSPATTERN (col1, col2)";
        Assert.assertThat((Object)this.parser.parseTableBodyConstraint(this.getTokens("CONSTRAINT ap_1 ACCESSPATTERN (col1, col2)"), this.rootNode), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)3));
        List kids = this.rootNode.childrenWithName("ap_1");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        AstNode constraintNode = (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:tableElementConstraint"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", TeiidDdlConstants.TeiidNonReservedWord.ACCESSPATTERN.toDdl());
        List refs = (List)constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)refs.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)refs, (Matcher)CoreMatchers.hasItems((Object[])new AstNode[]{col1Node, col2Node}));
    }

    @Test
    public void shouldParseUnnamedAccessPatternConstraint() {
        AstNode col1Node = new AstNode(this.rootNode, "col1");
        AstNode col2Node = new AstNode(this.rootNode, "col2");
        String content = "ACCESSPATTERN (col1, col2)";
        Assert.assertThat((Object)this.parser.parseTableBodyConstraint(this.getTokens("ACCESSPATTERN (col1, col2)"), this.rootNode), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)3));
        List kids = this.rootNode.childrenWithName("AP_1");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        AstNode constraintNode = (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:tableElementConstraint"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", TeiidDdlConstants.TeiidNonReservedWord.ACCESSPATTERN.toDdl());
        List refs = (List)constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)refs.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)refs, (Matcher)CoreMatchers.hasItems((Object[])new AstNode[]{col1Node, col2Node}));
    }

    @Test
    public void shouldParseNamedForeignKeyConstraintWithReferencesRefs() {
        AstNode tableNode = new AstNode(this.rootNode, "tableWithForeignKey");
        String col1 = "col1";
        String col2 = "col2";
        AstNode col1Node = new AstNode(tableNode, "col1");
        AstNode col2Node = new AstNode(tableNode, "col2");
        String refTable = "refTable";
        AstNode refTableNode = new AstNode(this.rootNode, "refTable");
        refTableNode.setProperty("jcr:primaryType", (Object)"teiidddl:createTable");
        String refCol1 = "refCol1";
        String refCol2 = "refCol2";
        AstNode refCol1Node = new AstNode(refTableNode, "refCol1");
        AstNode refCol2Node = new AstNode(refTableNode, "refCol2");
        String name = "fk_1";
        String content = "CONSTRAINT fk_1 FOREIGN KEY (col1, col2) REFERENCES refTable(refCol1,refCol2)";
        Assert.assertThat((Object)this.parser.parseTableBodyConstraint(this.getTokens("CONSTRAINT fk_1 FOREIGN KEY (col1, col2) REFERENCES refTable(refCol1,refCol2)"), tableNode), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)tableNode.getChildCount(), (Matcher)Is.is((Object)3));
        List kids = tableNode.childrenWithName("fk_1");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        AstNode constraintNode = (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:foreignKeyConstraint"));
        Assert.assertThat((Object)constraintNode.getName(), (Matcher)Is.is((Object)"fk_1"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", "FOREIGN KEY");
        this.assertProperty(constraintNode, "teiidddl:tableRef", refTableNode);
        List refs = (List)constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)refs.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)refs, (Matcher)CoreMatchers.hasItems((Object[])new AstNode[]{col1Node, col2Node}));
        List refRefs = (List)constraintNode.getProperty("teiidddl:tableRefElementRefs");
        Assert.assertThat((Object)refRefs.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)refRefs, (Matcher)CoreMatchers.hasItems((Object[])new AstNode[]{refCol1Node, refCol2Node}));
    }

    @Test
    public void shouldParseNamedForeignKeyConstraintNoReferencesRefs() {
        AstNode tableNode = new AstNode(this.rootNode, "tableWithForeignKey");
        String col1 = "col1";
        String col2 = "col2";
        AstNode col1Node = new AstNode(tableNode, "col1");
        AstNode col2Node = new AstNode(tableNode, "col2");
        String refTable = "refTable";
        AstNode refTableNode = new AstNode(this.rootNode, "refTable");
        refTableNode.setProperty("jcr:primaryType", (Object)"teiidddl:createTable");
        String name = "fk_1";
        String content = "CONSTRAINT fk_1 FOREIGN KEY (col1, col2) REFERENCES refTable";
        Assert.assertThat((Object)this.parser.parseTableBodyConstraint(this.getTokens("CONSTRAINT fk_1 FOREIGN KEY (col1, col2) REFERENCES refTable"), tableNode), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)tableNode.getChildCount(), (Matcher)Is.is((Object)3));
        List kids = tableNode.childrenWithName("fk_1");
        Assert.assertThat((Object)kids.size(), (Matcher)Is.is((Object)1));
        AstNode constraintNode = (AstNode)kids.get(0);
        Assert.assertThat((Object)constraintNode.getMixins(), (Matcher)CoreMatchers.hasItem((Object)"teiidddl:foreignKeyConstraint"));
        Assert.assertThat((Object)constraintNode.getName(), (Matcher)Is.is((Object)"fk_1"));
        this.assertProperty(constraintNode, "teiidddl:constraintType", "FOREIGN KEY");
        this.assertProperty(constraintNode, "teiidddl:tableRef", refTableNode);
        List refs = (List)constraintNode.getProperty("teiidddl:tableElementRefs");
        Assert.assertThat((Object)refs.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)refs, (Matcher)CoreMatchers.hasItems((Object[])new AstNode[]{col1Node, col2Node}));
        List refRefs = (List)constraintNode.getProperty("teiidddl:tableRefElementRefs");
        Assert.assertThat((Object)refRefs, (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseQueryExpression() {
        String content = "WITH X (Y, Z) AS (SELECT 1, 2)";
        Assert.assertThat((Object)this.parser.parseQueryExpression(this.getTokens("WITH X (Y, Z) AS (SELECT 1, 2)"), this.rootNode), (Matcher)Is.is((Object)true));
        this.assertProperty(this.rootNode, "teiidddl:queryExpression", "WITH X (Y, Z) AS (SELECT 1, 2)");
    }

    @Test
    public void shouldNotParseEmptyQueryExpression() {
        Assert.assertThat((Object)this.parser.parseQueryExpression(this.getTokens(""), this.rootNode), (Matcher)Is.is((Object)false));
    }

    @Test(expected=ParsingException.class)
    public void shouldNotParseEmptyIdentifierList() {
        String content = "()";
        this.parser.parseIdentifierList(this.getTokens("()"));
    }

    @Test
    public void shouldParseIdentifierListWithOneElement() {
        String id = "a";
        String content = "(a)";
        List idList = this.parser.parseIdentifierList(this.getTokens("(a)"));
        Assert.assertThat((Object)idList.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(idList.get(0), (Matcher)Is.is((Object)"a"));
    }

    @Test
    public void shouldParseIdentifierListWithMultipleElements() {
        String a = "a";
        String b = "b";
        String c = "c";
        String content = "(a,b,c)";
        List idList = this.parser.parseIdentifierList(this.getTokens("(a,b,c)"));
        Assert.assertThat((Object)idList.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat(idList.get(0), (Matcher)Is.is((Object)"a"));
        Assert.assertThat(idList.get(1), (Matcher)Is.is((Object)"b"));
        Assert.assertThat(idList.get(2), (Matcher)Is.is((Object)"c"));
    }

    @Test
    public void shouldParseExpressionLists() {
        Assert.assertThat((Object)CreateTableParser.contains((String)"UPPER(e2)", (String)"e2"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)CreateTableParser.contains((String)"UPPER(e2)", (String)"E2"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)CreateTableParser.contains((String)"UPPER(e1, e2)", (String)"e3"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)CreateTableParser.contains((String)"abc, def", (String)"def"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)CreateTableParser.contains((String)"abc, def", (String)"DEF"), (Matcher)Is.is((Object)true));
    }
}

