/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.ParsingException;
import org.modeshape.sequencer.ddl.DdlParser;
import org.modeshape.sequencer.ddl.DdlParserTestHelper;
import org.modeshape.sequencer.ddl.DdlParsers;
import org.modeshape.sequencer.ddl.dialect.oracle.OracleDdlParser;
import org.modeshape.sequencer.ddl.dialect.postgres.PostgresDdlParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParser;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.modeshape.sequencer.ddl.node.AstNodeFactory;

public class DdlParsersTest
extends DdlParserTestHelper {
    private DdlParsers parsers;
    public static final String DDL_TEST_FILE_PATH = "ddl/";

    @Before
    public void beforeEach() {
        this.parsers = new DdlParsers();
    }

    @Test
    public void shouldParseUntypedDdlFileWithTypeInFilename() {
        this.printTest("shouldParseUntypedDdlFileWithTypeInFilename()");
        String content = "-- SAMPLE DDL FILE\nCREATE TABLE myTableName (PART_COLOR VARCHAR(255) NOT NULL, PART_ID INTEGER DEFAULT (100))\nDROP TABLE list_customers CASCADE";
        this.rootNode = this.parsers.parse(content, "someSQL92.ddl");
        Assert.assertEquals((Object)"SQL92", (Object)this.rootNode.getProperty("ddl:parserId"));
    }

    @Test
    public void shouldParseTypedDdlFileWith() {
        this.printTest("shouldParseTypedDdlFileWith()");
        String content = "-- SAMPLE SQL92 DDL FILE\nCREATE TABLE myTableName (PART_COLOR VARCHAR(255) NOT NULL, PART_ID INTEGER DEFAULT (100))\nDROP TABLE list_customers CASCADE";
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertEquals((Object)"SQL92", (Object)this.rootNode.getProperty("ddl:parserId"));
    }

    @Test
    public void shouldParseUntypedDdlFile() {
        this.printTest("shouldParseUntypedDdlFile()");
        String content = "\n-- SAMPLE DDL FILE\nCREATE TABLE myTableName (PART_COLOR VARCHAR(255) NOT NULL, PART_ID INTEGER DEFAULT (100))\nDROP TABLE list_customers CASCADE";
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertEquals((Object)"SQL92", (Object)this.rootNode.getProperty("ddl:parserId"));
    }

    @Test
    public void shouldParseUntypedDerbyFile() {
        this.printTest("shouldParseUntypedDerbyFile()");
        String content = this.getFileContent("ddl/dialect/derby/derby_test_statements.ddl");
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertEquals((Object)"DERBY", (Object)this.rootNode.getProperty("ddl:parserId"));
    }

    @Test
    public void shouldParseTypedDerbyFile() {
        this.printTest("shouldParseTypedDerbyFile()");
        String content = this.getFileContent("ddl/dialect/derby/derby_test_statements_typed.ddl");
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertEquals((Object)"DERBY", (Object)this.rootNode.getProperty("ddl:parserId"));
    }

    @Test
    public void shouldParseUntypedOracleFile() {
        this.printTest("shouldParseUntypedOracleFile()");
        String content = this.getFileContent("ddl/dialect/oracle/oracle_test_statements_3.ddl");
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertEquals((Object)"ORACLE", (Object)this.rootNode.getProperty("ddl:parserId"));
    }

    @Test
    public void shouldParseUntypedPostgresFile() {
        this.printTest("shouldParseUntypedPostgresFile()");
        String content = this.getFileContent("ddl/dialect/postgres/postgres_test_statements_1.ddl");
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertThat((Object)"POSTGRES", (Matcher)Is.is((Object)((String)this.rootNode.getProperty("ddl:parserId"))));
    }

    @Test
    public void shouldParseUnterminatedOracleFile() {
        this.printTest("shouldParseUnterminatedOracleFile()");
        String content = this.getFileContent("ddl/GFM_Physical.ddl");
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertEquals((Object)"ORACLE", (Object)this.rootNode.getProperty("ddl:parserId"));
        this.setPrintToConsole(true);
        AstNodeFactory nodeFactory = new AstNodeFactory();
        List problems = nodeFactory.getChildrenForType(this.rootNode, "ddl:ddlProblem");
        for (AstNode problem : problems) {
            this.printTest(problem.toString());
        }
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)123));
        List schemaNodes = nodeFactory.getChildrenForType(this.rootNode, "ddl:createSchemaStatement");
        Assert.assertThat((Object)schemaNodes.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((AstNode)schemaNodes.get(0)).getChildCount(), (Matcher)Is.is((Object)53));
        Assert.assertThat((Object)((AstNode)schemaNodes.get(0)).getName(), (Matcher)Is.is((Object)"GLOBALFORCEMGMT"));
        List alterNodes = nodeFactory.getChildrenForType(this.rootNode, "ddl:alterTableStatement");
        Assert.assertThat((Object)alterNodes.size(), (Matcher)Is.is((Object)120));
        List dropSchemaNodes = nodeFactory.getChildrenForType(this.rootNode, "ddl:dropSchemaStatement");
        Assert.assertThat((Object)dropSchemaNodes.size(), (Matcher)Is.is((Object)1));
        List unknownNodes = nodeFactory.getChildrenForType(this.rootNode, "ddl:unknownStatement");
        Assert.assertThat((Object)unknownNodes.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseFileUsingTeiidParser() {
        this.printTest("shouldParseTeiidFile()");
        String content = this.getFileContent("ddl/dialect/teiid/mySqlBqt.ddl");
        this.rootNode = this.parsers.parseUsing(content, "TEIID");
        Assert.assertThat((Object)"TEIID", (Matcher)Is.is((Object)((String)this.rootNode.getProperty("ddl:parserId"))));
    }

    @Test(expected=ParsingException.class)
    public void shouldErrorWhenInvalidParserId() {
        this.printTest("shouldParseTeiidFile()");
        String content = this.getFileContent("ddl/dialect/teiid/mySqlBqt.ddl");
        this.parsers.parseUsing(content, "BOGUS");
    }

    @Test
    public void shouldParseHugeOracleFile() {
        this.printTest("shouldParseHugeOracleFile()");
        String content = this.getFileContent("ddl/dialect/oracle/huge.ddl");
        this.rootNode = this.parsers.parse(content, null);
        Assert.assertThat((Object)"ORACLE", (Matcher)Is.is((Object)((String)this.rootNode.getProperty("ddl:parserId"))));
    }

    @Test
    public void shouldReturnBuiltInParsers() {
        this.printTest("shouldReturnBuiltInParsers()");
        Assert.assertThat((Object)this.parsers.getParsers(), (Matcher)CoreMatchers.hasItems((Object[])DdlParsers.BUILTIN_PARSERS.toArray(new DdlParser[DdlParsers.BUILTIN_PARSERS.size()])));
    }

    @Test
    public void shouldReturnParsersConstructedWith() {
        this.printTest("shouldReturnParsersConstructedWith()");
        ArrayList<TeiidDdlParser> myParsers = new ArrayList<TeiidDdlParser>();
        myParsers.add(new TeiidDdlParser());
        DdlParsers ddlParsers = new DdlParsers(myParsers);
        Assert.assertThat((Object)ddlParsers.getParsers(), (Matcher)CoreMatchers.hasItems((Object[])myParsers.toArray(new DdlParser[myParsers.size()])));
    }

    @Test
    public void shouldReturnResultsInOrder() {
        this.printTest("shouldReturnResultsInOrder()");
        String ddl = this.getFileContent("ddl/dialect/oracle/oracle_test_statements_3.ddl");
        List results = this.parsers.parseUsingAll(ddl);
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)DdlParsers.BUILTIN_PARSERS.size()));
        Assert.assertThat((Object)((DdlParsers.ParsingResult)results.get(0)).getParserId(), (Matcher)Is.is((Object)"ORACLE"));
        ddl = this.getFileContent("ddl/dialect/teiid/mySqlBqt.ddl");
        results = this.parsers.parseUsingAll(ddl);
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)DdlParsers.BUILTIN_PARSERS.size()));
        Assert.assertThat((Object)((DdlParsers.ParsingResult)results.get(0)).getParserId(), (Matcher)Is.is((Object)"TEIID"));
    }

    @Test
    public void shouldReturnCorrectNumberOfResults() {
        this.printTest("shouldReturnCorrectNumberOfResults()");
        ArrayList<Object> myParsers = new ArrayList<Object>(2);
        myParsers.add(new PostgresDdlParser());
        myParsers.add(new OracleDdlParser());
        DdlParsers ddlParsers = new DdlParsers(myParsers);
        String ddl = this.getFileContent("ddl/dialect/oracle/oracle_test_statements_3.ddl");
        List results = ddlParsers.parseUsing(ddl, ((DdlParser)myParsers.get(0)).getId(), ((DdlParser)myParsers.get(1)).getId(), (String[])null);
        Assert.assertThat((Object)results.size(), (Matcher)Is.is((Object)myParsers.size()));
    }

    @Test(expected=ParsingException.class)
    public void shouldNotAllowInvalidParserId() {
        this.printTest("shouldNotAllowInvalidParserId()");
        String ddl = this.getFileContent("ddl/dialect/oracle/oracle_test_statements_3.ddl");
        this.parsers.parseUsing(ddl, ((DdlParser)this.parsers.getParsers().iterator().next()).getId(), "bogusId", (String[])null);
    }
}

