/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.sequencer.ddl.dialect.teiid.CreateTableParser;
import org.modeshape.sequencer.ddl.dialect.teiid.CreateTriggerParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlTest;
import org.modeshape.sequencer.ddl.node.AstNode;

public class CreateTriggerParserTest
extends TeiidDdlTest {
    private CreateTriggerParser parser;
    private AstNode rootNode;
    private AstNode tableRefNode;

    @Before
    public void beforeEach() {
        TeiidDdlParser teiidDdlParser = new TeiidDdlParser();
        this.parser = new CreateTriggerParser(teiidDdlParser);
        this.rootNode = teiidDdlParser.nodeFactory().node("ddlRootNode");
        CreateTableParser tableParser = new CreateTableParser(teiidDdlParser);
        String content = "CREATE FOREIGN TABLE foo(col1 string, col2 string)";
        this.tableRefNode = tableParser.parse(this.getTokens("CREATE FOREIGN TABLE foo(col1 string, col2 string)"), this.rootNode);
    }

    @Test
    public void shouldParseUnresolvedTableReference() {
        String content = "CREATE TRIGGER ON missingTable INSTEAD OF DELETE AS FOR EACH ROW DELETE FROM x WHERE foo = 'bar';";
        AstNode triggerNode = this.parser.parse(this.getTokens("CREATE TRIGGER ON missingTable INSTEAD OF DELETE AS FOR EACH ROW DELETE FROM x WHERE foo = 'bar';"), this.rootNode);
        Assert.assertThat((Object)triggerNode.getName(), (Matcher)Is.is((Object)"missingTable"));
        this.assertMixinType(triggerNode, "teiidddl:createTrigger");
        this.assertProperty(triggerNode, "teiidddl:insteadOf", "DELETE");
        this.assertProperty(triggerNode, "teiidddl:atomic", true);
        Assert.assertThat((Object)triggerNode.getProperty("teiidddl:tableRef"), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseCreateTriggerDelete() {
        String content = "CREATE TRIGGER ON foo INSTEAD OF DELETE AS FOR EACH ROW DELETE FROM x WHERE foo = 'bar';";
        AstNode triggerNode = this.parser.parse(this.getTokens("CREATE TRIGGER ON foo INSTEAD OF DELETE AS FOR EACH ROW DELETE FROM x WHERE foo = 'bar';"), this.rootNode);
        Assert.assertThat((Object)triggerNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(triggerNode, "teiidddl:createTrigger");
        this.assertProperty(triggerNode, "teiidddl:insteadOf", "DELETE");
        this.assertProperty(triggerNode, "teiidddl:atomic", true);
        this.assertProperty(triggerNode, "teiidddl:tableRef", this.tableRefNode);
        Assert.assertThat((Object)triggerNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)triggerNode.getChild(0).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(0), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(0), "teiidddl:action", "DELETE FROM x WHERE foo = 'bar';");
    }

    @Test
    public void shouldParseCreateTriggerDeleteWithAtomicBeginBlockOneStatement() {
        String content = "CREATE TRIGGER ON foo INSTEAD OF DELETE AS FOR EACH ROW BEGIN ATOMIC DELETE FROM x WHERE foo = 'bar'; END";
        AstNode triggerNode = this.parser.parse(this.getTokens("CREATE TRIGGER ON foo INSTEAD OF DELETE AS FOR EACH ROW BEGIN ATOMIC DELETE FROM x WHERE foo = 'bar'; END"), this.rootNode);
        Assert.assertThat((Object)triggerNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(triggerNode, "teiidddl:createTrigger");
        this.assertProperty(triggerNode, "teiidddl:insteadOf", "DELETE");
        this.assertProperty(triggerNode, "teiidddl:atomic", true);
        this.assertProperty(triggerNode, "teiidddl:tableRef", this.tableRefNode);
        Assert.assertThat((Object)triggerNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)triggerNode.getChild(0).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(0), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(0), "teiidddl:action", "DELETE FROM x WHERE foo = 'bar';");
    }

    @Test
    public void shouldParseCreateTriggerDeleteWithBeginBlockOneStatement() {
        String content = "CREATE TRIGGER ON foo INSTEAD OF DELETE AS FOR EACH ROW BEGIN DELETE FROM x WHERE foo = 'bar'; END";
        AstNode triggerNode = this.parser.parse(this.getTokens("CREATE TRIGGER ON foo INSTEAD OF DELETE AS FOR EACH ROW BEGIN DELETE FROM x WHERE foo = 'bar'; END"), this.rootNode);
        Assert.assertThat((Object)triggerNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(triggerNode, "teiidddl:createTrigger");
        this.assertProperty(triggerNode, "teiidddl:insteadOf", "DELETE");
        this.assertProperty(triggerNode, "teiidddl:atomic", false);
        this.assertProperty(triggerNode, "teiidddl:tableRef", this.tableRefNode);
        Assert.assertThat((Object)triggerNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)triggerNode.getChild(0).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(0), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(0), "teiidddl:action", "DELETE FROM x WHERE foo = 'bar';");
    }

    @Test
    public void shouldParseCreateTriggerDeleteWithBeginBlockTwoStatements() {
        String content = "CREATE TRIGGER ON foo INSTEAD OF DELETE AS FOR EACH ROW BEGIN DELETE FROM x WHERE foo = 'bar'; DELETE FROM x WHERE bar = 'foo'; END";
        AstNode triggerNode = this.parser.parse(this.getTokens("CREATE TRIGGER ON foo INSTEAD OF DELETE AS FOR EACH ROW BEGIN DELETE FROM x WHERE foo = 'bar'; DELETE FROM x WHERE bar = 'foo'; END"), this.rootNode);
        Assert.assertThat((Object)triggerNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(triggerNode, "teiidddl:createTrigger");
        this.assertProperty(triggerNode, "teiidddl:insteadOf", "DELETE");
        this.assertProperty(triggerNode, "teiidddl:atomic", false);
        this.assertProperty(triggerNode, "teiidddl:tableRef", this.tableRefNode);
        Assert.assertThat((Object)triggerNode.getChildCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)triggerNode.getChild(0).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(0), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(0), "teiidddl:action", "DELETE FROM x WHERE foo = 'bar';");
        Assert.assertThat((Object)triggerNode.getChild(1).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(1), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(1), "teiidddl:action", "DELETE FROM x WHERE bar = 'foo';");
    }

    @Test
    public void shouldParseCreateTriggerInsert() {
        String content = "CREATE TRIGGER ON foo INSTEAD OF INSERT AS FOR EACH ROW insert into g1 (e1, e2) values (1, 'trig');";
        AstNode triggerNode = this.parser.parse(this.getTokens("CREATE TRIGGER ON foo INSTEAD OF INSERT AS FOR EACH ROW insert into g1 (e1, e2) values (1, 'trig');"), this.rootNode);
        Assert.assertThat((Object)triggerNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(triggerNode, "teiidddl:createTrigger");
        this.assertProperty(triggerNode, "teiidddl:insteadOf", "INSERT");
        this.assertProperty(triggerNode, "teiidddl:atomic", true);
        this.assertProperty(triggerNode, "teiidddl:tableRef", this.tableRefNode);
        Assert.assertThat((Object)triggerNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)triggerNode.getChild(0).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(0), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(0), "teiidddl:action", "insert into g1 (e1, e2) values (1, 'trig');");
    }

    @Test
    public void shouldParseCreateTriggerInsertWithAtomicBeginBlockOneStatement() {
        String content = "CREATE TRIGGER ON foo INSTEAD OF INSERT AS FOR EACH ROW BEGIN ATOMIC insert into g1 (e1, e2) values (1, 'trig'); END";
        AstNode triggerNode = this.parser.parse(this.getTokens("CREATE TRIGGER ON foo INSTEAD OF INSERT AS FOR EACH ROW BEGIN ATOMIC insert into g1 (e1, e2) values (1, 'trig'); END"), this.rootNode);
        Assert.assertThat((Object)triggerNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(triggerNode, "teiidddl:createTrigger");
        this.assertProperty(triggerNode, "teiidddl:insteadOf", "INSERT");
        this.assertProperty(triggerNode, "teiidddl:atomic", true);
        this.assertProperty(triggerNode, "teiidddl:tableRef", this.tableRefNode);
        Assert.assertThat((Object)triggerNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)triggerNode.getChild(0).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(0), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(0), "teiidddl:action", "insert into g1 (e1, e2) values (1, 'trig');");
    }

    @Test
    public void shouldParseCreateTriggerInsertWithBeginBlockOneStatement() {
        String content = "CREATE TRIGGER ON foo INSTEAD OF INSERT AS FOR EACH ROW BEGIN insert into g1 (e1, e2) values (1, 'trig'); END";
        AstNode triggerNode = this.parser.parse(this.getTokens("CREATE TRIGGER ON foo INSTEAD OF INSERT AS FOR EACH ROW BEGIN insert into g1 (e1, e2) values (1, 'trig'); END"), this.rootNode);
        Assert.assertThat((Object)triggerNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(triggerNode, "teiidddl:createTrigger");
        this.assertProperty(triggerNode, "teiidddl:insteadOf", "INSERT");
        this.assertProperty(triggerNode, "teiidddl:atomic", false);
        this.assertProperty(triggerNode, "teiidddl:tableRef", this.tableRefNode);
        Assert.assertThat((Object)triggerNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)triggerNode.getChild(0).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(0), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(0), "teiidddl:action", "insert into g1 (e1, e2) values (1, 'trig');");
    }

    @Test
    public void shouldParseCreateTriggerInsertWithBeginBlockTwoStatements() {
        String content = "CREATE TRIGGER ON foo INSTEAD OF INSERT AS FOR EACH ROW BEGIN insert into g1 (e1, e2) values (1, 'trig'); insert into g1 (e1, e2) values (2, 'hammer'); END";
        AstNode triggerNode = this.parser.parse(this.getTokens("CREATE TRIGGER ON foo INSTEAD OF INSERT AS FOR EACH ROW BEGIN insert into g1 (e1, e2) values (1, 'trig'); insert into g1 (e1, e2) values (2, 'hammer'); END"), this.rootNode);
        Assert.assertThat((Object)triggerNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(triggerNode, "teiidddl:createTrigger");
        this.assertProperty(triggerNode, "teiidddl:insteadOf", "INSERT");
        this.assertProperty(triggerNode, "teiidddl:atomic", false);
        this.assertProperty(triggerNode, "teiidddl:tableRef", this.tableRefNode);
        Assert.assertThat((Object)triggerNode.getChildCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)triggerNode.getChild(0).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(0), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(0), "teiidddl:action", "insert into g1 (e1, e2) values (1, 'trig');");
        Assert.assertThat((Object)triggerNode.getChild(1).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(1), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(1), "teiidddl:action", "insert into g1 (e1, e2) values (2, 'hammer');");
    }

    @Test
    public void shouldParseCreateTriggerUpdate() {
        String content = "CREATE TRIGGER ON foo INSTEAD OF UPDATE AS FOR EACH ROW UPDATE x SET foo = 'bar';";
        AstNode triggerNode = this.parser.parse(this.getTokens("CREATE TRIGGER ON foo INSTEAD OF UPDATE AS FOR EACH ROW UPDATE x SET foo = 'bar';"), this.rootNode);
        Assert.assertThat((Object)triggerNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(triggerNode, "teiidddl:createTrigger");
        this.assertProperty(triggerNode, "teiidddl:insteadOf", "UPDATE");
        this.assertProperty(triggerNode, "teiidddl:atomic", true);
        this.assertProperty(triggerNode, "teiidddl:tableRef", this.tableRefNode);
        Assert.assertThat((Object)triggerNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)triggerNode.getChild(0).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(0), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(0), "teiidddl:action", "UPDATE x SET foo = 'bar';");
    }

    @Test
    public void shouldParseCreateTriggerUpdateWithAtomicBeginBlockOneStatement() {
        String content = "CREATE TRIGGER ON foo INSTEAD OF UPDATE AS FOR EACH ROW BEGIN ATOMIC UPDATE x SET foo = 'bar'; END";
        AstNode triggerNode = this.parser.parse(this.getTokens("CREATE TRIGGER ON foo INSTEAD OF UPDATE AS FOR EACH ROW BEGIN ATOMIC UPDATE x SET foo = 'bar'; END"), this.rootNode);
        Assert.assertThat((Object)triggerNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(triggerNode, "teiidddl:createTrigger");
        this.assertProperty(triggerNode, "teiidddl:insteadOf", "UPDATE");
        this.assertProperty(triggerNode, "teiidddl:atomic", true);
        this.assertProperty(triggerNode, "teiidddl:tableRef", this.tableRefNode);
        Assert.assertThat((Object)triggerNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)triggerNode.getChild(0).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(0), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(0), "teiidddl:action", "UPDATE x SET foo = 'bar';");
    }

    @Test
    public void shouldParseCreateTriggerUpdateWithBeginBlockOneStatement() {
        String content = "CREATE TRIGGER ON foo INSTEAD OF UPDATE AS FOR EACH ROW BEGIN UPDATE x SET foo = 'bar'; END";
        AstNode triggerNode = this.parser.parse(this.getTokens("CREATE TRIGGER ON foo INSTEAD OF UPDATE AS FOR EACH ROW BEGIN UPDATE x SET foo = 'bar'; END"), this.rootNode);
        Assert.assertThat((Object)triggerNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(triggerNode, "teiidddl:createTrigger");
        this.assertProperty(triggerNode, "teiidddl:insteadOf", "UPDATE");
        this.assertProperty(triggerNode, "teiidddl:atomic", false);
        this.assertProperty(triggerNode, "teiidddl:tableRef", this.tableRefNode);
        Assert.assertThat((Object)triggerNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)triggerNode.getChild(0).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(0), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(0), "teiidddl:action", "UPDATE x SET foo = 'bar';");
    }

    @Test
    public void shouldParseCreateTriggerUpdateWithBeginBlockTwoStatements() {
        String content = "CREATE TRIGGER ON foo INSTEAD OF UPDATE AS FOR EACH ROW BEGIN UPDATE x SET foo = 'bar'; UPDATE x SET bar = 'foo'; END";
        AstNode triggerNode = this.parser.parse(this.getTokens("CREATE TRIGGER ON foo INSTEAD OF UPDATE AS FOR EACH ROW BEGIN UPDATE x SET foo = 'bar'; UPDATE x SET bar = 'foo'; END"), this.rootNode);
        Assert.assertThat((Object)triggerNode.getName(), (Matcher)Is.is((Object)"foo"));
        this.assertMixinType(triggerNode, "teiidddl:createTrigger");
        this.assertProperty(triggerNode, "teiidddl:insteadOf", "UPDATE");
        this.assertProperty(triggerNode, "teiidddl:atomic", false);
        this.assertProperty(triggerNode, "teiidddl:tableRef", this.tableRefNode);
        Assert.assertThat((Object)triggerNode.getChildCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)triggerNode.getChild(0).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(0), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(0), "teiidddl:action", "UPDATE x SET foo = 'bar';");
        Assert.assertThat((Object)triggerNode.getChild(1).getName(), (Matcher)Is.is((Object)"rowAction"));
        this.assertMixinType(triggerNode.getChild(1), "teiidddl:triggerRowAction");
        this.assertProperty(triggerNode.getChild(1), "teiidddl:action", "UPDATE x SET bar = 'foo';");
    }
}

