/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.teiid;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.TokenStream;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.datatype.DataType;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDataTypeParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;

public class TeiidDataTypeParserTest {
    private TeiidDataTypeParser parser;

    @Before
    public void beforeEach() {
        this.parser = new TeiidDataTypeParser();
    }

    @Test
    public void shouldParseBigDecimal() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.BIGDECIMAL);
    }

    @Test
    public void shouldParseBigDecimalWithPrecision() {
        this.assertPrecisionAndScale(TeiidDdlConstants.TeiidDataType.BIGDECIMAL, new int[]{9});
    }

    @Test
    public void shouldParseBigDecimalWithPrecisionAndScale() {
        this.assertPrecisionAndScale(TeiidDdlConstants.TeiidDataType.BIGDECIMAL, new int[]{9, 3});
    }

    @Test
    public void shouldParseBigInteger() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.BIGINTEGER);
    }

    @Test
    public void shouldParseBigIntegerWithLength() {
        this.assertLength(TeiidDdlConstants.TeiidDataType.BIGINTEGER, 50L);
    }

    @Test
    public void shouldParseBigInt() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.BIGINT);
    }

    @Test
    public void shouldParseBlob() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.BLOB);
    }

    @Test
    public void shouldParseBlobWithLength() {
        this.assertLength(TeiidDdlConstants.TeiidDataType.BLOB, 50L);
    }

    @Test
    public void shouldParseBoolean() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.BOOLEAN);
    }

    @Test
    public void shouldParseByte() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.BYTE);
    }

    @Test
    public void shouldParseChar() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.CHAR);
    }

    @Test
    public void shouldParseCharWithLength() {
        this.assertLength(TeiidDdlConstants.TeiidDataType.CHAR, 50L);
    }

    @Test
    public void shouldParseClob() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.CLOB);
    }

    @Test
    public void shouldParseClobWithLength() {
        this.assertLength(TeiidDdlConstants.TeiidDataType.CLOB, 50L);
    }

    @Test
    public void shouldParseDate() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.DATE);
    }

    @Test
    public void shouldParseDecimal() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.DECIMAL);
    }

    @Test
    public void shouldParseDecimalWithPrecision() {
        this.assertPrecisionAndScale(TeiidDdlConstants.TeiidDataType.DECIMAL, new int[]{9});
    }

    @Test
    public void shouldParseDecimalWithPrecisionAndScale() {
        this.assertPrecisionAndScale(TeiidDdlConstants.TeiidDataType.DECIMAL, new int[]{9, 3});
    }

    @Test
    public void shouldParseDouble() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.DOUBLE);
    }

    @Test
    public void shouldParseFloat() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.FLOAT);
    }

    @Test
    public void shouldParseInteger() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.INTEGER);
    }

    @Test
    public void shouldParseLong() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.LONG);
    }

    @Test
    public void shouldParseObject() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.OBJECT);
    }

    @Test
    public void shouldParseObjectWithLength() {
        this.assertLength(TeiidDdlConstants.TeiidDataType.OBJECT, 49L);
    }

    @Test
    public void shouldParseReal() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.REAL);
    }

    @Test
    public void shouldParseShort() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.SHORT);
    }

    @Test
    public void shouldParseSmallInt() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.SMALLINT);
    }

    @Test
    public void shouldParseString() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.STRING);
    }

    @Test
    public void shouldParseStringWithLength() {
        this.assertLength(TeiidDdlConstants.TeiidDataType.STRING, 50L);
    }

    @Test
    public void shouldParseTime() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.TIME);
    }

    @Test
    public void shouldParseTimestamp() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.TIMESTAMP);
    }

    @Test
    public void shouldParseTinyInt() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.TINYINT);
    }

    @Test
    public void shouldParseVarBinary() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.VARBINARY);
    }

    @Test
    public void shouldParseVarBinaryWithLength() {
        this.assertLength(TeiidDdlConstants.TeiidDataType.VARBINARY, 50L);
    }

    @Test
    public void shouldParseVarChar() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.VARCHAR);
    }

    @Test
    public void shouldParseVarCharWithLength() {
        this.assertLength(TeiidDdlConstants.TeiidDataType.VARCHAR, 50L);
    }

    @Test
    public void shouldParseXml() {
        this.assertNameAndDefaults(TeiidDdlConstants.TeiidDataType.XML);
    }

    @Test(expected=ParsingException.class)
    public void shouldNotParseInvalidDataType() {
        DdlTokenStream tokens = this.getTokens("invalidDataType");
        this.parser.parse(tokens);
    }

    @Test(expected=ParsingException.class)
    public void shouldNotParseEmptDataType() {
        DdlTokenStream tokens = this.getTokens("");
        this.parser.parse(tokens);
    }

    private void assertNameAndDefaults(TeiidDdlConstants.TeiidDataType dataType) {
        String name = dataType.toDdl();
        DdlTokenStream tokens = this.getTokens(name);
        DataType actual = this.parser.parse(tokens);
        Assert.assertThat((Object)actual.getName(), (Matcher)Is.is((Object)name));
        Assert.assertThat((Object)actual.getLength(), (Matcher)Is.is((Object)-1L));
        Assert.assertThat((Object)actual.getPrecision(), (Matcher)Is.is((Object)-1));
        Assert.assertThat((Object)actual.getScale(), (Matcher)Is.is((Object)-1));
    }

    private void assertLength(TeiidDdlConstants.TeiidDataType dataType, long length) {
        String content = dataType.toDdl() + '(' + length + ')';
        DdlTokenStream tokens = this.getTokens(content);
        DataType actual = this.parser.parse(tokens);
        Assert.assertThat((Object)actual.getLength(), (Matcher)Is.is((Object)length));
    }

    private void assertPrecisionAndScale(TeiidDdlConstants.TeiidDataType dataType, int[] precisionScale) {
        StringBuilder content = new StringBuilder(dataType.toDdl());
        int precision = -1;
        int scale = -1;
        if (precisionScale != null && precisionScale != TeiidDataTypeParser.DEFAULT_PRECISION_SCALE) {
            precision = precisionScale[0];
            content.append('(').append(precisionScale[0]);
            if (precisionScale.length == 2 && precisionScale[1] != -1) {
                scale = precisionScale[1];
                content.append(',').append(precisionScale[1]);
            }
            content.append(')');
        }
        DdlTokenStream tokens = this.getTokens(content.toString());
        DataType actual = this.parser.parse(tokens);
        Assert.assertThat((Object)actual.getPrecision(), (Matcher)Is.is((Object)precision));
        Assert.assertThat((Object)actual.getScale(), (Matcher)Is.is((Object)scale));
    }

    private DdlTokenStream getTokens(String content) {
        DdlTokenStream tokens = new DdlTokenStream(content, (TokenStream.Tokenizer)DdlTokenStream.ddlTokenizer((boolean)false), false);
        tokens.start();
        return tokens;
    }
}

