/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.oracle;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.sequencer.ddl.AbstractDdlSequencerTest;

public class OracleDdlSequencerTest
extends AbstractDdlSequencerTest {
    @Test
    public void shouldSequenceOracleDdl() throws Exception {
        Node statementsNode = this.sequenceDdl("ddl/dialect/oracle/oracle_test_statements_2.ddl");
        Assert.assertThat((Object)statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)50L));
        this.verifyPrimaryType(statementsNode, "nt:unstructured");
        this.verifyProperty(statementsNode, "ddl:parserId", "ORACLE");
        Node createOrReplDirNode = statementsNode.getNode("CREATE OR REPLACE DIRECTORY");
        Assert.assertNotNull((Object)createOrReplDirNode);
        this.verifyBaseProperties(createOrReplDirNode, "nt:unstructured", "164", "1", "3937", 0L);
        this.verifyMixinType(createOrReplDirNode, "oracleddl:createDirectoryStatement");
        Node countriesNode = statementsNode.getNode("countries");
        Assert.assertNotNull((Object)countriesNode);
        this.verifyBaseProperties(countriesNode, "nt:unstructured", "9", "1", "89", 3L);
        this.verifyMixinType(countriesNode, "ddl:alterTableStatement");
        Node duty_pct_node = countriesNode.getNode("duty_pct");
        Assert.assertNotNull((Object)duty_pct_node);
        this.verifyPrimaryType(duty_pct_node, "nt:unstructured");
        this.verifyProperty(duty_pct_node, "ddl:datatypeName", "NUMBER");
        this.verifyProperty(duty_pct_node, "ddl:datatypePrecision", "2");
        this.verifyProperty(duty_pct_node, "ddl:datatypeScale", "2");
        Assert.assertThat((Object)this.verifyHasProperty(duty_pct_node, "ddl:datatypeLength"), (Matcher)Is.is((Object)false));
        this.verifyMixinType(duty_pct_node, "ddl:addColumnDefinition");
        Node check_1_node = countriesNode.getNode("CHECK_1");
        Assert.assertNotNull((Object)check_1_node);
        this.verifyPrimaryType(check_1_node, "nt:unstructured");
        this.verifyProperty(check_1_node, "ddl:constraintType", "CHECK");
        this.verifyMixinType(check_1_node, "ddl:addTableConstraintDefinition");
        this.verifyProperty(check_1_node, "ddl:searchCondition", "( duty_pct < 10 . 5 )");
        Node visa_needed_node = countriesNode.getNode("visa_needed");
        Assert.assertNotNull((Object)visa_needed_node);
        this.verifyPrimaryType(visa_needed_node, "nt:unstructured");
        this.verifyProperty(visa_needed_node, "ddl:datatypeName", "VARCHAR2");
        this.verifyProperty(visa_needed_node, "ddl:datatypeLength", "3");
        this.verifyMixinType(visa_needed_node, "ddl:addColumnDefinition");
        Node app_user1Node = statementsNode.getNode("app_user1");
        Assert.assertNotNull((Object)app_user1Node);
        this.verifyBaseProperties(app_user1Node, "nt:unstructured", "33", "1", "624", 0L);
        this.verifyMixinType(app_user1Node, "oracleddl:alterUserStatement");
    }

    @Test
    public void shouldSequenceOracleCreateProceduresAndFunctions() throws Exception {
        Node statementsNode = this.sequenceDdl("ddl/dialect/oracle/create_procedure_statements.ddl");
        Assert.assertEquals((long)4L, (long)statementsNode.getNodes().getSize());
        Node node = this.findNode(statementsNode, "remove_emp", "oracleddl:createProcedureStatement");
        Assert.assertEquals((long)1L, (long)node.getNodes().getSize());
        Node paramNode = this.findNode(node, "employee_id", "oracleddl:functionParameter");
        this.verifyProperty(paramNode, "ddl:datatypeName", "NUMBER");
        node = this.findNode(statementsNode, "find_root", "oracleddl:createProcedureStatement");
        Assert.assertEquals((long)1L, (long)node.getNodes().getSize());
        paramNode = this.findNode(node, "x", "oracleddl:functionParameter");
        this.verifyProperty(paramNode, "ddl:datatypeName", "REAL");
        this.verifyProperty(paramNode, "oracleddl:inOutNoCopy", "IN");
        node = this.findNode(statementsNode, "SecondMax", "oracleddl:createFunctionStatement");
        Assert.assertEquals((long)1L, (long)node.getNodes().getSize());
        paramNode = this.findNode(node, "input", "oracleddl:functionParameter");
        this.verifyProperty(paramNode, "ddl:datatypeName", "NUMBER");
        node = this.findNode(statementsNode, "text_length", "oracleddl:createFunctionStatement");
        Assert.assertEquals((long)1L, (long)node.getNodes().getSize());
        this.verifyProperty(node, "ddl:datatypeName", "NUMBER");
        paramNode = this.findNode(node, "a", "oracleddl:functionParameter");
        this.verifyProperty(paramNode, "ddl:datatypeName", "CLOB");
    }

    @Test
    public void shouldSequenceOracleIndexes() throws Exception {
        Node statementsNode = this.sequenceDdl("ddl/dialect/oracle/oracle_indexes.ddl");
        this.verifyPrimaryType(statementsNode, "nt:unstructured");
        this.verifyProperty(statementsNode, "ddl:parserId", "ORACLE");
        Assert.assertThat((Object)statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)10L));
    }

    @Test
    public void shouldParseUnterminatedStatements() throws Exception {
        Node statementsNode = this.sequenceDdl("ddl/dialect/oracle/unterminatedStatements.ddl");
        this.verifyPrimaryType(statementsNode, "nt:unstructured");
        this.verifyProperty(statementsNode, "ddl:parserId", "ORACLE");
        Assert.assertThat((Object)statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)3L));
        NodeIterator itr = statementsNode.getNodes();
        while (itr.hasNext()) {
            this.verifyMixinType(itr.nextNode(), "ddl:createTableStatement");
        }
    }

    @Test
    public void shouldSequenceDbObjectNameWithValidSymbols() throws Exception {
        Node statementsNode = this.sequenceDdl("ddl/dialect/oracle/namesWithSymbols.ddl");
        this.verifyPrimaryType(statementsNode, "nt:unstructured");
        this.verifyProperty(statementsNode, "ddl:parserId", "ORACLE");
        Assert.assertThat((Object)statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)2L));
        Node tableNode = this.findNode(statementsNode, "EL$VIS", "ddl:createTableStatement");
        this.findNode(tableNode, "COL_A", "ddl:columnDefinition");
        this.findNode(tableNode, "COL@B", "ddl:columnDefinition");
        this.findNode(tableNode, "COL#C", "ddl:columnDefinition");
        this.findNode(statementsNode, "IDX$A", "oracleddl:createTableIndexStatement");
    }
}

