/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.derby;

import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.sequencer.ddl.AbstractDdlSequencerTest;

public class DerbyDdlSequencerTest
extends AbstractDdlSequencerTest {
    @Test
    public void shouldSequenceDerbyDdl() throws Exception {
        Node statementsNode = this.sequenceDdl("ddl/dialect/derby/derby_test_statements.ddl");
        Assert.assertThat((Object)statementsNode.getNodes().getSize(), (Matcher)Is.is((Object)64L));
        this.verifyPrimaryType(statementsNode, "nt:unstructured");
        this.verifyProperty(statementsNode, "ddl:parserId", "DERBY");
        Node indexNode = statementsNode.getNode("IXSALE");
        Assert.assertNotNull((Object)indexNode);
        this.verifyBaseProperties(indexNode, "nt:unstructured", "87", "1", "2931", 1L);
        this.verifyMixinType(indexNode, "derbyddl:createIndexStatement");
        this.findNode(indexNode, "SALES", "derbyddl:indexColumnReference");
        Node schemaNode = statementsNode.getNode("FLIGHTS");
        Assert.assertNotNull((Object)schemaNode);
        this.verifyBaseProperties(schemaNode, "nt:unstructured", "98", "1", "3263", 0L);
        this.verifyMixinType(schemaNode, "ddl:createSchemaStatement");
        this.verifyExpression(schemaNode, "CREATE SCHEMA FLIGHTS AUTHORIZATION anita;");
        Node unknownNode_1 = statementsNode.getNode("some_procedure_name");
        Assert.assertNotNull((Object)unknownNode_1);
        this.verifyBaseProperties(unknownNode_1, "nt:unstructured", "172", "1", "5513", 0L);
        this.verifyMixinType(unknownNode_1, "derbyddl:dropProcedureStatement");
        this.verifyExpression(unknownNode_1, "DROP PROCEDURE some_procedure_name;");
        Node alterTableNode = statementsNode.getNode("SAMP.DEPARTMENT");
        Assert.assertNotNull((Object)alterTableNode);
        this.verifyBaseProperties(alterTableNode, "nt:unstructured", "16", "1", "478", 1L);
        this.verifyMixinType(alterTableNode, "ddl:alterTableStatement");
        Node uniqueNode = alterTableNode.getNode("NEW_UNIQUE");
        Assert.assertNotNull((Object)uniqueNode);
        this.verifyPrimaryType(uniqueNode, "nt:unstructured");
        this.verifyProperty(uniqueNode, "ddl:constraintType", "UNIQUE");
        this.verifyMixinType(uniqueNode, "ddl:addTableConstraintDefinition");
        Assert.assertThat((Object)uniqueNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node colRefNode = uniqueNode.getNode("DEPTNO");
        Assert.assertNotNull((Object)colRefNode);
        this.verifyPrimaryType(colRefNode, "nt:unstructured");
        this.verifyMixinType(colRefNode, "ddl:columnReference");
        Node functionNode = this.findNode(statementsNode, "PROPERTY_FILE_READER", "derbyddl:createFunctionStatement");
        this.verifyProperty(functionNode, "ddl:startLineNumber", 71L);
        functionNode = this.findNode(statementsNode, "TO_DEGREES", "derbyddl:createFunctionStatement");
        this.verifyProperty(functionNode, "derbyddl:parameterStyle", "PARAMETER STYLE JAVA");
        Node ttNode = this.findNode(statementsNode, "SESSION.t1", "derbyddl:declareGlobalTemporaryTableStatement");
        Node colNode = this.findNode(ttNode, "c11", new String[0]);
        this.verifyProperty(colNode, "ddl:datatypeName", "int");
        Node lockNode = this.findNode(statementsNode, "FlightAvailability", "derbyddl:lockTableStatement");
        Node optionNode = this.findNode(lockNode, "lockMode", new String[0]);
        this.verifyProperty(optionNode, "ddl:value", "EXCLUSIVE");
        Node renameTableNode = this.findNode(statementsNode, "SAMP.EMP_ACT[2]", "derbyddl:renameTableStatement");
        this.verifyProperty(renameTableNode, "ddl:newName", "EMPLOYEE_ACT");
        Node synonymNode = this.findNode(statementsNode, "SAMP.T1", "derbyddl:createSynonymStatement");
        this.verifyProperty(synonymNode, "derbyddl:tableName", "SAMP.TABLEWITHLONGNAME");
        Node triggerNode = this.findNode(statementsNode, "FLIGHTSDELETE3", "derbyddl:createTriggerStatement");
        this.verifyProperty(triggerNode, "derbyddl:tableName", "FLIGHTS");
        triggerNode = this.findNode(statementsNode, "t1", "derbyddl:createTriggerStatement");
        this.verifyProperty(triggerNode, "derbyddl:tableName", "x");
        optionNode = this.findNode(triggerNode, "forEach", new String[0]);
        this.verifyProperty(optionNode, "ddl:value", "FOR EACH ROW");
        optionNode = this.findNode(triggerNode, "eventType", new String[0]);
        this.verifyProperty(optionNode, "ddl:value", "UPDATE");
        this.findNode(statementsNode, "p", "derbyddl:grantOnProcedureStatement");
        Node grantNode = this.findNode(statementsNode, "grantRoles", "derbyddl:grantRolesStatement");
        this.findNode(grantNode, "george", "ddl:grantee");
    }
}

