/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.image;

import java.io.IOException;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.image.ImageMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageMetadataSequencer
extends Sequencer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageMetadataSequencer.class);

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        ImageMetadata metadata = new ImageMetadata();
        metadata.setInput(binaryValue.getStream());
        metadata.setDetermineImageNumber(true);
        metadata.setCollectComments(true);
        if (!metadata.check()) {
            LOGGER.info("Unknown format detected. Skipping sequencing");
            return false;
        }
        Node imageNode = this.getImageMetadataNode(outputNode);
        this.setImagePropertiesOnNode(imageNode, metadata);
        return true;
    }

    private Node getImageMetadataNode(Node outputNode) throws RepositoryException {
        if (outputNode.isNew()) {
            outputNode.setPrimaryType("image:metadata");
            return outputNode;
        }
        return outputNode.addNode("image:metadata", "image:metadata");
    }

    private void setImagePropertiesOnNode(Node node, ImageMetadata metadata) throws Exception {
        node.setProperty("jcr:mimetype", metadata.getMimeType());
        node.setProperty("image:formatName", metadata.getFormatName());
        node.setProperty("image:width", (long)metadata.getWidth());
        node.setProperty("image:height", (long)metadata.getHeight());
        node.setProperty("image:bitsPerPixel", (long)metadata.getBitsPerPixel());
        node.setProperty("image:progressive", metadata.isProgressive());
        node.setProperty("image:numberOfImages", (long)metadata.getNumberOfImages());
        node.setProperty("image:physicalWidthDpi", (long)metadata.getPhysicalWidthDpi());
        node.setProperty("image:physicalHeightDpi", (long)metadata.getPhysicalHeightDpi());
        node.setProperty("image:physicalWidthInches", (double)metadata.getPhysicalWidthInch());
        node.setProperty("image:physicalHeightInches", (double)metadata.getPhysicalHeightInch());
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        this.registerNodeTypes("images.cnd", nodeTypeManager, true);
    }
}

