/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.image;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class ImageMetadataSequencerTest
extends AbstractSequencerTest {
    @Test
    public void shouldGenerateMetadataForJpegImageFiles() throws Exception {
        String filename = "caution.jpg";
        Node imageNode = this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNodeDifferentLocation = this.getOutputNode(this.rootNode, "sequenced/images/" + filename);
        this.assertMetaDataProperties(sequencedNodeDifferentLocation, "image/jpeg", "jpeg", 48, 48, 24, false, 1, 72, 72, 0.666667, 0.666667);
        Node sequencedNodeSameLocation = this.getOutputNode(imageNode, "image:metadata");
        this.assertMetaDataProperties(sequencedNodeSameLocation, "image/jpeg", "jpeg", 48, 48, 24, false, 1, 72, 72, 0.666667, 0.666667);
    }

    @Test
    public void shouldGenerateMetadataForPngImageFiles() throws Exception {
        String filename = "caution.png";
        Node imageNode = this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNodeDifferentLocation = this.getOutputNode(this.rootNode, "sequenced/images/" + filename);
        this.assertMetaDataProperties(sequencedNodeDifferentLocation, "image/png", "png", 48, 48, 24, false, 1, -1, -1, -1.0, -1.0);
        Node sequencedNodeSameLocation = this.getOutputNode(imageNode, "image:metadata");
        this.assertMetaDataProperties(sequencedNodeSameLocation, "image/png", "png", 48, 48, 24, false, 1, -1, -1, -1.0, -1.0);
    }

    @Test
    public void shouldGenerateMetadataForGifImageFiles() throws Exception {
        String filename = "caution.gif";
        Node imageNode = this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNodeDifferentLocation = this.getOutputNode(this.rootNode, "sequenced/images/" + filename);
        this.assertMetaDataProperties(sequencedNodeDifferentLocation, "image/gif", "gif", 48, 48, 8, false, 1, -1, -1, -1.0, -1.0);
        Node sequencedNodeSameLocation = this.getOutputNode(imageNode, "image:metadata");
        this.assertMetaDataProperties(sequencedNodeSameLocation, "image/gif", "gif", 48, 48, 8, false, 1, -1, -1, -1.0, -1.0);
    }

    @Test
    public void shouldGenerateNoMetadataforPictImageFiles() throws Exception {
        String filename = "caution.pict";
        Node imageNode = this.createNodeWithContentFromFile(filename, filename);
        Assert.assertNull((Object)this.getOutputNode(this.rootNode, "sequenced/images/" + filename, 1));
        Assert.assertNull((Object)this.getOutputNode(imageNode, "image:metadata", 1));
    }

    @Test
    @FixFor(value={"MODE-2021"})
    public void shouldExtractExifInformationFromJpeg() throws Exception {
        String filename = "image_with_exif.jpg";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/images/" + filename);
        Assert.assertNotNull((Object)sequencedNode);
        Node exifNode = sequencedNode.getNode("image:exif");
        Assert.assertEquals((Object)"Top, left side (Horizontal / normal)", (Object)exifNode.getProperty("image:orientation").getString());
        Assert.assertEquals((Object)"NIKON", (Object)exifNode.getProperty("image:make").getString());
        Assert.assertEquals((Object)"E4600", (Object)exifNode.getProperty("image:model").getString());
        Assert.assertEquals((double)300.0, (double)exifNode.getProperty("image:resolution_x").getDouble(), (double)0.0);
        Assert.assertEquals((double)300.0, (double)exifNode.getProperty("image:resolution_y").getDouble(), (double)0.0);
        Assert.assertEquals((Object)"Inch", (Object)exifNode.getProperty("image:unit").getString());
        Assert.assertEquals((Object)"2008:05:08 14:54:46", (Object)exifNode.getProperty("image:datetime").getString());
        Assert.assertEquals((Object)"Adobe Photoshop CS3 Windows", (Object)exifNode.getProperty("image:software").getString());
    }

    @Test
    @FixFor(value={"MODE-1847"})
    public void shouldSequenceTIFFiles() throws Exception {
        String filename = "tif_image.tif";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNodeDifferentLocation = this.getOutputNode(this.rootNode, "sequenced/images/" + filename);
        Assert.assertEquals((Object)"image:metadata", (Object)sequencedNodeDifferentLocation.getProperty("jcr:primaryType").getString());
        Assert.assertEquals((Object)"image/tiff", (Object)sequencedNodeDifferentLocation.getProperty("jcr:mimeType").getString());
    }

    private void assertMetaDataProperties(Node metadataNode, String mimeType, String format, int width, int height, int bitsPerPixel, boolean progressive, int numberOfImages, int physicalWidthDpi, int physicalHeightDpi, double physicalWidthInches, double physicalHeightInches) throws RepositoryException {
        Assert.assertNotNull((Object)metadataNode);
        Assert.assertEquals((Object)"image:metadata", (Object)metadataNode.getProperty("jcr:primaryType").getString());
        Assert.assertEquals((Object)mimeType, (Object)metadataNode.getProperty("jcr:mimeType").getString());
        Assert.assertEquals((Object)format, (Object)metadataNode.getProperty("image:formatName").getString().toLowerCase());
        Assert.assertEquals((long)width, (long)metadataNode.getProperty("image:width").getLong());
        Assert.assertEquals((long)height, (long)metadataNode.getProperty("image:height").getLong());
        Assert.assertEquals((long)bitsPerPixel, (long)metadataNode.getProperty("image:bitsPerPixel").getLong());
        Assert.assertEquals((Object)progressive, (Object)metadataNode.getProperty("image:progressive").getBoolean());
        Assert.assertEquals((long)numberOfImages, (long)metadataNode.getProperty("image:numberOfImages").getLong());
        Assert.assertEquals((long)physicalWidthDpi, (long)metadataNode.getProperty("image:physicalWidthDpi").getLong());
        Assert.assertEquals((long)physicalHeightDpi, (long)metadataNode.getProperty("image:physicalHeightDpi").getLong());
        Assert.assertEquals((double)physicalWidthInches, (double)metadataNode.getProperty("image:physicalWidthInches").getDouble(), (double)1.0E-4);
        Assert.assertEquals((double)physicalHeightInches, (double)metadataNode.getProperty("image:physicalHeightInches").getDouble(), (double)1.0E-4);
    }
}

