/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.BufferReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDirectory;

public class JpegReader
implements MetadataReader {
    public void extract(@NotNull BufferReader reader, @NotNull Metadata metadata) {
        JpegDirectory directory = metadata.getOrCreateDirectory(JpegDirectory.class);
        try {
            short dataPrecision = reader.getUInt8(0);
            directory.setInt(0, dataPrecision);
            int height = reader.getUInt16(1);
            directory.setInt(1, height);
            int width = reader.getUInt16(3);
            directory.setInt(3, width);
            int numberOfComponents = reader.getUInt8(5);
            directory.setInt(5, numberOfComponents);
            int offset = 6;
            for (int i = 0; i < numberOfComponents; ++i) {
                short componentId = reader.getUInt8(offset++);
                short samplingFactorByte = reader.getUInt8(offset++);
                short quantizationTableNumber = reader.getUInt8(offset++);
                JpegComponent component = new JpegComponent(componentId, samplingFactorByte, quantizationTableNumber);
                directory.setObject(6 + i, component);
            }
        }
        catch (BufferBoundsException ex) {
            directory.addError(ex.getMessage());
        }
    }
}

