/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.java;

import java.io.InputStream;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.java.DefaultSourceFileRecorder;
import org.modeshape.sequencer.java.JavaMetadataI18n;
import org.modeshape.sequencer.java.JavaMetadataUtil;
import org.modeshape.sequencer.java.SourceFileRecorder;
import org.modeshape.sequencer.java.metadata.JavaMetadata;

public class JavaMetadataSequencer
implements StreamSequencer {
    private static final SourceFileRecorder DEFAULT_SOURCE_FILE_RECORDER = new DefaultSourceFileRecorder();
    private SourceFileRecorder sourceFileRecorder = DEFAULT_SOURCE_FILE_RECORDER;

    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        try {
            JavaMetadata javaMetadata = JavaMetadata.instance(stream, JavaMetadataUtil.length(stream), null);
            this.sourceFileRecorder.record(context, output, javaMetadata);
        }
        catch (Exception ex) {
            context.getLogger(this.getClass()).error((Throwable)ex, JavaMetadataI18n.errorSequencingFile, new Object[]{context.getInputPath()});
        }
    }

    public void setSourceFileRecorderClassName(String sourceFileRecorderClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (sourceFileRecorderClassName == null) {
            this.sourceFileRecorder = DEFAULT_SOURCE_FILE_RECORDER;
            return;
        }
        Class<?> sourceFileRecorderClass = Class.forName(sourceFileRecorderClassName);
        this.sourceFileRecorder = (SourceFileRecorder)sourceFileRecorderClass.newInstance();
    }

    public void setSourceFileRecorder(SourceFileRecorder sourceFileRecorder) {
        this.sourceFileRecorder = sourceFileRecorder == null ? DEFAULT_SOURCE_FILE_RECORDER : sourceFileRecorder;
    }
}

