/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.java.metadata;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.modeshape.sequencer.java.metadata.AnnotationMetadata;
import org.modeshape.sequencer.java.metadata.FieldMetadata;
import org.modeshape.sequencer.java.metadata.ModifierMetadata;

public abstract class MethodMetadata {
    private String name;
    private FieldMetadata returnType;
    private List<ModifierMetadata> modifiers = new ArrayList<ModifierMetadata>();
    private List<FieldMetadata> parameters = new ArrayList<FieldMetadata>();
    private List<AnnotationMetadata> annotations = new LinkedList<AnnotationMetadata>();

    public abstract boolean isContructor();

    public List<AnnotationMetadata> getAnnotations() {
        return this.annotations;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ModifierMetadata> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(List<ModifierMetadata> modifiers) {
        this.modifiers = modifiers;
    }

    public boolean hasModifierNamed(String modifierName) {
        for (ModifierMetadata modifier : this.modifiers) {
            if (!modifierName.equals(modifier.getName())) continue;
            return true;
        }
        return false;
    }

    public List<FieldMetadata> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<FieldMetadata> parameters) {
        this.parameters = parameters;
    }

    public FieldMetadata getReturnType() {
        return this.returnType;
    }

    public void setReturnType(FieldMetadata returnType) {
        this.returnType = returnType;
    }

    public String getId() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.getName()).append('(');
        boolean first = true;
        for (FieldMetadata parameter : this.parameters) {
            if (first) {
                first = false;
            } else {
                buff.append(", ");
            }
            buff.append(this.shortNameFor(parameter.getName()).replace("[]", " array"));
        }
        buff.append(')');
        return buff.toString();
    }

    private String shortNameFor(String type) {
        assert (type != null);
        int lastDotPos = type.lastIndexOf(46);
        if (lastDotPos < 0) {
            return type;
        }
        return type.substring(lastDotPos + 1);
    }
}

