/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

public class IndexBinaryFolder
extends IndexRequest {
    IContainer folder;

    public IndexBinaryFolder(IContainer folder, IndexManager manager) {
        super(folder.getFullPath(), manager);
        this.folder = folder;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexBinaryFolder) {
            return this.folder.equals(((IndexBinaryFolder)o).folder);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        block19: {
            block16: {
                block17: {
                    block18: {
                        if (this.isCancelled || progressMonitor != null && progressMonitor.isCanceled()) {
                            return true;
                        }
                        if (!this.folder.isAccessible()) {
                            return true;
                        }
                        index = this.manager.getIndexForUpdate(this.containerPath, true, true);
                        if (index == null) {
                            return true;
                        }
                        monitor = index.monitor;
                        if (monitor == null) {
                            return true;
                        }
                        try {
                            monitor.enterRead();
                            paths = index.queryDocumentNames("");
                            max = paths == null ? 0 : paths.length;
                            indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                            if (paths == null) {
                                this.folder.accept(new IResourceProxyVisitor(){

                                    public boolean visit(IResourceProxy proxy) {
                                        if (IndexBinaryFolder.this.isCancelled) {
                                            return false;
                                        }
                                        if (proxy.getType() == 1) {
                                            if (Util.isClassFileName(proxy.getName())) {
                                                IFile file = (IFile)proxy.requestResource();
                                                String containerRelativePath = org.eclipse.jdt.internal.core.util.Util.relativePath(file.getFullPath(), IndexBinaryFolder.this.containerPath.segmentCount());
                                                indexedFileNames.put(containerRelativePath, file);
                                            }
                                            return false;
                                        }
                                        return true;
                                    }
                                }, 0);
                            } else {
                                i = 0;
                                while (i < max) {
                                    indexedFileNames.put(paths[i], "DELETED");
                                    ++i;
                                }
                                indexLastModified = index.getIndexFile().lastModified();
                                this.folder.accept(new IResourceProxyVisitor(){

                                    public boolean visit(IResourceProxy proxy) throws CoreException {
                                        if (IndexBinaryFolder.this.isCancelled) {
                                            return false;
                                        }
                                        if (proxy.getType() == 1) {
                                            IFile file;
                                            URI location;
                                            if (Util.isClassFileName(proxy.getName()) && (location = (file = (IFile)proxy.requestResource()).getLocationURI()) != null) {
                                                String containerRelativePath;
                                                indexedFileNames.put(containerRelativePath, indexedFileNames.get(containerRelativePath = org.eclipse.jdt.internal.core.util.Util.relativePath(file.getFullPath(), IndexBinaryFolder.this.containerPath.segmentCount())) == null || indexLastModified < EFS.getStore((URI)location).fetchInfo().getLastModified() ? file : "OK");
                                            }
                                            return false;
                                        }
                                        return true;
                                    }
                                }, 0);
                            }
                            names = indexedFileNames.keyTable;
                            values = indexedFileNames.valueTable;
                            i = 0;
                            length = names.length;
lbl31:
                            // 2 sources

                            while (i < length) {
                                name = (String)names[i];
                                if (name == null) break block16;
                                if (this.isCancelled) break block17;
                                value = values[i];
                                if (value == "OK") break block16;
                                if (value != "DELETED") break block18;
                                this.manager.remove(name, this.containerPath);
                                break block16;
                            }
                            break block19;
                        }
                        catch (Throwable var13_17) {
                            monitor.exitRead();
                            throw var13_17;
                        }
                        {
                            catch (CoreException e) {
                                if (JobManager.VERBOSE) {
                                    org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + this.folder + " because of the following exception:", System.err);
                                    e.printStackTrace();
                                }
                                this.manager.removeIndex(this.containerPath);
                                break block17;
                            }
                            catch (IOException e) {
                                if (JobManager.VERBOSE) {
                                    org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + this.folder + " because of the following exception:", System.err);
                                    e.printStackTrace();
                                }
                                this.manager.removeIndex(this.containerPath);
                                break block17;
                                break;
                            }
                        }
                    }
                    this.manager.addBinary((IFile)value, this.containerPath);
                    break block16;
                }
                monitor.exitRead();
                return false;
            }
            ++i;
            ** GOTO lbl31
        }
        this.manager.request(new SaveIndex(this.containerPath, this.manager));
        monitor.exitRead();
        return true;
    }

    public int hashCode() {
        return this.folder.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing binary folder " + this.folder.getFullPath();
    }
}

