/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.classfile.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import org.modeshape.sequencer.classfile.metadata.AnnotationMetadata;
import org.modeshape.sequencer.classfile.metadata.Visibility;

public class MethodMetadata
implements Comparable<MethodMetadata> {
    private final MethodInfo method;
    private final String name;
    private final List<AnnotationMetadata> annotations;
    private final List<String> parameters;

    MethodMetadata(ClassFile clazz, MethodInfo method) {
        this.method = method;
        this.name = method.isConstructor() ? clazz.getName() : method.getName();
        this.annotations = this.annotationsFor(method);
        this.parameters = this.parametersFor(method);
    }

    private List<String> parametersFor(MethodInfo method) {
        String descriptor = method.getDescriptor();
        int lastParenPos = descriptor.lastIndexOf(41);
        assert (lastParenPos >= 0);
        String parameterString = descriptor.substring(1, lastParenPos);
        if (parameterString.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> parameters = new ArrayList<String>();
        Descriptor.Iterator iter = new Descriptor.Iterator(parameterString);
        assert (iter.hasNext());
        int startPos = iter.next();
        while (iter.hasNext()) {
            int endPos = iter.next();
            parameters.add(Descriptor.toClassName(parameterString.substring(startPos, endPos)));
            startPos = endPos;
        }
        parameters.add(Descriptor.toClassName(parameterString.substring(startPos)));
        return parameters;
    }

    private String returnTypeFor(MethodInfo method) {
        String descriptor = method.getDescriptor();
        int lastParenPos = descriptor.lastIndexOf(41);
        assert (lastParenPos >= 0);
        return Descriptor.toClassName(descriptor.substring(lastParenPos + 1));
    }

    private List<AnnotationMetadata> annotationsFor(MethodInfo method) {
        LinkedList<AnnotationMetadata> annotations = new LinkedList<AnnotationMetadata>();
        for (Object ob : method.getAttributes()) {
            AttributeInfo att = (AttributeInfo)ob;
            if (!(att instanceof AnnotationsAttribute)) continue;
            for (Annotation ann : ((AnnotationsAttribute)att).getAnnotations()) {
                annotations.add(new AnnotationMetadata(ann));
            }
        }
        return annotations;
    }

    private String shortNameFor(String type) {
        int lastDotPos = type.lastIndexOf(46);
        if (lastDotPos < 0) {
            return type;
        }
        return type.substring(lastDotPos + 1);
    }

    public String getName() {
        return this.name;
    }

    public Visibility getVisibility() {
        return Visibility.fromAccessFlags(this.method.getAccessFlags());
    }

    public boolean isConstructor() {
        return this.method.isConstructor();
    }

    public String getReturnType() {
        return this.returnTypeFor(this.method);
    }

    public List<AnnotationMetadata> getAnnotations() {
        return this.annotations;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public boolean isStatic() {
        return 8 == (8 & this.method.getAccessFlags());
    }

    public boolean isFinal() {
        return 16 == (0x10 & this.method.getAccessFlags());
    }

    public boolean isAbstract() {
        return 1024 == (0x400 & this.method.getAccessFlags());
    }

    public boolean isNative() {
        return 256 == (0x100 & this.method.getAccessFlags());
    }

    public boolean isStrictFp() {
        return 2048 == (0x800 & this.method.getAccessFlags());
    }

    public boolean isSynchronized() {
        return 32 == (0x20 & this.method.getAccessFlags());
    }

    @Override
    public int compareTo(MethodMetadata o) {
        if (this.isStatic() && !o.isStatic()) {
            return -1;
        }
        if (!this.isStatic() && o.isStatic()) {
            return 1;
        }
        if (!this.name.equals(o.name)) {
            return this.name.compareTo(o.name);
        }
        if (this.parameters.size() != o.parameters.size()) {
            return Integer.valueOf(this.parameters.size()).compareTo(o.parameters.size());
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            String p2;
            String p1 = this.parameters.get(i);
            if (p1.equals(p2 = o.parameters.get(i))) continue;
            return p1.compareTo(p2);
        }
        return 0;
    }

    public String getId() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.method.getName()).append('(');
        boolean first = false;
        for (String parameter : this.parameters) {
            if (first) {
                first = false;
            } else {
                buff.append(", ");
            }
            buff.append(this.shortNameFor(parameter).replace("[]", " array"));
        }
        buff.append(')');
        return buff.toString();
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (!this.annotations.isEmpty()) {
            for (AnnotationMetadata annotation : this.annotations) {
                buff.append(annotation).append("\n\t");
            }
        }
        buff.append((Object)this.getVisibility());
        if (this.getVisibility() != Visibility.PACKAGE) {
            buff.append(' ');
        }
        if (this.isFinal()) {
            buff.append("final ");
        }
        if (this.isStatic()) {
            buff.append("static ");
        }
        buff.append(this.shortNameFor(this.getReturnType())).append(' ');
        buff.append(this.name).append('(');
        boolean first = true;
        for (String parameter : this.parameters) {
            if (first) {
                first = false;
            } else {
                buff.append(", ");
            }
            buff.append(this.shortNameFor(parameter));
        }
        buff.append(' ');
        buff.append(");");
        return buff.toString();
    }
}

