/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.java;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.sequencer.MockSequencerContext;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.java.ClassSourceFileRecorder;
import org.modeshape.sequencer.java.JavaMetadataSequencer;
import org.modeshape.sequencer.java.SourceFileRecorder;
import org.modeshape.sequencer.java.metadata.JavaMetadata;

public class ClassSourceFileRecorderTest {
    private JavaMetadataSequencer sequencer;
    private InputStream input;
    private MockSequencerOutput output;
    private StreamSequencerContext context;

    @Before
    public void beforeEach() throws Exception {
        this.sequencer = new JavaMetadataSequencer();
        this.context = new MockSequencerContext();
        this.context.getNamespaceRegistry().register("class", "http://www.modeshape.org/sequencer/classfile/1.0");
        this.context.getNamespaceRegistry().register("java", "http://www.modeshape.org/sequencer/java/1.0");
        this.context.getNamespaceRegistry().register("nt", "http://www.jcp.org/jcr/nt/1.0");
        this.output = new MockSequencerOutput(this.context);
        this.input = this.getClass().getResourceAsStream("/NodeEntity.javx");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.input != null) {
            try {
                this.input.close();
            }
            finally {
                this.input = null;
            }
        }
    }

    @Test
    public void shouldAllowSettingSourceFileRecorder() throws Exception {
        MockSourceFileRecorder recorder = new MockSourceFileRecorder();
        MockSourceFileRecorder.called = false;
        this.sequencer.setSourceFileRecorder((SourceFileRecorder)recorder);
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)MockSourceFileRecorder.called, (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowSettingSourceFileRecorderByName() throws Exception {
        MockSourceFileRecorder.called = false;
        this.sequencer.setSourceFileRecorderClassName(MockSourceFileRecorder.class.getName());
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)MockSourceFileRecorder.called, (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldAllowSettingSourceFileRecorderToDefaultByName() throws Exception {
        MockSourceFileRecorder.called = false;
        this.sequencer.setSourceFileRecorderClassName(MockSourceFileRecorder.class.getName());
        this.sequencer.setSourceFileRecorderClassName(null);
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)MockSourceFileRecorder.called, (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldAllowSettingSourceFileRecorderToDefault() throws Exception {
        MockSourceFileRecorder.called = false;
        this.sequencer.setSourceFileRecorder((SourceFileRecorder)new MockSourceFileRecorder());
        this.sequencer.setSourceFileRecorder(null);
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
        Assert.assertThat((Object)MockSourceFileRecorder.called, (Matcher)Is.is((Object)false));
    }

    @Test(expected=ClassCastException.class)
    public void shouldNotAllowSettingSourceFileRecorderToInvalidClass() throws Exception {
        this.sequencer.setSourceFileRecorderClassName(Object.class.getName());
    }

    @Test
    public void shouldParseJavaFileWithClassSourceFileRecorder() throws Exception {
        this.sequencer.setSourceFileRecorder((SourceFileRecorder)new ClassSourceFileRecorder());
        this.sequencer.sequence(this.input, (SequencerOutput)this.output, this.context);
    }

    public static class MockSourceFileRecorder
    implements SourceFileRecorder {
        static boolean called = false;

        public void record(StreamSequencerContext context, SequencerOutput output, JavaMetadata javaMetadata) {
            called = true;
        }
    }
}

